/*
 * Decompiled with CFR 0.152.
 */
package animal.editor;

import animal.editor.AbstractTextEditor;
import animal.editor.Editor;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTIntArray;
import animal.graphics.PTStringArray;
import animal.gui.DrawCanvas;
import animal.main.Animation;
import animal.misc.AnimalTranslator;
import animal.misc.ColorChoice;
import animal.misc.ColorChooserAction;
import animal.misc.EditPoint;
import animal.misc.EditableObject;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import translator.ExtendedActionButton;
import translator.TranslatableGUIElement;

public class StringArrayEditor
extends AbstractTextEditor
implements ChangeListener,
ActionListener,
PropertyChangeListener,
KeyListener {
    private static final long serialVersionUID = 2295451210977833754L;
    private ColorChooserAction colorChooser;
    private ColorChooserAction highlightColorChooser;
    private ColorChooserAction elemHighlightColorChooser;
    private ColorChooserAction outlineColorChooser;
    private ColorChooserAction fontColorChooser;
    private JTextField arraySize;
    private JTextField content;
    private JSpinner arraySpinner;
    private JCheckBox showIndicesCB;
    public static final String ENTRY_LABEL = "entryLabel";
    public static final String BG_COLOR = "bgColorLabel";
    public static final String HIGHLIGHT_COLOR = "highlightColorLabel";
    public static final String ELEM_HIGHLIGHT_COLOR = "elemHighlightColorLabel";
    public static final String OUTLINE_COLOR = "outlineColorLabel";
    public static final String FONT_COLOR = "fontColorLabel";
    public static final String SIZE = "arraySize";
    public static final String ARRAY_CELL = "arrayCell";
    public static final String ARRAY_CONTENTS = "arrayContents";
    public static final String ARRAY_COLORS = "arrayColors";
    public static final String ARRAY_OPTIONS = "options";
    public static final String CONTENT = "cellContent";
    public static final String FONT_LABEL = "fontLabel";
    public static final String FONT = "font";
    public static final String FONT_SIZE = "fontSizeLabel";
    public static final String INDICES_LABEL = "showIndices";

    public StringArrayEditor() {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        this.addBox(this.createArraySizeBox(generator));
        this.addBox(this.createColorBox(generator));
        this.addBox(this.generateFontAndStyleBox(generator, "fontBL"));
        this.finishBoxes();
    }

    private StringArrayEditor(int i) {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        this.addBox(this.createArrayValueBox(generator, i));
        this.addBox(this.createIndicesOptionsBox(generator));
        this.addBox(this.createColorBox(generator));
        this.addBox(this.generateFontAndStyleBox(generator, "fontBL"));
        this.finishBoxes();
    }

    private Box createArraySizeBox(TranslatableGUIElement generator) {
        Box sizeBox = generator.generateBorderedBox(3, "arraySizeBL");
        Box internalBox = new Box(2);
        internalBox.add(generator.generateJLabel(SIZE));
        this.arraySize = new JTextField(8);
        this.arraySize.addActionListener(this);
        internalBox.add(this.arraySize);
        sizeBox.add(internalBox);
        sizeBox.add(this.createIndicesOptionsBox(generator));
        return sizeBox;
    }

    private Box createArrayValueBox(TranslatableGUIElement generator, int targetSize) {
        Box spinnerBox = generator.generateBorderedBox(3, "arrayValuesBL");
        Box elementChoiceBox = new Box(2);
        elementChoiceBox.add(generator.generateJLabel(ARRAY_CELL));
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(0, 0, targetSize - 1, 1);
        this.arraySpinner = new JSpinner(spinnerModel);
        elementChoiceBox.add(this.arraySpinner);
        this.arraySpinner.addChangeListener(this);
        elementChoiceBox.add(new JLabel(" of " + String.valueOf(targetSize)));
        spinnerBox.add(elementChoiceBox);
        Box valueBox = new Box(2);
        valueBox.add(generator.generateJLabel(CONTENT));
        String text = this.getCurrentObject(false) == null ? "" : String.valueOf(((PTIntArray)this.getCurrentObject(false)).getValue(spinnerModel.getNumber().intValue()));
        this.content = new JTextField(15);
        this.content.setText(text);
        this.content.addKeyListener(this);
        valueBox.add(this.content);
        spinnerBox.add(valueBox);
        return spinnerBox;
    }

    private Box createColorBox(TranslatableGUIElement generator) {
        Box colorBox = generator.generateBorderedBox(2, "colorBL");
        Box firstColumnBox = generator.generateBorderedBox(3, "basicColors");
        firstColumnBox.add(generator.generateJLabel("colorLabel"));
        Color initialColor = this.getCurrentObject(false) == null ? Color.white : ((PTIntArray)this.getCurrentObject(false)).getBGColor();
        this.colorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "color", AnimalTranslator.translateMessage("chooseColor", new Object[]{"IntArray"}), initialColor);
        firstColumnBox.add(new ExtendedActionButton(this.colorChooser, 67));
        firstColumnBox.add(generator.generateJLabel(FONT_COLOR));
        Color fontInitialColor = this.getCurrentObject(false) == null ? Color.black : ((PTIntArray)this.getCurrentObject(false)).getFontColor();
        this.fontColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(fontInitialColor), "fontColor", AnimalTranslator.translateMessage("chooseColor", new Object[]{"IntArray"}), fontInitialColor);
        firstColumnBox.add(new ExtendedActionButton(this.fontColorChooser, 70));
        colorBox.add(firstColumnBox);
        Box secondColumnBox = generator.generateBorderedBox(3, "highlightColors");
        secondColumnBox.add(generator.generateJLabel("hlColorLabel"));
        Color highlightInitialColor = this.getCurrentObject(false) == null ? Color.yellow : ((PTIntArray)this.getCurrentObject(false)).getHighlightColor();
        this.highlightColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(highlightInitialColor), "highlightColor", AnimalTranslator.translateMessage("chooseColor", new Object[]{"IntArray"}), highlightInitialColor);
        secondColumnBox.add(new ExtendedActionButton(this.highlightColorChooser, 72));
        secondColumnBox.add(generator.generateJLabel(ELEM_HIGHLIGHT_COLOR));
        Color elemHighlightInitialColor = this.getCurrentObject(false) == null ? Color.red : ((PTIntArray)this.getCurrentObject(false)).getElemHighlightColor();
        this.elemHighlightColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(elemHighlightInitialColor), "elemHighlightColor", AnimalTranslator.translateMessage("chooseColor", new Object[]{"IntArray"}), elemHighlightInitialColor);
        secondColumnBox.add(new ExtendedActionButton(this.elemHighlightColorChooser, 69));
        secondColumnBox.add(generator.generateJLabel(OUTLINE_COLOR));
        Color outlineInitialColor = this.getCurrentObject(false) == null ? Color.black : ((PTIntArray)this.getCurrentObject(false)).getOutlineColor();
        this.outlineColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(outlineInitialColor), "outlineColor", AnimalTranslator.translateMessage("chooseColor", new Object[]{"IntArray"}), outlineInitialColor);
        secondColumnBox.add(new ExtendedActionButton(this.outlineColorChooser, 79));
        colorBox.add(firstColumnBox);
        colorBox.add(secondColumnBox);
        return colorBox;
    }

    private Box createIndicesOptionsBox(TranslatableGUIElement generator) {
        Box optionsBox = new Box(2);
        this.showIndicesCB = generator.generateJCheckBox(INDICES_LABEL, null, this);
        optionsBox.add(this.showIndicesCB);
        return optionsBox;
    }

    public void setProperties(XProperties props) {
        this.colorChooser.setColor(props.getColorProperty("StringArray.bgColor", Color.WHITE));
        this.highlightColorChooser.setColor(props.getColorProperty("StringArray.highlightColor", Color.YELLOW));
        this.elemHighlightColorChooser.setColor(props.getColorProperty("StringArray.elemHighlightColor", Color.RED));
        this.outlineColorChooser.setColor(props.getColorProperty("StringArray.outlineColor", Color.BLACK));
        this.fontColorChooser.setColor(props.getColorProperty("StringArray.fontColor", Color.BLACK));
        this.arraySize.setText(String.valueOf(props.getIntProperty("StringArray.arraySize", 1)));
        this.fontName.setSelectedItem(props.getProperty("StringArray.fontName", "Monospaced"));
        this.fontSize.setSelectedItem(props.getProperty("StringArray.fontSize", "14"));
        this.showIndicesCB.setSelected(props.getBoolProperty("StringArray.showIndices", true));
    }

    public void getProperties(XProperties props) {
        props.put("StringArray.bgColor", this.colorChooser.getColor());
        props.put("StringArray.highlightColor", this.highlightColorChooser.getColor());
        props.put("StringArray.elemHighlightColor", this.elemHighlightColorChooser.getColor());
        props.put("StringArray.outlineColor", this.outlineColorChooser.getColor());
        props.put("StringArray.fontColor", this.fontColorChooser.getColor());
        props.put("StringArray.arraySize", this.getInt(this.arraySize.getText(), 1));
        props.put((Object)"StringArray.fontName", this.fontName.getSelectedItem());
        props.put((Object)"StringArray.fontSize", this.fontSize.getSelectedItem());
        int fontStyle = 0;
        if (this.italic.isSelected()) {
            fontStyle += 2;
        }
        if (this.bold.isSelected()) {
            ++fontStyle;
        }
        props.put("StringArray.font", new Font((String)this.fontName.getSelectedItem(), fontStyle, this.getInt((String)this.fontSize.getSelectedItem(), 14)));
        props.put("StringArray.showIndices", this.showIndicesCB.isSelected());
    }

    public int pointsNeeded() {
        return 2;
    }

    public boolean nextPoint(int num, Point p) {
        switch (num) {
            case 1: 
            case 2: {
                ((PTStringArray)this.getCurrentObject()).setOrigin(p);
            }
        }
        return true;
    }

    public int getMinDist(PTGraphicObject go, Point p) {
        return MSMath.dist(p, go.getBoundingBox());
    }

    public EditPoint[] getEditPoints(PTGraphicObject go) {
        Rectangle bBox = ((PTStringArray)go).getBoundingBox();
        return new EditPoint[]{new EditPoint(-1, new Point(bBox.x, bBox.y)), new EditPoint(-2, new Point(bBox.x + bBox.width, bBox.y)), new EditPoint(-3, new Point(bBox.x, bBox.y + bBox.height)), new EditPoint(-4, new Point(bBox.x + bBox.width, bBox.y + bBox.height)), new EditPoint(-5, new Point(bBox.x + bBox.width / 2, bBox.y + bBox.height / 2))};
    }

    public EditableObject createObject() {
        PTStringArray result = new PTStringArray(this.getInt(this.arraySize.getText(), 1));
        this.storeAttributesInto(result);
        return result;
    }

    public Editor getSecondaryEditor(EditableObject e) {
        StringArrayEditor result = new StringArrayEditor(((PTStringArray)e).length);
        result.extractAttributesFrom(e);
        return result;
    }

    public void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        PTStringArray stringArray = (PTStringArray)eo;
        stringArray.setBGColor(this.colorChooser.getColor());
        stringArray.setHighlightColor(this.highlightColorChooser.getColor());
        stringArray.setElemHighlightColor(this.elemHighlightColorChooser.getColor());
        stringArray.setOutlineColor(this.outlineColorChooser.getColor());
        stringArray.setFontColor(this.fontColorChooser.getColor());
        if (this.arraySize != null) {
            stringArray.setSize(this.getInt(this.arraySize.getText(), 1));
        }
        stringArray.enterValue(this.calcIndex(), this.getContent());
        stringArray.setFont(this.storeFont());
        stringArray.showIndices(this.showIndicesCB.isSelected());
    }

    private String getContent() {
        return this.content == null ? "" : this.content.getText();
    }

    Font storeFont() {
        String name = (String)this.fontName.getSelectedItem();
        String size = (String)this.fontSize.getSelectedItem();
        int fontStyle = 0;
        if (this.italic.isSelected()) {
            fontStyle |= 2;
        }
        if (this.bold.isSelected()) {
            fontStyle |= 1;
        }
        return new Font(name, fontStyle, this.getInt(size, 12));
    }

    void extractFont(Font f) {
        this.fontName.setSelectedItem(f.getName());
        this.fontSize.setSelectedItem(String.valueOf(f.getSize()));
        this.italic.setSelected(f.isItalic());
        this.bold.setSelected(f.isBold());
    }

    private int calcIndex() {
        return this.arraySpinner == null ? -1 : ((SpinnerNumberModel)this.arraySpinner.getModel()).getNumber().intValue();
    }

    public void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        PTStringArray stringArray = (PTStringArray)eo;
        this.colorChooser.setColor(stringArray.getBGColor());
        this.highlightColorChooser.setColor(stringArray.getHighlightColor());
        this.elemHighlightColorChooser.setColor(stringArray.getElemHighlightColor());
        this.outlineColorChooser.setColor(stringArray.getOutlineColor());
        this.fontColorChooser.setColor(stringArray.getFontColor());
        if (this.arraySize != null) {
            this.arraySize.setText(String.valueOf(stringArray.getSize()));
        }
        this.content.setText(stringArray.getValue(this.calcIndex()));
        this.extractFont(stringArray.getFont());
        this.showIndicesCB.setSelected(stringArray.indicesShown());
    }

    public String getStatusLineMsg() {
        return AnimalTranslator.translateMessage("stringArrayStatusLine", new Object[]{DrawCanvas.translateDrawButton(), DrawCanvas.translateFinishButton(), DrawCanvas.translateCancelButton()});
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        PTStringArray stringArray = (PTStringArray)this.getCurrentObject();
        if (e.getSource() == this.content) {
            stringArray.enterValue(this.calcIndex(), this.content.getText());
        }
        if (e.getSource() == this.arraySize) {
            stringArray.setSize(this.getInt(this.arraySize.getText(), 1));
        }
        if (e.getSource() == this.fontName || e.getSource() == this.fontSize) {
            stringArray.setFont(this.storeFont());
        }
        if (e.getSource() == this.showIndicesCB) {
            stringArray.showIndices(this.showIndicesCB.isSelected());
        }
        this.repaintNow();
        Animation.get().doChange();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        PTStringArray stringArray = (PTStringArray)this.getCurrentObject();
        if (e.getSource() == this.content) {
            stringArray.enterValue(this.calcIndex(), this.content.getText());
        }
        this.repaintNow();
        Animation.get().doChange();
    }

    public void keyTyped(KeyEvent e) {
        PTStringArray stringArray = (PTStringArray)this.getCurrentObject();
        if (e.getSource() == this.content) {
            stringArray.enterValue(this.calcIndex(), this.content.getText());
        }
        this.repaintNow();
    }

    public void stateChanged(ChangeEvent e) {
        PTStringArray stringArray = (PTStringArray)this.getCurrentObject();
        if (e.getSource() == this.arraySpinner) {
            this.content.setText(stringArray.getValue(this.calcIndex()));
        }
        this.repaintNow();
        Animation.get().doChange();
    }

    public void propertyChange(PropertyChangeEvent event) {
        PTStringArray stringArray = (PTStringArray)this.getCurrentObject();
        String eventName = event.getPropertyName();
        if (eventName.equals("bgColor")) {
            stringArray.setBGColor((Color)event.getNewValue());
        }
        if (eventName.equals("highlightColor")) {
            stringArray.setHighlightColor((Color)event.getNewValue());
            stringArray.getCell(0).setFillColor((Color)event.getNewValue());
        }
        if (eventName.equals("elemHighlightColor")) {
            stringArray.setElemHighlightColor((Color)event.getNewValue());
            stringArray.getEntry(0).setColor((Color)event.getNewValue());
        }
        if (eventName.equals("outlineColor")) {
            stringArray.setOutlineColor((Color)event.getNewValue());
        }
        if (eventName.equals("fontColor")) {
            stringArray.setFontColor((Color)event.getNewValue());
        }
        if (!event.getOldValue().equals(event.getNewValue())) {
            this.repaintNow();
            Animation.get().doChange();
        }
    }

    public String getBasicType() {
        return "StringArray";
    }
}

