/*
 * Decompiled with CFR 0.152.
 */
package animal.editor;

import animal.animator.GraphicObjectSpecificAnimation;
import animal.animator.Highlight;
import animal.animator.Put;
import animal.editor.Editor;
import animal.editor.TimedAnimatorEditor;
import animal.graphics.PTArray;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTIntArray;
import animal.graphics.PTStringArray;
import animal.main.Animation;
import animal.misc.AnimalTranslator;
import animal.misc.EditableObject;
import animal.misc.ObjectSelectionButton;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PutEditor
extends TimedAnimatorEditor
implements VetoableChangeListener,
KeyListener,
GraphicObjectSpecificAnimation {
    private static final long serialVersionUID = 8408331164396676270L;
    public static final String CELL_INDEX = "cellIndex";
    public static final String CELL_CONTENT = "cellContent";
    private JComboBox indexCB;
    private JTextField content;

    public PutEditor() {
        JPanel jp = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        jp.add((Component)AnimalTranslator.getGUIBuilder().generateJLabel(CELL_INDEX), gbc);
        gbc.gridx = 1;
        jp.add((Component)AnimalTranslator.getGUIBuilder().generateJLabel(CELL_CONTENT), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.ipadx = 10;
        gbc.weightx = 0.1;
        gbc.fill = 2;
        this.indexCB = new JComboBox();
        this.indexCB.setMaximumRowCount(10);
        jp.add((Component)this.indexCB, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.9;
        gbc.fill = 1;
        this.content = new JTextField(15);
        this.content.addVetoableChangeListener(this);
        this.content.addKeyListener(this);
        jp.add((Component)this.content, gbc);
        this.addLayer(jp);
        this.finish();
    }

    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        if (e.getSource() instanceof ObjectSelectionButton) {
            int[] nums = this.objectSB.getObjectNums();
            if (nums == null || nums.length == 0) {
                this.indexCB.removeAllItems();
            } else if (nums.length == 1) {
                int length = -1;
                if (PutEditor.getGraphicObject(this.objectSB.getObjectNums()[0]) instanceof PTStringArray) {
                    length = ((PTStringArray)PutEditor.getGraphicObject((int)this.objectSB.getObjectNums()[0])).length;
                } else if (PutEditor.getGraphicObject(this.objectSB.getObjectNums()[0]) instanceof PTIntArray) {
                    length = ((PTIntArray)PutEditor.getGraphicObject((int)this.objectSB.getObjectNums()[0])).length;
                    this.content.setText(String.valueOf(this.getInt(this.content.getText(), 0)));
                }
                int selected = this.calcIndex(this.indexCB);
                this.indexCB.removeAllItems();
                int i = 0;
                while (i < length) {
                    if (this.checkActivation(i)) {
                        this.indexCB.addItem(String.valueOf(i));
                    }
                    ++i;
                }
                this.indexCB.setSelectedItem(selected >= 0 && selected < length ? String.valueOf(selected) : "0");
            } else {
                Object selected = this.indexCB.getSelectedItem();
                this.objectSB.setObjectNums(new int[]{this.objectSB.getObjectNums()[0]});
                this.indexCB.setSelectedItem(selected);
            }
        }
    }

    public void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        Put put = (Put)eo;
        PTGraphicObject ao = null;
        if (this.objectSB.getObjectNums() != null && this.objectSB.getObjectNums().length != 0) {
            ao = PutEditor.getGraphicObject(this.objectSB.getObjectNums()[0]);
        }
        int length = -1;
        if (ao instanceof PTArray) {
            length = ((PTArray)ao).length;
        }
        if (length > 0) {
            int i = 0;
            while (i < length) {
                if (this.checkActivation(i)) {
                    this.indexCB.addItem(String.valueOf(i));
                }
                ++i;
            }
            this.indexCB.setSelectedItem(put.getCell() < 0 ? "0" : String.valueOf(put.getCell()));
        }
        this.content.setText(put.getContent());
    }

    private boolean checkActivation(int index) {
        if (!Highlight.realDeactivation()) {
            return true;
        }
        if (this.objectSB.hasMultiSelection()) {
            int size;
            int n = size = this.objectSB.getObjectNums() == null ? -1 : this.objectSB.getObjectNums().length;
            if (size <= 0) {
                return false;
            }
            if (PutEditor.getGraphicObject(this.objectSB.getObjectNums()[0]) instanceof PTIntArray && !((PTArray)PutEditor.getGraphicObject(this.objectSB.getObjectNums()[0])).isActivated(index)) {
                return false;
            }
        } else if (this.objectSB.getObjectNum() == 0 || !((PTArray)PutEditor.getGraphicObject(this.objectSB.getObjectNum())).isActivated(index)) {
            return false;
        }
        return true;
    }

    public void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        Put put = (Put)eo;
        if (this.objectSB.getObjectNums() != null && this.objectSB.getObjectNums().length != 0) {
            PTGraphicObject ao = Animation.get().getGraphicObject(this.objectSB.getObjectNums()[0]);
            if (ao instanceof PTArray) {
                put.setFinalFont(((PTArray)ao).getFont());
            }
            put.setCell(this.calcIndex(this.indexCB));
            put.setContent(this.content.getText());
            put.setArray(ao.getNum(false));
        }
    }

    public Editor getSecondaryEditor(EditableObject eo) {
        PutEditor result = new PutEditor();
        result.extractAttributesFrom(eo);
        return result;
    }

    public EditableObject createObject() {
        Put p = new Put();
        this.storeAttributesInto(p);
        return p;
    }

    private int calcIndex(JComboBox cBox) {
        int index = this.getInt((String)cBox.getSelectedItem(), -1);
        return index;
    }

    boolean apply() {
        if (this.objectSB.getObjectNums() == null || this.objectSB.getObjectNums().length == 0) {
            new JDialog(this, AnimalTranslator.translateMessage("noObjectSelectedException"), true);
            return false;
        }
        if (PutEditor.getGraphicObject(this.objectSB.getObjectNums()[0]) instanceof PTIntArray) {
            try {
                this.content.setText(String.valueOf(Integer.parseInt(this.content.getText())));
            }
            catch (Exception nfe) {
                new JDialog(this, AnimalTranslator.translateMessage("noNumberException", new Object[]{this.content.getText()}), true);
                return false;
            }
        }
        if (PutEditor.getGraphicObject(this.objectSB.getObjectNums()[0]) instanceof PTArray && Highlight.realDeactivation() && !((PTArray)PutEditor.getGraphicObject(this.objectSB.getObjectNums()[0])).isActivated(this.calcIndex(this.indexCB))) {
            new JDialog(this, AnimalTranslator.translateMessage("inactiveElementException", new Object[]{this.calcIndex(this.indexCB)}), true);
            return false;
        }
        return super.apply();
    }

    public void vetoableChange(PropertyChangeEvent e) {
        if (e.getSource() == this.content && PutEditor.getGraphicObject(this.objectSB.getObjectNums()[0]) instanceof PTIntArray) {
            try {
                Integer.parseInt((String)e.getNewValue());
            }
            catch (NumberFormatException nfe) {
                this.content.removeVetoableChangeListener(this);
                this.content.setText((String)e.getOldValue());
                this.content.addVetoableChangeListener(this);
            }
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        if (this.objectSB.getObjectNums() != null && this.objectSB.getObjectNums().length != 0 && PutEditor.getGraphicObject(this.objectSB.getObjectNums()[0]) instanceof PTIntArray && (e.getKeyChar() != '-' || this.content.getCaretPosition() != 0 || this.getInt(this.content.getText(), 0) < 0) && (!Character.isDigit(e.getKeyChar()) || this.content.getCaretPosition() <= 0 && this.getInt(this.content.getText(), 0) < 0)) {
            e.consume();
        }
    }

    public String[] getSupportedTypes() {
        return new String[]{"StringArray", "IntArray"};
    }
}

