/*
 * Decompiled with CFR 0.152.
 */
package animal.editor;

import animal.editor.Editor;
import animal.editor.GraphicEditor;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.graphics.PTPolyline;
import animal.gui.DrawCanvas;
import animal.main.Animation;
import animal.misc.AnimalTranslator;
import animal.misc.ColorChoice;
import animal.misc.ColorChooserAction;
import animal.misc.EditPoint;
import animal.misc.EditableObject;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import translator.ExtendedActionButton;
import translator.TranslatableGUIElement;

public class PolylineEditor
extends GraphicEditor
implements ItemListener,
ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = -2413776784253970663L;
    private JCheckBox closedCB;
    private JCheckBox filledCB;
    private JCheckBox fwArrowCB;
    private JCheckBox bwArrowCB;
    private ColorChooserAction fillColorChooser;
    private ExtendedActionButton fillColorChooserButton;
    private ColorChooserAction colorChooser;

    public PolylineEditor() {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        Box colorBox = generator.generateBorderedBox(3, "colorBL");
        Box firstRowBox = new Box(2);
        firstRowBox.add(generator.generateJLabel("colorLabel"));
        Color initialColor = this.getCurrentObject(false) == null ? Color.black : ((PTPolyline)this.getCurrentObject(false)).getColor();
        this.colorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "color", AnimalTranslator.translateMessage("chooseColor", new Object[]{AnimalTranslator.translateMessage("outline")}), initialColor);
        firstRowBox.add(new ExtendedActionButton(this.colorChooser, 67));
        colorBox.add(firstRowBox);
        Box secondRowBox = new Box(2);
        secondRowBox.add(generator.generateJLabel("fillColorLabel"));
        initialColor = this.getCurrentObject(false) == null ? Color.black : ((PTPolyline)this.getCurrentObject(false)).getFillColor();
        this.fillColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "fillColor", AnimalTranslator.translateMessage("chooseColor", new Object[]{AnimalTranslator.translateMessage("fillColor")}), initialColor);
        this.fillColorChooserButton = new ExtendedActionButton(this.fillColorChooser, 70);
        secondRowBox.add(this.fillColorChooserButton);
        colorBox.add(secondRowBox);
        this.addBox(colorBox);
        this.closedCB = generator.generateJCheckBox("closed", null, this);
        this.closedCB.addItemListener(this);
        this.filledCB = generator.generateJCheckBox("filled", null, this);
        this.filledCB.addItemListener(this);
        this.fwArrowCB = generator.generateJCheckBox("fwArrow", null, this);
        this.fwArrowCB.addItemListener(this);
        this.bwArrowCB = generator.generateJCheckBox("bwArrow", null, this);
        this.bwArrowCB.addItemListener(this);
        Box polylinePropertiesBox = generator.generateBorderedBox(3, "polylinePropsBL");
        Box closedFilledBox = new Box(2);
        closedFilledBox.add(this.closedCB);
        closedFilledBox.add(this.filledCB);
        polylinePropertiesBox.add(closedFilledBox);
        Box arrowModeBox = new Box(2);
        arrowModeBox.add(this.fwArrowCB);
        arrowModeBox.add(this.bwArrowCB);
        polylinePropertiesBox.add(arrowModeBox);
        this.addBox(polylinePropertiesBox);
        this.finishBoxes();
    }

    public int pointsNeeded() {
        return -1;
    }

    public boolean nextPoint(int num, Point p) {
        PTPolyline pl = (PTPolyline)this.getCurrentObject();
        pl.setNode(num - 1, new PTPoint(p));
        return true;
    }

    public int getMinDist(PTGraphicObject go, Point p) {
        Polygon poly;
        PTPolyline pg = (PTPolyline)go;
        if (pg.isClosed() && pg.isFilled() && (poly = pg.toPolygon()).contains(p)) {
            return 0;
        }
        Point b = pg.getNode(0).toPoint();
        int minDist = Integer.MAX_VALUE;
        int i = 1;
        while (i < pg.getNodeCount()) {
            int newDist;
            Point a = b;
            if (!a.equals(b = pg.getNode(i).toPoint()) && (newDist = MSMath.dist(p, a, b)) < minDist) {
                minDist = newDist;
            }
            ++i;
        }
        return minDist;
    }

    public EditPoint[] getEditPoints(PTGraphicObject go) {
        PTPolyline pg = (PTPolyline)go;
        int pSize = pg.getNodeCount();
        int size = pSize * 2 - 1;
        EditPoint[] result = new EditPoint[size];
        int i = 0;
        while (i < pSize) {
            result[i] = new EditPoint(i + 1, pg.getNode(i).toPoint());
            ++i;
        }
        Point b = pg.getNode(0).toPoint();
        i = 1;
        while (i < pSize) {
            Point a = b;
            b = pg.getNode(i).toPoint();
            result[i + pSize - 1] = new EditPoint(-i, new Point((a.x + b.x) / 2, (a.y + b.y) / 2));
            ++i;
        }
        return result;
    }

    public void setProperties(XProperties props) {
        this.bwArrowCB.setSelected(props.getBoolProperty("Polyline.bwArrow"));
        this.closedCB.setSelected(props.getBoolProperty("Polyline.closed"));
        this.colorChooser.setColor(props.getColorProperty("Polyline.color", Color.black));
        this.depthBox.setSelectedItem(props.getProperty("depth", String.valueOf(16)));
        this.fillColorChooser.setColor(props.getColorProperty("Polyline.fillColor", Color.black));
        this.filledCB.setSelected(props.getBoolProperty("Polyline.filled"));
        this.fwArrowCB.setSelected(props.getBoolProperty("Polyline.fwArrow"));
    }

    public void getProperties(XProperties props) {
        props.put("Polyline.bwArrow", this.bwArrowCB.isSelected());
        props.put("Polyline.closed", this.closedCB.isSelected());
        props.put("Polyline.color", this.colorChooser.getColor());
        props.put((Object)"depth", this.depthBox.getSelectedItem());
        props.put("Polyline.fillColor", this.fillColorChooser.getColor());
        props.put("Polyline.filled", this.filledCB.isSelected());
        props.put("Polyline.fwArrow", this.fwArrowCB.isSelected());
    }

    public void itemStateChanged(ItemEvent e) {
        PTPolyline p = (PTPolyline)this.getCurrentObject();
        if (e.getSource() == this.closedCB) {
            this.filledCB.setEnabled(this.closedCB.isSelected());
            this.fwArrowCB.setEnabled(!this.closedCB.isSelected());
            this.bwArrowCB.setEnabled(!this.closedCB.isSelected());
            if (p != null) {
                p.setClosed(this.closedCB.isSelected());
            }
        }
        if (e.getSource() == this.filledCB && p != null) {
            p.setFilled(this.filledCB.isSelected());
        }
        if (e.getSource() == this.fwArrowCB && p != null) {
            p.setFWArrow(this.fwArrowCB.isSelected());
        }
        if (e.getSource() == this.bwArrowCB && p != null) {
            p.setBWArrow(this.bwArrowCB.isSelected());
        }
        this.fillColorChooserButton.setEnabled(this.closedCB.isSelected() && this.filledCB.isSelected());
        Animation.get().doChange();
        this.repaintNow();
    }

    public EditableObject createObject() {
        PTPolyline pg = new PTPolyline();
        this.storeAttributesInto(pg);
        return pg;
    }

    void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        PTPolyline p = (PTPolyline)eo;
        p.setColor(this.colorChooser.getColor());
        p.setFillColor(this.fillColorChooser.getColor());
        p.setClosed(this.closedCB.isSelected());
        p.setFilled(this.filledCB.isSelected());
        p.setFWArrow(this.fwArrowCB.isSelected());
        p.setBWArrow(this.bwArrowCB.isSelected());
        p.setObjectName(this.objectNameField.getText());
    }

    void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        PTPolyline p = (PTPolyline)eo;
        this.colorChooser.setColor(p.getColor());
        this.fillColorChooser.setColor(p.getFillColor());
        this.closedCB.setSelected(p.isClosed());
        this.filledCB.setEnabled(p.isClosed());
        this.filledCB.setSelected(p.isFilled());
        this.fwArrowCB.setSelected(p.hasFWArrow());
        this.bwArrowCB.setSelected(p.hasBWArrow());
        this.objectNameField.setText(p.getObjectName());
    }

    public Editor getSecondaryEditor(EditableObject go) {
        PolylineEditor result = new PolylineEditor();
        result.extractAttributesFrom(go);
        return result;
    }

    public String getStatusLineMsg() {
        return AnimalTranslator.translateMessage("polylineStatusLine", new Object[]{DrawCanvas.translateDrawButton(), DrawCanvas.translateFinishButton(), DrawCanvas.translateCancelButton()});
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        PTPolyline p = (PTPolyline)this.getCurrentObject();
        if (p != null) {
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
            this.repaintNow();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        PTPolyline poly = (PTPolyline)this.getCurrentObject();
        String eventName = event.getPropertyName();
        if (eventName.equals("color")) {
            poly.setColor((Color)event.getNewValue());
        } else if (eventName.equals("fillColor")) {
            poly.setFillColor((Color)event.getNewValue());
        }
        if (!event.getOldValue().equals(event.getNewValue())) {
            this.repaintNow();
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
        }
    }

    public String getBasicType() {
        return "Polyline";
    }
}

