/*
 * Decompiled with CFR 0.152.
 */
package animal.editor;

import animal.editor.AbstractTextEditor;
import animal.editor.Editor;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTIntArray;
import animal.gui.DrawCanvas;
import animal.main.Animation;
import animal.misc.AnimalTranslator;
import animal.misc.ColorChoice;
import animal.misc.ColorChooserAction;
import animal.misc.EditPoint;
import animal.misc.EditableObject;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import translator.ExtendedActionButton;
import translator.TranslatableGUIElement;

public class IntArrayEditor
extends AbstractTextEditor
implements ChangeListener,
ActionListener,
PropertyChangeListener,
KeyListener {
    private static final long serialVersionUID = 2295451210977833754L;
    private ColorChooserAction colorChooser;
    private ColorChooserAction highlightColorChooser;
    private ColorChooserAction elemHighlightColorChooser;
    private ColorChooserAction outlineColorChooser;
    private ColorChooserAction fontColorChooser;
    private JTextField arraySize;
    private JTextField content;
    private JSpinner arraySpinner;
    private JCheckBox showIndicesCB;
    public static final String ENTRY_LABEL = "entryLabel";
    public static final String BG_COLOR = "bgColorLabel";
    public static final String HIGHLIGHT_COLOR = "highlightColorLabel";
    public static final String ELEM_HIGHLIGHT_COLOR = "elemHighlightColorLabel";
    public static final String OUTLINE_COLOR = "outlineColorLabel";
    public static final String FONT_COLOR = "fontColorLabel";
    public static final String SIZE = "arraySize";
    public static final String ARRAY_CELL = "arrayCell";
    public static final String ARRAY_CONTENTS = "arrayContents";
    public static final String ARRAY_COLORS = "arrayColors";
    public static final String ARRAY_OPTIONS = "options";
    public static final String CONTENT = "cellContent";
    public static final String FONT_LABEL = "fontLabel";
    public static final String FONT = "font";
    public static final String FONT_SIZE = "fontSizeLabel";
    public static final String INDICES_LABEL = "showIndices";

    public IntArrayEditor() {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        this.addBox(this.createArraySizeBox(generator));
        this.addBox(this.createColorBox(generator));
        this.addBox(this.generateFontAndStyleBox(generator, "fontBL"));
        this.finishBoxes();
    }

    private IntArrayEditor(int i) {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        this.addBox(this.createArrayValueBox(generator, i));
        this.addBox(this.createIndicesOptionsBox(generator));
        this.addBox(this.createColorBox(generator));
        this.addBox(this.generateFontAndStyleBox(generator, "fontBL"));
        this.finishBoxes();
    }

    private Box createArrayValueBox(TranslatableGUIElement generator, int targetSize) {
        Box spinnerBox = generator.generateBorderedBox(3, "arrayValuesBL");
        Box elementChoiceBox = new Box(2);
        elementChoiceBox.add(generator.generateJLabel(ARRAY_CELL));
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(0, 0, targetSize - 1, 1);
        this.arraySpinner = new JSpinner(spinnerModel);
        elementChoiceBox.add(this.arraySpinner);
        this.arraySpinner.addChangeListener(this);
        elementChoiceBox.add(new JLabel(" of " + String.valueOf(targetSize)));
        spinnerBox.add(elementChoiceBox);
        Box valueBox = new Box(2);
        valueBox.add(generator.generateJLabel(CONTENT));
        String text = this.getCurrentObject(false) == null ? "" : String.valueOf(((PTIntArray)this.getCurrentObject(false)).getValue(spinnerModel.getNumber().intValue()));
        this.content = new JTextField(15);
        this.content.setText(text);
        this.content.addKeyListener(this);
        valueBox.add(this.content);
        spinnerBox.add(valueBox);
        return spinnerBox;
    }

    private Box createColorBox(TranslatableGUIElement generator) {
        Box colorBox = generator.generateBorderedBox(2, "colorBL");
        Box firstColumnBox = generator.generateBorderedBox(3, "basicColors");
        firstColumnBox.add(generator.generateJLabel("colorLabel"));
        Color initialColor = this.getCurrentObject(false) == null ? Color.white : ((PTIntArray)this.getCurrentObject(false)).getBGColor();
        this.colorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "color", AnimalTranslator.translateMessage("chooseColor", new Object[]{"IntArray"}), initialColor);
        firstColumnBox.add(new ExtendedActionButton(this.colorChooser, 67));
        firstColumnBox.add(generator.generateJLabel(FONT_COLOR));
        Color fontInitialColor = this.getCurrentObject(false) == null ? Color.black : ((PTIntArray)this.getCurrentObject(false)).getFontColor();
        this.fontColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(fontInitialColor), "fontColor", AnimalTranslator.translateMessage("chooseColor", new Object[]{"IntArray"}), fontInitialColor);
        firstColumnBox.add(new ExtendedActionButton(this.fontColorChooser, 70));
        colorBox.add(firstColumnBox);
        Box secondColumnBox = generator.generateBorderedBox(3, "highlightColors");
        secondColumnBox.add(generator.generateJLabel("hlColorLabel"));
        Color highlightInitialColor = this.getCurrentObject(false) == null ? Color.yellow : ((PTIntArray)this.getCurrentObject(false)).getHighlightColor();
        this.highlightColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(highlightInitialColor), "highlightColor", AnimalTranslator.translateMessage("chooseColor", new Object[]{"IntArray"}), highlightInitialColor);
        secondColumnBox.add(new ExtendedActionButton(this.highlightColorChooser, 72));
        secondColumnBox.add(generator.generateJLabel(ELEM_HIGHLIGHT_COLOR));
        Color elemHighlightInitialColor = this.getCurrentObject(false) == null ? Color.red : ((PTIntArray)this.getCurrentObject(false)).getElemHighlightColor();
        this.elemHighlightColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(elemHighlightInitialColor), "elemHighlightColor", AnimalTranslator.translateMessage("chooseColor", new Object[]{"IntArray"}), elemHighlightInitialColor);
        secondColumnBox.add(new ExtendedActionButton(this.elemHighlightColorChooser, 69));
        secondColumnBox.add(generator.generateJLabel(OUTLINE_COLOR));
        Color outlineInitialColor = this.getCurrentObject(false) == null ? Color.black : ((PTIntArray)this.getCurrentObject(false)).getOutlineColor();
        this.outlineColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(outlineInitialColor), "outlineColor", AnimalTranslator.translateMessage("chooseColor", new Object[]{"IntArray"}), outlineInitialColor);
        secondColumnBox.add(new ExtendedActionButton(this.outlineColorChooser, 79));
        colorBox.add(firstColumnBox);
        colorBox.add(secondColumnBox);
        return colorBox;
    }

    public void setProperties(XProperties props) {
        this.colorChooser.setColor(props.getColorProperty("IntArray.bgColor", Color.WHITE));
        this.highlightColorChooser.setColor(props.getColorProperty("IntArray.highlightColor", Color.YELLOW));
        this.elemHighlightColorChooser.setColor(props.getColorProperty("IntArray.elemHighlightColor", Color.RED));
        this.outlineColorChooser.setColor(props.getColorProperty("IntArray.outlineColor", Color.BLACK));
        this.fontColorChooser.setColor(props.getColorProperty("IntArray.fontColor", Color.BLACK));
        this.arraySize.setText(String.valueOf(props.getIntProperty("IntArray.arraySize", 1)));
        this.fontName.setSelectedItem(props.getProperty("IntArray.fontName", "Monospaced"));
        this.fontSize.setSelectedItem(props.getProperty("IntArray.fontSize", "14"));
        this.showIndicesCB.setSelected(props.getBoolProperty("IntArray.showIndices", true));
    }

    private Box createArraySizeBox(TranslatableGUIElement generator) {
        Box sizeBox = generator.generateBorderedBox(3, "arraySizeBL");
        Box internalBox = new Box(2);
        internalBox.add(generator.generateJLabel(SIZE));
        this.arraySize = new JTextField(8);
        this.arraySize.addActionListener(this);
        internalBox.add(this.arraySize);
        sizeBox.add(internalBox);
        sizeBox.add(this.createIndicesOptionsBox(generator));
        return sizeBox;
    }

    private Box createIndicesOptionsBox(TranslatableGUIElement generator) {
        Box optionsBox = new Box(2);
        this.showIndicesCB = generator.generateJCheckBox(INDICES_LABEL, null, this);
        optionsBox.add(this.showIndicesCB);
        return optionsBox;
    }

    public void getProperties(XProperties props) {
        props.put("IntArray.bgColor", this.colorChooser.getColor());
        props.put("IntArray.highlightColor", this.highlightColorChooser.getColor());
        props.put("IntArray.elemHighlightColor", this.elemHighlightColorChooser.getColor());
        props.put("IntArray.outlineColor", this.outlineColorChooser.getColor());
        props.put("IntArray.fontColor", this.fontColorChooser.getColor());
        props.put("IntArray.arraySize", this.getInt(this.arraySize.getText(), 1));
        props.put((Object)"IntArray.fontName", this.fontName.getSelectedItem());
        props.put((Object)"IntArray.fontSize", this.fontSize.getSelectedItem());
        props.put("IntArray.font", new Font((String)this.fontName.getSelectedItem(), 0, this.getInt((String)this.fontSize.getSelectedItem(), 14)));
        props.put("IntArray.showIndices", this.showIndicesCB.isSelected());
    }

    public int pointsNeeded() {
        return 2;
    }

    public boolean nextPoint(int num, Point p) {
        switch (num) {
            case 1: 
            case 2: {
                ((PTIntArray)this.getCurrentObject()).setOrigin(p);
            }
        }
        return true;
    }

    public int getMinDist(PTGraphicObject go, Point p) {
        return MSMath.dist(p, go.getBoundingBox());
    }

    public EditPoint[] getEditPoints(PTGraphicObject go) {
        Rectangle bBox = ((PTIntArray)go).getBoundingBox();
        return new EditPoint[]{new EditPoint(-1, new Point(bBox.x, bBox.y)), new EditPoint(-2, new Point(bBox.x + bBox.width, bBox.y)), new EditPoint(-3, new Point(bBox.x, bBox.y + bBox.height)), new EditPoint(-4, new Point(bBox.x + bBox.width, bBox.y + bBox.height)), new EditPoint(-5, new Point(bBox.x + bBox.width / 2, bBox.y + bBox.height / 2))};
    }

    public EditableObject createObject() {
        PTIntArray result = new PTIntArray(this.getInt(this.arraySize.getText(), 1));
        this.storeAttributesInto(result);
        return result;
    }

    public Editor getSecondaryEditor(EditableObject e) {
        IntArrayEditor result = new IntArrayEditor(((PTIntArray)e).length);
        result.extractAttributesFrom(e);
        return result;
    }

    void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        PTIntArray intArray = (PTIntArray)eo;
        intArray.setBGColor(this.colorChooser.getColor());
        intArray.setHighlightColor(this.highlightColorChooser.getColor());
        intArray.setElemHighlightColor(this.elemHighlightColorChooser.getColor());
        intArray.setOutlineColor(this.outlineColorChooser.getColor());
        intArray.setFontColor(this.fontColorChooser.getColor());
        if (this.arraySize != null) {
            intArray.setSize(this.getInt(this.arraySize.getText(), 1));
        }
        intArray.enterValue(this.calcIndex(), this.getContent());
        intArray.setFont(this.storeFont());
        intArray.showIndices(this.showIndicesCB.isSelected());
    }

    private int getContent() {
        return this.content == null ? 0 : this.getInt(this.content.getText(), 0);
    }

    Font storeFont() {
        String name = (String)this.fontName.getSelectedItem();
        String size = (String)this.fontSize.getSelectedItem();
        return new Font(name, 0, this.getInt(size, 12));
    }

    void extractFont(Font f) {
        this.fontName.setSelectedItem(f.getName());
        this.fontSize.setSelectedItem(String.valueOf(f.getSize()));
    }

    private int calcIndex() {
        return this.arraySpinner == null ? -1 : ((SpinnerNumberModel)this.arraySpinner.getModel()).getNumber().intValue();
    }

    void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        PTIntArray intArray = (PTIntArray)eo;
        this.colorChooser.setColor(intArray.getBGColor());
        this.highlightColorChooser.setColor(intArray.getHighlightColor());
        this.elemHighlightColorChooser.setColor(intArray.getElemHighlightColor());
        this.outlineColorChooser.setColor(intArray.getOutlineColor());
        this.fontColorChooser.setColor(intArray.getFontColor());
        if (this.arraySize != null) {
            this.arraySize.setText(String.valueOf(intArray.getSize()));
        }
        this.content.setText(String.valueOf(intArray.getValue(this.calcIndex())));
        this.extractFont(intArray.getFont());
        this.showIndicesCB.setSelected(intArray.indicesShown());
    }

    public String getStatusLineMsg() {
        return AnimalTranslator.translateMessage("intArrayStatusLine", new Object[]{DrawCanvas.translateDrawButton(), DrawCanvas.translateFinishButton(), DrawCanvas.translateCancelButton()});
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        PTIntArray intArray = (PTIntArray)this.getCurrentObject();
        if (e.getSource() == this.content) {
            intArray.enterValue(this.calcIndex(), this.getInt(this.content.getText(), 0));
        }
        if (e.getSource() == this.arraySize) {
            intArray.setSize(this.getInt(this.arraySize.getText(), 1));
        }
        if (e.getSource() == this.fontName || e.getSource() == this.fontSize) {
            intArray.setFont(this.storeFont());
        }
        if (e.getSource() == this.showIndicesCB) {
            intArray.showIndices(this.showIndicesCB.isSelected());
        }
        this.repaintNow();
        Animation.get().doChange();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        PTIntArray intArray = (PTIntArray)this.getCurrentObject();
        if (e.getSource() == this.content) {
            intArray.enterValue(this.calcIndex(), this.getInt(this.content.getText(), this.calcIndex()));
        }
        this.repaintNow();
        Animation.get().doChange();
    }

    public void keyTyped(KeyEvent e) {
        PTIntArray intArray = (PTIntArray)this.getCurrentObject();
        if (e.getSource() == this.content) {
            if (!(e.getKeyChar() == '-' && this.content.getCaretPosition() == 0 && this.getInt(this.content.getText(), 0) >= 0 || Character.isDigit(e.getKeyChar()) && (this.content.getCaretPosition() > 0 || this.getInt(this.content.getText(), 0) >= 0))) {
                e.consume();
            }
            intArray.enterValue(this.calcIndex(), this.getInt(this.content.getText(), this.calcIndex()));
        }
        this.repaintNow();
    }

    public void stateChanged(ChangeEvent e) {
        PTIntArray intArray = (PTIntArray)this.getCurrentObject();
        if (e.getSource() == this.arraySpinner) {
            this.content.setText(String.valueOf(intArray.getValue(this.calcIndex())));
        }
        this.repaintNow();
        Animation.get().doChange();
    }

    public void propertyChange(PropertyChangeEvent event) {
        PTIntArray intArray = (PTIntArray)this.getCurrentObject();
        String eventName = event.getPropertyName();
        if (eventName.equals("color")) {
            intArray.setBGColor((Color)event.getNewValue());
        }
        if (eventName.equals("highlightColor")) {
            intArray.setHighlightColor((Color)event.getNewValue());
            intArray.getCell(0).setFillColor((Color)event.getNewValue());
        }
        if (eventName.equals("elemHighlightColor")) {
            intArray.setElemHighlightColor((Color)event.getNewValue());
            intArray.getEntry(0).setColor((Color)event.getNewValue());
        }
        if (eventName.equals("outlineColor")) {
            intArray.setOutlineColor((Color)event.getNewValue());
        }
        if (eventName.equals("fontColor")) {
            intArray.setFontColor((Color)event.getNewValue());
        }
        if (!event.getOldValue().equals(event.getNewValue())) {
            this.repaintNow();
            Animation.get().doChange();
        }
    }

    public String getBasicType() {
        return "IntArray";
    }
}

