/*
 * Decompiled with CFR 0.152.
 */
package animal.dialog;

import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.misc.AnimalTranslator;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class AboutDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -5083531199461628721L;
    private static AboutDialog dialog = null;
    private static final int INSETS_SMALL = 5;
    private static final int INSETS_LARGE = 10;
    private static final int FONT_SIZE = 14;
    private static final int HUGE_FONT_SIZE = 24;
    private static final int SMALL_FONT_SIZE = 10;
    private Animal animal;
    private AbstractButton okButton;

    public AboutDialog(Animal animalInstance) {
        super(animalInstance, AnimalTranslator.translateMessage("about.label", null), false);
        this.animal = animalInstance;
        GridBagLayout gbl = new GridBagLayout();
        this.getContentPane().setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.insets = new Insets(5, 10, 5, 5);
        JLabel imageAnimal = new JLabel(this.animal.getImageIcon("Animal.gif"));
        this.getContentPane().add((Component)imageAnimal, gbc);
        Font bigBoldFont = new Font("SansSerif", 1, 14);
        Font biggerFont = new Font("SansSerif", 0, 14);
        Font smallerFont = new Font("SansSerif", 2, 10);
        JLabel l = new JLabel("Animal");
        l.setFont(new Font("SansSerif", 1, 24));
        this.getContentPane().add((Component)l, gbc);
        l = new JLabel("A New Interactive Modeller for Animations in Lectures");
        l.setFont(bigBoldFont);
        this.getContentPane().add((Component)l, gbc);
        String versionInfo = AnimalConfiguration.getDefaultConfiguration().getVersionLine("versionInfoLine");
        l = new JLabel(versionInfo);
        l.setFont(biggerFont);
        this.getContentPane().add((Component)l, gbc);
        l = new JLabel("eMail: roessling@acm.org");
        l.setFont(biggerFont);
        this.getContentPane().add((Component)l, gbc);
        l = new JLabel("\u00a9 1998 Markus Sch\u00fcler [Animal 1.1]");
        l.setFont(smallerFont);
        this.getContentPane().add((Component)l, gbc);
        l = new JLabel("eMail: schueler@gmx.de");
        l.setFont(smallerFont);
        this.getContentPane().add((Component)l, gbc);
        l = new JLabel("http://www.animal.ahrgr.de");
        l.setFont(bigBoldFont);
        this.getContentPane().add((Component)l, gbc);
        this.okButton = new JButton(AnimalTranslator.translateMessage("ok", null));
        this.getContentPane().add(this.okButton);
        this.pack();
        this.okButton.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AboutDialog.this.windowClosing();
            }
        });
        dialog = this;
    }

    public static AboutDialog getAboutDialog(Animal animalInstance) {
        if (dialog == null) {
            dialog = new AboutDialog(animalInstance);
        }
        return dialog;
    }

    public void setVisible(boolean showIt) {
        if (!this.isVisible()) {
            this.setLocationRelativeTo(this.getParent());
        }
        super.setVisible(showIt);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.okButton) {
            this.windowClosing();
        }
    }

    public void windowClosing() {
        dialog = null;
        this.setVisible(false);
        this.dispose();
    }
}

