/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.ScaleParams;
import animal.animator.TimedAnimator;
import animal.graphics.PTPoint;
import animal.main.AnimationState;

public class Scale
extends TimedAnimator {
    public static final String TYPE_LABEL = "Scale";
    public static final String CENTER_LABEL = "center";
    public static final String X_FACTOR_LABEL = "xFactor";
    public static final String Y_FACTOR_LABEL = "yFactor";
    private static final long serialVersionUID = 6013542892842131526L;
    private PTPoint center;

    public Scale() {
    }

    public Scale(int step, int[] objectNums, int totalTimeOrTicks, int centerNum, double xFactor, double yFactor) {
        super(step, objectNums, totalTimeOrTicks, "scale");
        this.getProperties().put(CENTER_LABEL, centerNum);
        this.getProperties().put(X_FACTOR_LABEL, xFactor);
        this.getProperties().put(Y_FACTOR_LABEL, yFactor);
    }

    public void init(AnimationState animationState, long time, double ticks) {
        super.init(animationState, time, ticks);
        this.center = (PTPoint)animationState.getCloneByNum(this.getCenterNum());
    }

    public String getAnimatorName() {
        return TYPE_LABEL;
    }

    public int getCenterNum() {
        return this.getProperties().getIntProperty(CENTER_LABEL, -1);
    }

    public void setCenterNum(int objectNum) {
        this.getProperties().put(CENTER_LABEL, objectNum);
    }

    public int getFileVersion() {
        return 1;
    }

    public Object getProperty(double factor) {
        if (Math.abs(factor) < (double)1.0E-4f) {
            factor = 1.0E-4f;
        }
        return new ScaleParams(this.center, factor * this.getXScaleFactor(), factor * this.getYScaleFactor());
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public double getXScaleFactor() {
        return this.getProperties().getDoubleProperty(X_FACTOR_LABEL, 1.0);
    }

    public double getYScaleFactor() {
        return this.getProperties().getDoubleProperty(Y_FACTOR_LABEL, 1.0);
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public void setXScaleFactor(double factor) {
        this.getProperties().put(X_FACTOR_LABEL, factor);
    }

    public void setYScaleFactor(double factor) {
        this.getProperties().put(Y_FACTOR_LABEL, factor);
    }

    public String toString() {
        return "scale " + super.toString() + " by (" + this.getXScaleFactor() + ", " + this.getYScaleFactor() + ") centered on " + this.getCenterNum();
    }
}

