/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.Animator;
import animal.animator.PerformableAction;
import animal.main.Animal;
import animal.misc.AnimalTranslator;
import animal.misc.MessageDisplay;
import java.net.MalformedURLException;
import java.net.URL;

public class DocumentationAction
implements PerformableAction {
    private static final long serialVersionUID = 6001468038296090314L;
    public static final String TYPE_LABEL = "Documentation";
    private URL url;
    boolean used;

    public DocumentationAction() {
    }

    public DocumentationAction(String targetURL) {
        this.setURL(targetURL);
    }

    public DocumentationAction(URL targetURL) {
        this.setURL(targetURL);
    }

    public void perform() {
        if (this.url != null) {
            Animator.getInfoFrame().setHtmlStr(this.url.toString());
        }
    }

    public URL getURL() {
        return this.url;
    }

    public String getType() {
        return TYPE_LABEL;
    }

    private URL generateURLFromString(String urlName) {
        URL targetURL = null;
        try {
            if (!urlName.startsWith("http")) {
                StringBuilder tmpURLBuffer = new StringBuilder(200);
                String defaultWebRoot = Animal.getInteractionHandler().getWebRoot();
                tmpURLBuffer.append(defaultWebRoot);
                if (!defaultWebRoot.endsWith("/")) {
                    tmpURLBuffer.append("/");
                }
                tmpURLBuffer.append(urlName);
                urlName = tmpURLBuffer.toString();
            }
            targetURL = new URL(urlName);
        }
        catch (MalformedURLException e) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("malformedURLException", new Object[]{urlName}), 4);
        }
        return targetURL;
    }

    public void setURL(String urlName) {
        this.setURL(this.generateURLFromString(urlName));
    }

    public void setURL(URL targetURL) {
        this.url = targetURL;
    }

    public String toString() {
        if (this.url != null) {
            return "documentation URL: '" + this.url.getFile() + "'";
        }
        return AnimalTranslator.translateMessage("noDocu");
    }
}

