/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.util.Arrays;
import java.util.Vector;
import translator.ExtendedResourceBundle;

public class ResourceChecker {
    public ResourceChecker() {
    }

    public ResourceChecker(String[] args) {
        ExtendedResourceBundle[] bundles = new ExtendedResourceBundle[args.length - 1];
        String[] resourceNames = new String[args.length - 1];
        String currentResourceName = null;
        ExtendedResourceBundle currentBundle = null;
        System.out.println("Requested to check resource base name " + args[0]);
        int pos = 0;
        int i = 1;
        while (i < args.length) {
            currentResourceName = args[i].equalsIgnoreCase("none") ? args[0] : String.valueOf(args[0]) + '.' + args[i];
            currentBundle = new ExtendedResourceBundle(currentResourceName);
            if (currentBundle != null && currentBundle.getKeys() != null && currentBundle.getKeys().length > 0) {
                resourceNames[pos] = currentResourceName;
                System.out.println("Successfully loaded bundle " + resourceNames[pos] + " for language code " + args[i]);
                bundles[pos++] = currentBundle;
            } else {
                System.out.println("Error in loading resource '" + currentResourceName + "'");
            }
            ++i;
        }
        i = 0;
        while (i < pos) {
            String[] masterResourceKeys = bundles[i].getKeys();
            int j = 0;
            while (j < pos) {
                if (i != j && bundles[j] != null) {
                    Vector<String> errorEntries = new Vector<String>(50, 25);
                    int errors = 0;
                    System.out.println("***********************************************************\nComparing resource '" + resourceNames[i] + "' with '" + resourceNames[j] + "'");
                    int keyIndex = 0;
                    while (keyIndex < masterResourceKeys.length) {
                        if (bundles[j].getMessage(masterResourceKeys[keyIndex], false) == null) {
                            ++errors;
                            errorEntries.add(masterResourceKeys[keyIndex]);
                        }
                        ++keyIndex;
                    }
                    if (errors > 0) {
                        Object[] entries = new String[errors];
                        errorEntries.copyInto(entries);
                        Arrays.sort(entries);
                        int p = 0;
                        while (p < errors) {
                            System.out.println("key '" + entries[p] + "' missing in resource '" + resourceNames[j] + "'");
                            ++p;
                        }
                    }
                    System.out.println(String.valueOf(errors) + " errors found.");
                }
                ++j;
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage: java translator.ResourceChecker baseFileName ext1 ext2 ...");
        } else {
            new ResourceChecker(args);
        }
    }
}

