/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import de.ahrgr.animal.kohnert.generators.VigenereEncode2;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VigenereEncodeWrapper
implements Generator {
    private static final String DESCRIPTION = "Die Vigen\u00e8re-Verschl\u00fcsselung ist ein Algorithmus zurVerschl\u00fcsselung eines gegebenen Textes mit einem Schl\u00fcsselwort. Dabei wird zun\u00e4chst das Schl\u00fcsselwort solange unter den Text geschrieben, bis jedem Zeichen des Textes ein Zeichen des Schl\u00fcsselwort zugeteilt wurde. Das Schl\u00fcsselwort sollte dabei nicht zu kurz sein, um eine sinnvolle Codierung zu erreichen.\nDas Verfahren baut dazu eine Tabelle der Gr\u00f6\u00dfe n*m auf, wobei n f\u00fcr die Anzahl Zeichen im zu Grunde liegenden Alphabet und m die L\u00e4nge des vom Nutzer gew\u00e4hlten Schl\u00fcsselworts ist.\nIn die erste Spalte der Tabelle wird das Schl\u00fcsselwort geschrieben.Alle Zeilen werden dann mit dem Alphabet, beginnend mit dem Zeichen des Schl\u00fcsselworts in der ersten Spalte der Zeile, aufgef\u00fcllt.\nUm ein Zeichen zu verschl\u00fcsseln, wird nun der Code der Tabelle in der Zeile (Zeichencode der Kopie des Schl\u00fcsselworts unter der Eingabe) und der Spalte (Zeichencode der Eingabe) ausgegeben.";
    private GeneratorType myType = new GeneratorType(128);

    @Override
    public GeneratorType getGeneratorType() {
        return this.myType;
    }

    @Override
    public String getName() {
        return "Vigen\u00e8re-Verschl\u00fcsselung";
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getCodeExample() {
        return "TBD";
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    private Hashtable<String, Object> provideMappedProperties(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        Hashtable<String, Object> mapper = new Hashtable<String, Object>(59);
        mapper.put("stringToEncode", primitives.get("stringToEncode"));
        mapper.put("key", primitives.get("key"));
        mapper.put("encodeLabel", primitives.get("encodeLabel"));
        mapper.put("keyLabel", primitives.get("keyLabel"));
        mapper.put("repeatedCopyLabel", primitives.get("repeatedCopyLabel"));
        mapper.put("charSet", primitives.get("charSet"));
        mapper.put("title", "Vigenere Encryption");
        mapper.put("tableCreateLabel", primitives.get("tableCreateLabel"));
        mapper.put("firstRowLabel", primitives.get("firstRowLabel"));
        mapper.put("fillContinuousLabel", primitives.get("fillContinuousLabel"));
        mapper.put("codePosLabel", primitives.get("codePosLabel"));
        mapper.put("numberSteps", primitives.get("numberSteps (0=alle)"));
        mapper.put("codeColor", props.get("code", "color"));
        mapper.put("codeFont", props.get("code", "font"));
        mapper.put("titleColor", primitives.get("titlecolor"));
        mapper.put("titleFont", props.get("title", "font"));
        mapper.put("tableRowColor", props.get("tableRow", "color"));
        mapper.put("tableColumnColor", props.get("tableColumn", "color"));
        mapper.put("tableFillColor", props.get("tableFill", "color"));
        mapper.put("resultColor", props.get("result", "color"));
        return mapper;
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        Hashtable<String, Object> mapper = this.provideMappedProperties(props, primitives);
        VigenereEncode2 encoder = new VigenereEncode2(mapper);
        StringWriter myWriter = new StringWriter();
        encoder.generate(myWriter);
        return myWriter.toString();
    }

    @Override
    public Locale getContentLocale() {
        return Locale.GERMANY;
    }
}

