/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import generator.Generator;
import generatorImplementations.SortingAlgorithm;
import java.awt.Color;
import java.util.Locale;
import net.algoanim.aads.AnimatedIntArray;
import net.algoanim.aads.AnimatedIntArrayMarker;

public class MergeSortEN
extends SortingAlgorithm
implements Generator {
    private int pointerCounter = 0;
    private static final String DESCRIPTION = "This generator animation sorting using Mergesort.\nThe underlying idea is to recursively split the current (sub-)array in two halves, until the current subarray contains only one element. On returning from the recusion, the split subarray will be sorted. For this, a temporary array is created and the values from both subarray are copied into this temporary array. For efficiency reasons, the values from the left subarray are copied in ascending order, while the values of the right subarray are copied in descending order.\nThe temporary array therefore consists of two separate halves. Starting at both ends, the values are copied in ascending order into the original  array.\nMergesort is very efficient and is guaranteed to be in O(n log n). There is no disctinction between a 'best', 'average' or 'worst case'. However, MergeSort requires additional space (for the temporary array).";
    private static final String HEADER_TEXT = "\ntext \"f2-01\" \"Verbal description:\" at (120,50) color black font SansSerif size 32 bold\ntext \"f2-02\" \"1. Determine the middle of the current array\" at (20,100) color black font SansSerif size 24\ntext \"f2-03\" \"2. Invoke mergesort(array, l, m)\" at (20,140) color black font SansSerif size 24\ntext \"f2-04\" \"3. Invoke mergesort(array, m+1, r)\" at (20,180) color black font SansSerif size 24\ntext \"f2-05\" \"4. Generate a temporary array of size n\" at (20,220) color black font SansSerif size 24\ntext \"f2-06\" \"5. Copy the values from position l...m in the temporary array\" at (20,260) color black font SansSerif size 24\ntext \"f2-07\" \"6. Copy the values from r...m+1 in the temporary array\" at (20,300) color black font SansSerif size 24\ntext \"f2-08\" \"7. Compare the left and right index of the temporary array\" at (20,340) color black font SansSerif size 24\ntext \"f2-09\" \"and copy the smaller into the array\" at (20,380) color black font SansSerif size 24\n";
    private static final String SOURCE_CODE = "public void mergesort(int[] array, int l, int r) {\n\n  int i, j, k, m;\n  int[] b = new int[r - l + 1];\n  if (r>l) {\n\n    m = (l+r)/2;                    // Determine middle\n    mergesort(array, l, m);\n    mergesort(array, m+1, r);           // Sort and merge\n    for (i=l; i<=m && i<array.length; i++) b[i] = array[i]; // copy left subarray\n    for (j=m+1; j<=r; j++) b[r+m+1-j] = array[j];         // copy right subarray\n    for (k=l, i=l, j=r; k<=r && k<array.length; k++)\n      array[k] = (b[i] <b[j]) ? b[i++] : b[j--]; // merge\n  }\n}";

    public void sort(int[] a) {
        this.nrAssigns = 0;
        this.nrComparisons = 0;
        this.sb.setLength(0);
        this.sb.append("%Animal 2.0\n");
        this.sb.append("title \"Merge Sort Animation\"\n");
        this.sb.append("author \"Dr. Guido Roessling <roessling@acm.org>\"\n");
        this.sb.append(HEADER_TEXT);
        this.sb.append("hideAll\n");
        this.targetArray = this.createIntArray("array");
        this.toggleStep();
        this.codeSupport = this.createCode(SOURCE_CODE, "code");
        this.toggleStep();
        this.mergesort(this.targetArray, 0, a.length - 1);
        this.toggleStep();
        this.endAnimGeneration();
        this.endStep();
        this.sb.append("{\n  hideAll\n  text \"eoa\" \"Ende der Animation\" at (120,50) color black font SansSerif size 32\n  text \"comps\" \"Es wurden \" +$\"nrComparisons\" asInt +\" Vergleiche\" at (20,100) color black font SansSerif size 24\n  text \"swaps\" \"und \" +$\"nrAssignments\" asInt +\" Zuweisungen durchgef\u00fchrt.\" at (20,130) color black font SansSerif size 24\n}");
    }

    private AnimatedIntArray generateHelperArray(int left, int right) {
        String outlineColorName = this.dumpColor((Color)this.animationProperties.get("tmpArray", "color"));
        String fillColorName = this.dumpColor((Color)this.animationProperties.get("tmpArray", "fillColor"));
        String elementColorName = this.dumpColor((Color)this.animationProperties.get("tmpArray", "elementColor"));
        String elemHLColorName = this.dumpColor((Color)this.animationProperties.get("tmpArray", "elemHighlight"));
        String cellHLColorName = this.dumpColor((Color)this.animationProperties.get("tmpArray", "cellHighlight"));
        AnimatedIntArray helper = new AnimatedIntArray(this.sb, "tmpArray", new int[right - left + 1], this.sb, outlineColorName, fillColorName, elementColorName, elemHLColorName, cellHLColorName, 20, 200);
        return helper;
    }

    private void mergesort(AnimatedIntArray array, int l, int r) {
        this.toggleStep();
        this.codeSupport.highlightCode(0);
        this.toggleStep();
        this.codeSupport.switchCodeLine(0, 2);
        this.toggleStep();
        this.codeSupport.switchCodeLine(2, 3);
        AnimatedIntArray b = this.generateHelperArray(l, r);
        this.toggleStep();
        this.codeSupport.unhighlightCode(3);
        ++this.nrComparisons;
        if (r > l) {
            this.codeSupport.highlightCode(4);
            int m = (l + r) / 2;
            ++this.nrAssigns;
            this.toggleStep();
            this.codeSupport.unhighlightCode(4);
            this.mergesort(array, l, m);
            this.codeSupport.switchCodeLine(5, 6);
            this.mergesort(array, m + 1, r);
            ++this.nrAssigns;
            this.toggleStep();
            this.codeSupport.switchCodeLine(6, 7);
            ++this.pointerCounter;
            AnimatedIntArrayMarker localIMarker = new AnimatedIntArrayMarker(array, l, "i" + this.pointerCounter, this.sb, "i");
            ++this.pointerCounter;
            AnimatedIntArrayMarker copyMarker = new AnimatedIntArrayMarker(b, l, "copy" + this.pointerCounter, this.sb, "copy");
            int i = l;
            while (i <= m && i < array.getLength()) {
                this.toggleStep();
                localIMarker.moveArrayIndex(i);
                copyMarker.moveArrayIndex(i);
                this.toggleStep();
                b.putElement(array.getElementAt(i), i);
                b.highlightArrayCell(i);
                array.highlightArrayCell(i);
                this.nrComparisons += 2;
                ++i;
            }
            this.nrComparisons += 2;
            ++this.nrAssigns;
            this.endStep();
            this.codeSupport.switchCodeLine(7, 8);
            ++this.pointerCounter;
            AnimatedIntArrayMarker localJMarker = new AnimatedIntArrayMarker(array, m + 1, "j" + this.pointerCounter, this.sb, "copy");
            int targetPos = -1;
            int j = m + 1;
            while (j <= r) {
                this.toggleStep();
                targetPos = r + m + 1 - j;
                localJMarker.moveArrayIndex(j);
                copyMarker.moveArrayIndex(targetPos);
                this.toggleStep();
                b.putElement(array.getElementAt(j), targetPos);
                b.highlightArrayCell(targetPos);
                array.highlightArrayCell(j);
                ++this.nrComparisons;
                ++j;
            }
            ++this.nrComparisons;
            this.nrAssigns += 3;
            this.toggleStep();
            this.codeSupport.switchCodeLine(8, 9);
            AnimatedIntArrayMarker localKMarker = null;
            int k = l;
            i = l;
            j = r;
            while (k <= r && k < array.getLength()) {
                this.codeSupport.unhighlightCode(10);
                localIMarker.moveArrayIndex(i);
                localJMarker.moveArrayIndex(j);
                if (localKMarker == null) {
                    localKMarker = new AnimatedIntArrayMarker(array, l, "k" + this.pointerCounter, this.sb, "k");
                } else {
                    localKMarker.moveArrayIndex(k);
                }
                this.toggleStep();
                this.codeSupport.switchCodeLine(9, 10);
                array.highlightArrayCell(k);
                if (b.getElementAt(i) < b.getElementAt(j)) {
                    array.putElement(b.getElementAt(i), k);
                    localIMarker.moveArrayIndex(i + 1);
                } else {
                    array.putElement(b.getElementAt(j), k);
                    localJMarker.moveArrayIndex(j - 1);
                }
                ++this.nrComparisons;
                this.nrAssigns += 2;
                ++k;
            }
            this.nrComparisons += 2;
        }
        this.toggleStep();
        this.sb.append("hide \"");
    }

    protected String getAlgorithmDescription() {
        return DESCRIPTION;
    }

    protected String getAlgorithmCode() {
        return SOURCE_CODE;
    }

    public String getName() {
        return "Merge Sort";
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getCodeExample() {
        return SOURCE_CODE;
    }

    public Locale getContentLocale() {
        return Locale.US;
    }
}

