/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.exceptions.LineNotExistsException;
import animalscriptapi.primitives.ArrayMarker;
import animalscriptapi.primitives.IntMatrix;
import animalscriptapi.primitives.Rect;
import animalscriptapi.primitives.SourceCode;
import animalscriptapi.primitives.StringArray;
import animalscriptapi.primitives.Text;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.util.Coordinates;
import animalscriptapi.util.Offset;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.CompressionAlgorithm;
import java.awt.Color;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTF
extends CompressionAlgorithm
implements Generator {
    SourceCode sc;
    private static final int inputLimit = 30;
    private static final String DESCRIPTION = "Das Move to Front Verfahren eignet sich f\u00fcr eine weitere Bearbeitung von Burrows Wheeler transformierten Daten. Der Eingabestring wird in eine Zahlenfolge verarbeitet, die sich wiederum verbessert Huffman kodieren l\u00e4sst.";
    private static final String SOURCE_CODE = "Der Algorithmus wird in einer Animation demonstriert. Um die grafische Animation in voller Gr\u00f6\u00dfe darstellen zu k\u00f6nnen, wird die Eingabe auf 30 Buchstaben begrenzt.";

    public MTF() {
        this(new AnimalScript("Move to Front", "Florian Lindner", 800, 600));
    }

    public MTF(Language l) {
        this.lang = l;
        this.lang.setStepMode(true);
    }

    public void compress(String[] text) throws LineNotExistsException {
        String eingabe = "";
        String[] t = new String[Math.min(text.length, 30)];
        int i = 0;
        while (i < t.length) {
            t[i] = text[i];
            eingabe = String.valueOf(eingabe) + text[i];
            ++i;
        }
        text = t;
        Text topic = this.lang.newText(new Coordinates(20, 50), "Move to Front Encoding", "Topic", null, tptopic);
        Rect topicRect = this.lang.newRect(new Offset(-5, -5, topic, "NW"), new Offset(5, 5, topic, "SE"), "topicRect", null, rctp);
        this.lang.nextStep();
        Text eingabeText = this.lang.newText(new Offset(0, 40, topic, "SW"), "Eingabe:", "eingabe", null, tpsteps);
        Text eingabeText2 = this.lang.newText(new Offset(20, -5, eingabeText, "SE"), eingabe, "eingabe", null, tpsteps);
        eingabeText2.changeColor(null, Color.RED, null, null);
        this.lang.nextStep();
        Text algoinWords = this.lang.newText(new Offset(0, 35, eingabeText, "SW"), "Der Algorithmus in Worten", "inWords", null, tpwords);
        this.lang.nextStep();
        Text step1 = this.lang.newText(new Offset(0, 120, topic, "SW"), "1) Initialisiere eine Tabelle der Eingabe, welche Burrows Wheeler transformiert ist.", "line1", null, tpsteps);
        Text step12 = this.lang.newText(new Offset(0, 20, step1, "SW"), "     Die Tabelle enth\u00e4lt jedes Zeichen genau einmal. Sie beinhaltet die Buchstaben", "line1", null, tpsteps);
        Text step13 = this.lang.newText(new Offset(0, 20, step12, "SW"), "     mit aufsteigenden Indizes und ist alphabetisch geordnet.", "line1", null, tpsteps);
        this.lang.nextStep();
        Text step2 = this.lang.newText(new Offset(0, 40, step13, "SW"), "2) F\u00fcr jedes Zeichen der transformierten Eingabe:", "line2", null, tpsteps);
        Text step21 = this.lang.newText(new Offset(0, 20, step2, "SW"), "    - Erweitere die Ausgabe um die Indexstelle des aktuellen Zeichens.", "line2", null, tpsteps);
        Text step22 = this.lang.newText(new Offset(0, 20, step21, "SW"), "    - Setze das Zeichen in der Tabelle an Position 0.", "line2", null, tpsteps);
        String letters = "";
        char small = '\u0000';
        int i2 = 0;
        while (i2 < text.length) {
            char tmp = '\u0100';
            int j = 0;
            while (j < text.length) {
                if (text[j].charAt(0) > small && text[j].charAt(0) < tmp) {
                    tmp = text[j].charAt(0);
                }
                ++j;
            }
            small = tmp;
            if (small != '\u0100') {
                letters = String.valueOf(letters) + small;
            }
            ++i2;
        }
        String lettersOut = letters;
        int inputCnt = 0;
        StringArray in = this.lang.newStringArray(new Offset(100, 65, step22, "SW"), text, "in", null, ap);
        ArrayMarker am = this.lang.newArrayMarker(in, 0, "am", null, amp);
        in.highlightCell(0, null, null);
        int[][] ind = new int[1][letters.length()];
        int i3 = 0;
        while (i3 < ind[0].length) {
            ind[0][i3] = i3;
            ++i3;
        }
        IntMatrix indizes = this.lang.newIntMatrix(new Offset(25, 25, in, "SW"), ind, "ind", null, mp);
        String[] l = new String[letters.length()];
        int i4 = 0;
        while (i4 < l.length) {
            l[i4] = " " + letters.charAt(i4) + "  ";
            ++i4;
        }
        StringArray let = this.lang.newStringArray(new Offset(-7, 7, indizes, "SW"), l, "letters", null, ap);
        this.lang.nextStep();
        String result = "";
        Text ausgabeLabel = this.lang.newText(new Offset(0, 30, let, "SW"), "Ausgabe:", "ausgabe", null, tpsteps);
        Text ausgabe = this.lang.newText(new Offset(10, -5, ausgabeLabel, "SE"), result, "ausgabe", null, tpsteps);
        ausgabe.changeColor(null, Color.BLUE, null, null);
        int i5 = 0;
        while (i5 < text.length) {
            if (i5 > 0) {
                am.move(i5, null, null);
                in.highlightCell(i5, null, null);
                in.unhighlightCell(i5 - 1, null, null);
                ++inputCnt;
            }
            this.lang.nextStep();
            result = String.valueOf(result) + letters.indexOf(text[i5]);
            ausgabe.setText(result, null, null);
            letters = String.valueOf(text[i5]) + letters.replace(text[i5], "");
            this.lang.nextStep();
            int j = 0;
            while (j < letters.length()) {
                let.put(j, " " + letters.charAt(j) + "  ", null, null);
                ++j;
            }
            this.lang.nextStep();
            ++i5;
        }
        Text fazit = this.lang.newText(new Offset(-100, 60, ausgabeLabel, "SW"), "Die Ausgabe wird als Weiterverarbeitung Burrows Wheeler transformierter Daten verwendet.", "Ausgabe", null, tpsteps);
        Text fazit2 = this.lang.newText(new Offset(0, 20, fazit, "SW"), "Die Ausgabe kann nun ideal mit einer Huffman Kodierung komprimiert werden.", "ausgabe", null, tpsteps);
        Text fazit3 = this.lang.newText(new Offset(0, 20, fazit2, "SW"), "Das Move to Front - Verfahren ist folglich das Mittelst\u00fcck eines 3 teiligen Kompressions-", "fazit", null, tpsteps);
        Text fazit4 = this.lang.newText(new Offset(0, 20, fazit3, "SW"), "verfahrens.", "fazit", null, tpsteps);
        Text fazit5 = this.lang.newText(new Offset(0, 20, fazit4, "SW"), "F\u00fcr die Dekodierung werden die einzelnen Buchstaben mit ausgeliefert: ", "fazit", null, tpsteps);
        Text fazit6 = this.lang.newText(new Offset(20, -5, fazit5, "SE"), lettersOut, "fazit", null, tpsteps);
        fazit6.changeColor(null, Color.BLUE, null, null);
    }

    public static String getSOURCE_CODE() {
        return SOURCE_CODE;
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getName() {
        return "Move to Front";
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        String[] strArray = (String[])primitives.get("stringArray");
        try {
            this.compress(strArray);
        }
        catch (LineNotExistsException e) {
            e.printStackTrace();
        }
        return this.lang.toString();
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(64);
    }
}

