/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.exceptions.LineNotExistsException;
import animalscriptapi.primitives.ArrayMarker;
import animalscriptapi.primitives.Rect;
import animalscriptapi.primitives.SourceCode;
import animalscriptapi.primitives.StringArray;
import animalscriptapi.primitives.StringMatrix;
import animalscriptapi.primitives.Text;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.properties.ArrayMarkerProperties;
import animalscriptapi.properties.SourceCodeProperties;
import animalscriptapi.util.Coordinates;
import animalscriptapi.util.Offset;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.CompressionAlgorithm;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LZW
extends CompressionAlgorithm
implements Generator {
    private SourceCode sc;
    private static final int inputLimit = 24;
    private static final String DESCRIPTION = "Der Lempel Ziv Welch Algorithmus ist ein verlustfreies Kompressionsverfahren f\u00fcr Texte. Er verwendet ein W\u00f6rterbuch, um h\u00e4ufig vorkommende Zeichenketten durch einen Schl\u00fcssel zu ersetzen. Einzelne Zeichen werden durch ihren jeweiligen ASCII-Wert kodiert. Es wird kein W\u00f6rterbuch aus einer Datenbank ben\u00f6tigt. Die Erstellung des W\u00f6rterbuchs erfolgt zur Laufzeit. So werden aufeinanderfolgende Zeichen sukzessive dem W\u00f6rterbuch hinzugef\u00fcgt, sofern ihr Pr\u00e4fix bereits im W\u00f6rterbuch vorhanden ist.";
    private static final String SOURCE_CODE = "Der Algorithmus wird in einer Animation demonstriert. Um die grafische Animation in voller Gr\u00f6\u00dfe darstellen zu k\u00f6nnen, wird die Eingabe auf 24 Buchstaben begrenzt.\n\npublic static void lzw(String[] text) {\nString w, k, result;\n int cnt = 256;\n Hashtable<String, Integer> dict = new Hashtable<String, Integer>();\n  for (int i = 0; i < 256;i++) {\n   dict.put(\"\" + ((char)i), i);\n  }\n  for (int i=0; i < text.length; i++) {\n   k = text[i];\n   if (dict.containsKey(w + k)) w = w + k;\n   else {\n    result += dict.get(w) + \" \";\n    dict.put(w + k, cnt);\n    cnt++;\n    w = k;\n   }\n  }\n }";

    public LZW() {
        this(new AnimalScript("LZW Compression", "Florian Lindner", 800, 600));
    }

    public LZW(Language aLanguage) {
        this.lang = aLanguage;
        this.lang.setStepMode(true);
    }

    public void compress(String[] text) throws LineNotExistsException {
        String ein = "";
        String[] t = new String[Math.min(text.length, 24)];
        int i = 0;
        while (i < t.length) {
            t[i] = text[i];
            ein = String.valueOf(ein) + text[i];
            ++i;
        }
        text = t;
        Text topic = this.lang.newText(new Coordinates(20, 50), "LZW", "Topic", null, tptopic);
        Rect topicRect = this.lang.newRect(new Offset(-5, -5, topic, "NW"), new Offset(5, 5, topic, "SE"), "topicRect", null, rctp);
        this.lang.nextStep();
        Text algoinWords = this.lang.newText(new Coordinates(20, 100), "Der Algorithmus in Worten", "inWords", null, tpwords);
        this.lang.nextStep();
        Text step0 = this.lang.newText(new Offset(0, 100, topic, "SW"), "0) Der Algorithmus erzeugt w\u00e4hrend der Laufzeit eigenst\u00e4ndig ein W\u00f6rterbuch. Einzelne Zeichen", "line0", null, tpsteps);
        Text step01 = this.lang.newText(new Offset(0, 20, step0, "SW"), "    werden gem\u00e4\u00df ASCII-Standard kodiert. F\u00fcr diese Zeichen sind also im W\u00f6rterbuch die Eintr\u00e4ge", "line0", null, tpsteps);
        Text step02 = this.lang.newText(new Offset(0, 20, step01, "SW"), "    0 bis 255 reserviert. F\u00fcr jede neue Kodierung wird sukzessive ab 256 ein neuer Eintrag angelegt.", "line0", null, tpsteps);
        this.lang.nextStep();
        Text step1 = this.lang.newText(new Offset(0, 40, step02, "SW"), "1) Iteriere buchstabenweise \u00fcber die Eingabe:", "line1", null, tpsteps);
        this.lang.nextStep();
        Text step2 = this.lang.newText(new Offset(0, 40, step1, "SW"), "2) Betrachte an jeder Stelle den vorhergegangen Buchstaben bzw. ein Pr\u00e4fix, welches in 3) entstehen kann.", "line2", null, tpsteps);
        this.lang.nextStep();
        Text step3 = this.lang.newText(new Offset(0, 40, step2, "SW"), "3) Ist die Kombination des Pr\u00e4fixes im W\u00f6rterbuch abgespeichert, so vergr\u00f6\u00dfere das aktuelle Pr\u00e4fix", "line3", null, tpsteps);
        Text step31 = this.lang.newText(new Offset(0, 20, step3, "SW"), "    um den eingelesenen Buchstaben und fahre beim n\u00e4chsten Buchstaben in 2) fort.", "line31", null, tpsteps);
        this.lang.nextStep();
        Text step4 = this.lang.newText(new Offset(0, 40, step31, "SW"), "4) Ansonsten kodiere das Pr\u00e4fix des aktuellen Buchstabens durch das W\u00f6rterbuch, f\u00fcge das Pr\u00e4fix konkateniert", "line4", null, tpsteps);
        Text step41 = this.lang.newText(new Offset(0, 20, step4, "SW"), "    mit dem aktuellen Buchstaben dem W\u00f6rterbuch hinzu und fahre beim n\u00e4chsten Buchstaben fort.", "line41", null, tpsteps);
        this.lang.nextStep();
        algoinWords.hide();
        step0.hide();
        step01.hide();
        step02.hide();
        step1.hide();
        step2.hide();
        step3.hide();
        step31.hide();
        step4.hide();
        step41.hide();
        StringArray strArray = this.lang.newStringArray(new Offset(0, 100, topic, "SW"), text, "stringArray", null, ap);
        SourceCodeProperties scp = new SourceCodeProperties();
        scp.set("contextColor", Color.RED);
        scp.set("font", new Font("Monospaced", 0, 12));
        scp.set("highlightColor", Color.RED);
        scp.set("color", Color.BLACK);
        this.sc = this.lang.newSourceCode(new Offset(0, 50, strArray, "SW"), "codeName", null, scp);
        this.sc.addCodeLine("public void lzw(String[] array) {", null, 0, null);
        this.sc.addCodeLine("String w, k, result;", null, 1, null);
        this.sc.addCodeLine("int cnt = 256;", null, 1, null);
        this.sc.addCodeLine("Hashtable dict = internSetupMethod();", null, 1, null);
        this.sc.addCodeLine("for (int i=0; i < text.length; i++) {", null, 1, null);
        this.sc.addCodeLine("k = text[i];", null, 2, null);
        this.sc.addCodeLine("if (dict.containsKey(w + k)) w = w + k;", null, 2, null);
        this.sc.addCodeLine("else { ", null, 2, null);
        this.sc.addCodeLine("result += dict.get(w);", null, 3, null);
        this.sc.addCodeLine("dict.put(w + k, cnt);", null, 3, null);
        this.sc.addCodeLine("cnt++;", null, 3, null);
        this.sc.addCodeLine("w = k;", null, 3, null);
        this.sc.addCodeLine("}", null, 2, null);
        this.sc.addCodeLine("}", null, 1, null);
        this.sc.addCodeLine("}", null, 0, null);
        this.lang.nextStep();
        ArrayMarkerProperties amp = new ArrayMarkerProperties();
        amp.set("label", "i");
        amp.set("color", Color.BLACK);
        this.sc.highlight(0, 0, false);
        this.lang.nextStep();
        this.sc.toggleHighlight(0, 0, false, 1, 0);
        this.lang.nextStep();
        this.sc.toggleHighlight(1, 0, false, 2, 0);
        this.lang.nextStep();
        this.sc.toggleHighlight(2, 0, false, 3, 0);
        this.lang.nextStep();
        this.sc.unhighlight(3, 0, false);
        this.sc.highlight(4);
        String w = "";
        String k = "";
        String result = "";
        int cnt = 256;
        Hashtable<String, Integer> dict = new Hashtable<String, Integer>();
        int i2 = 0;
        while (i2 < 256) {
            dict.put("" + (char)i2, i2);
            ++i2;
        }
        String[][] dictData = new String[24][2];
        int i3 = 0;
        while (i3 < 24) {
            dictData[i3][0] = "";
            dictData[i3][1] = "";
            ++i3;
        }
        StringMatrix dic = this.lang.newStringMatrix(new Offset(200, -125, strArray, "E"), dictData, "dict", null, mp);
        int matrixCount = 0;
        ArrayMarker am = this.lang.newArrayMarker(strArray, 0, "arrayMarker", null, amp);
        Text wLabel = this.lang.newText(new Offset(0, 50, this.sc, "SW"), "w: ", "w", null, tpsteps);
        Text kLabel = this.lang.newText(new Offset(0, 20, wLabel, "SW"), "k: ", "k", null, tpsteps);
        Text ausgabeLabel = this.lang.newText(new Offset(0, 30, kLabel, "SW"), "Ausgabe:", "ausgabe", null, tpsteps);
        Text ausgabe = this.lang.newText(new Offset(15, -5, ausgabeLabel, "SE"), "", "ausgabe", null, tpsteps);
        int highlightCounter = 0;
        ausgabe.changeColor(null, Color.BLUE, null, null);
        int i4 = 0;
        while (i4 < text.length) {
            am.move(i4, null, null);
            this.sc.highlight(4, 0, false);
            this.lang.nextStep();
            this.sc.toggleHighlight(4, 0, false, 5, 0);
            k = text[i4];
            kLabel.setText("k:  " + k, null, null);
            this.lang.nextStep();
            this.sc.toggleHighlight(5, 0, false, 6, 0);
            if (dict.containsKey(String.valueOf(w) + k)) {
                w = String.valueOf(w) + k;
                wLabel.setText("w: " + w, null, null);
                this.lang.nextStep();
                this.sc.unhighlight(6, 0, false);
            } else {
                this.sc.toggleHighlight(6, 0, false, 7, 0);
                this.lang.nextStep();
                this.sc.toggleHighlight(7, 0, false, 8, 0);
                result = String.valueOf(result) + dict.get(w) + " ";
                ausgabe.setText(result, null, null);
                this.lang.nextStep();
                this.sc.toggleHighlight(8, 0, false, 9, 0);
                dict.put(String.valueOf(w) + k, cnt);
                dic.put(matrixCount, 0, "" + new Integer(cnt), null, null);
                dic.put(matrixCount, 1, String.valueOf(w) + k, null, null);
                dic.highlightCell(highlightCounter, 0, null, null);
                dic.highlightCell(highlightCounter, 1, null, null);
                if (highlightCounter > 0) {
                    dic.unhighlightCell(highlightCounter - 1, 0, null, null);
                    dic.unhighlightCell(highlightCounter - 1, 1, null, null);
                }
                ++highlightCounter;
                ++matrixCount;
                this.lang.nextStep();
                this.sc.toggleHighlight(9, 0, false, 10, 0);
                ++cnt;
                this.lang.nextStep();
                this.sc.toggleHighlight(10, 0, false, 11, 0);
                w = k;
                wLabel.setText("w: " + w, null, null);
                this.lang.nextStep();
                this.sc.unhighlight(11, 0, false);
            }
            ++i4;
        }
        Text fazit1 = this.lang.newText(new Offset(0, 90, ausgabeLabel, "SW"), "Das W\u00f6rterbuch wird dabei nicht mit ausgegeben, da es in der Dekompression", "name", null, tpsteps);
        Text fazit2 = this.lang.newText(new Offset(0, 20, fazit1, "SW"), "neu generiert werden kann.", "fazit", null, tpsteps);
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        String[] strArray = (String[])primitives.get("stringArray");
        try {
            this.compress(strArray);
        }
        catch (LineNotExistsException e) {
            e.printStackTrace();
        }
        return this.lang.toString();
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(64);
    }

    @Override
    public String getName() {
        return "LZW";
    }
}

