/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import algorithm.animalTranslator.AnimalTranslator;
import algorithm.fileHandler.FileHandler;
import algorithm.stringSearch.KMPStringSearch;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.util.Hashtable;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnuthMorrisPrattStringSearchWrapper
implements Generator {
    private static final String DESCRIPTION = "Im Unterschied zur direkten Brute-Force Suche eines Textes in einer Zeichenfolge versucht der Algorithmus von Knuth, Morris und Pratt, das Wissen \u00fcber die bereits gelesenen Zeichen auszunutzen. Dazu wird zun\u00e4chst f\u00fcr jedes m\u00f6gliche Eingabezeichen eine 'Verschiebetabelle' berechnet. Diese gibt f\u00fcr jedes Eingabezeichen an, wie die Suchmaske \u00fcber den Text weiterzuschieben ist, wenn das gegebene Zeichen gefunden wird.";
    private static final String SOURCE_CODE = "fehlt noch.";
    private GeneratorType myType = new GeneratorType(2);

    @Override
    public GeneratorType getGeneratorType() {
        return this.myType;
    }

    @Override
    public String getName() {
        return "Knuth/Morris/Pratt-Suche in Strings";
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        String fullText = (String)primitives.get("text");
        String toSearch = (String)primitives.get("searchFor");
        FileHandler handler = new FileHandler("demo.asu");
        AnimalTranslator animalTrans = new AnimalTranslator(handler);
        KMPStringSearch kmpSearch = new KMPStringSearch(animalTrans);
        kmpSearch.initialize(fullText, toSearch);
        try {
            kmpSearch.generateAnimation();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return handler.getAnimationCode();
    }

    @Override
    public Locale getContentLocale() {
        return Locale.GERMANY;
    }
}

