/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import generator.Generator;
import generatorImplementations.SortingAlgorithm;
import java.util.Locale;

public class InsertionSortPseudoCode
extends SortingAlgorithm
implements Generator {
    private static final String DESCRIPTION = "Dieser Generator sortiert das vom Nutzer eingegebene Array mittels Insertion Sort.Der Algorithmus entnimmt der unsortierten Eingabemenge ein beliebiges (z.B. das erste) Element und f\u00fcgt es an richtiger Stelle in die (anfangs leere) Ausgabemenge ein. Das Verfahren arbeitet also in-place. Geht man in der Reihenfolge der urspr\u00fcnglichen Menge vor, so ist es jedoch (etwa im Gegensatz zu Selection Sort) stabil. Wird auf einem Array gearbeitet, so m\u00fcssen die Elemente nach dem neu eingef\u00fcgten Element verschoben werden. Dies ist die eigentlich teure Operation von Insertionsort, da das Finden der richtigen Einf\u00fcgeposition \u00fcber eine bin\u00e4re Suche vergleichsweise effizient erfolgen kann.";
    private static final String HEADER_TEXT = "text \"f1-01\" \"Bubble Sort\" at (120,50) color black font SansSerif size 32 bold\n{\n  text \"f1-02a\" \"Bubble Sort is an elementary sorting algorithm, popular\" at (20,100) color black font SansSerif size 24\n  text \"f1-02b\" \"in many introductory CS classes.\" at (20,130) color black font SansSerif size 24\n}\n{\n  text \"f1-03a\" \"The basic idea is to swap immediate neighboring elements\" at (20,170) color black font SansSerif size 24\n  text \"f1-03b\" \"if they are not in order.\" at (20,200) color black font SansSerif size 24\n}\nhideAll\ntext \"f2-01\" \"Verbal description\" at (120,50) color black font SansSerif size 32 bold\ntext \"f2-02\" \"1. Set i=n\" at (20,100) color black font SansSerif size 24\ntext \"f2-03\" \"2. Set j=1 and a boolean variable swapPerformed to false.\" at (20,140) color black font SansSerif size 24\n{\n  text \"f2-04a\" \"3. Swap in a loop all elements a[j-1] and a[j],\" at (20,180) color black font SansSerif size 24\n  text \"f2-04b\" \"    if a[j-1] > a[j], and set swapPerformed to true\" at (20,210) color black font SansSerif size 24\n}\ntext \"f2-05\" \"4. Increment j until j==i\" at (20,250) color black font SansSerif size 24\n{  text \"f2-06a\" \"5. Decrement i. If i==-1 or swapPerformed ==  false,\" at (20,290) color black font SansSerif size 24\n  text \"f2-06b\" \"    end the algorithm; otherwise go to step 2\" at (20,320) color black font SansSerif size 24\n}";
    private static final String SOURCE_CODE = "InsertionSort(int[] array)\n  Declare int variables currentPos, insertPos, currentVal;\n  currentPos = 1;\n  while currentPos < array length:  \n    currentVal = array[i];\n    insertPos = currentPos;\n    while insertPos > 0 and currentVal < array[insertPos - 1]:\n      array[insertPos] = array[insertPos - 1];\n      insertPos = insertPos - 1;\n    array[insertPos] = currentVal;\n    currentPos = currentPos + 1;";

    public void sort(int[] a) {
        this.nrAssigns = 0;
        this.nrComparisons = 0;
        boolean jDefined = false;
        boolean enteredLoop = false;
        this.sb.setLength(0);
        this.sb.append("%Animal 2.0");
        this.sb.append("\ntitle \"Insertion Sort with Pseudo Code Animation\"");
        this.sb.append("\nauthor \"Dr. Guido R\u00f6\u00dfling <roessling@acm.org>\"");
        this.sb.append(HEADER_TEXT);
        this.sb.append("\nhideAll\n");
        this.targetArray = this.createIntArray("array");
        this.toggleStep();
        this.codeSupport = this.createCode(SOURCE_CODE, "code");
        this.toggleStep();
        this.codeSupport.highlightCode(0);
        this.toggleStep();
        this.codeSupport.highlightCode(0, true, true);
        this.codeSupport.highlightCode(1);
        this.sb.append("\n  text \"currentVal\" \"currentVal: \" offset (20, 0) from \"array\" SE");
        this.endStep();
        this.toggleStep();
        this.codeSupport.switchCodeLine(1, 2);
        int i = 1;
        ++this.nrAssigns;
        this.iMarker = this.createArrayMarker(this.targetArray, 1, "i");
        this.toggleStep();
        this.codeSupport.switchCodeLine(2, 3);
        while (i < this.targetArray.getLength()) {
            this.toggleStep();
            this.codeSupport.highlightCode(3, true, true);
            this.codeSupport.switchCodeLine(10, 4);
            this.targetArray.highlightArrayElement(i);
            int v = this.targetArray.getElementAt(i);
            ++this.nrAssigns;
            if (i > 1) {
                this.sb.append("\n hide \"cVal").append(i - 1).append("\"");
                this.codeSupport.unhighlightCode(10);
            }
            this.sb.append("\n  text \"cVal").append(i).append("\" \"").append(v);
            this.sb.append("\" offset (20, 0) from \"currentVal\" baseline after 5 ticks");
            this.toggleStep();
            this.codeSupport.switchCodeLine(4, 5);
            this.targetArray.unhighlightArrayElement(i);
            int j = i;
            if (!jDefined) {
                this.jMarker = this.createArrayMarker(this.targetArray, i, "j");
                jDefined = true;
            } else {
                this.jMarker.moveArrayIndex(j);
            }
            this.toggleStep();
            this.codeSupport.switchCodeLine(5, 6);
            enteredLoop = false;
            while (j > 0 && v < a[j - 1]) {
                this.toggleStep();
                if (!enteredLoop) {
                    this.codeSupport.highlightCode(6, true, true);
                    enteredLoop = true;
                } else {
                    this.codeSupport.unhighlightCode(8);
                }
                this.nrComparisons += 2;
                this.targetArray.putElement(this.targetArray.getElementAt(j - 1), j);
                ++this.nrAssigns;
                this.codeSupport.highlightCode(7);
                this.targetArray.highlightArrayCell(j);
                ++this.nrAssigns;
                this.toggleStep();
                this.codeSupport.switchCodeLine(7, 8);
                this.jMarker.moveArrayIndex(--j);
                this.targetArray.unhighlightArrayCell(j + 1);
            }
            if (enteredLoop) {
                this.codeSupport.unhighlightCode(8);
            }
            this.toggleStep();
            this.codeSupport.switchCodeLine(6, 9);
            this.targetArray.putElement(v, j);
            ++this.nrAssigns;
            this.targetArray.highlightArrayCell(j);
            ++i;
            ++this.nrAssigns;
            this.toggleStep();
            this.codeSupport.switchCodeLine(9, 10);
            this.targetArray.unhighlightArrayCell(j);
            this.sb.append("\n  movemarker \"i\" to ");
            if (i < a.length) {
                this.iMarker.moveArrayIndex(i);
                continue;
            }
            this.iMarker.moveArrayIndex(-1);
        }
        this.codeSupport.unhighlightCode(3);
        this.endAnimGeneration();
        this.endStep();
        this.sb.append("{\n  hideAll\n  text \"eoa\" \"Ende der Animation\" at (120,50) color black font SansSerif size 32\n  text \"comps\" \"Es wurden \" +$\"nrComparisons\" asInt +\" Vergleiche\" at (20,100) color black font SansSerif size 24\n  text \"swaps\" \"und \" +$\"nrAssignments\" asInt +\" Zuweisungen durchgef\u00fchrt.\" at (20,130) color black font SansSerif size 24\n}");
    }

    protected String getAlgorithmDescription() {
        return DESCRIPTION;
    }

    protected String getAlgorithmCode() {
        return SOURCE_CODE;
    }

    public String getName() {
        return "Insertion Sort (Pseudocode, English)";
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getCodeExample() {
        return SOURCE_CODE;
    }

    public Locale getContentLocale() {
        return Locale.GERMANY;
    }
}

