/*
 * Decompiled with CFR 0.152.
 */
package generator;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorType
implements Comparable {
    public static final int GENERATOR_TYPE_SORT = 1;
    public static final int GENERATOR_TYPE_SEARCH = 2;
    public static final int GENERATOR_TYPE_TREE = 4;
    public static final int GENERATOR_TYPE_GRAPH = 8;
    public static final int GENERATOR_TYPE_DATA_STRUCTURE = 16;
    public static final int GENERATOR_TYPE_HASHING = 32;
    public static final int GENERATOR_TYPE_COMPRESSION = 64;
    public static final int GENERATOR_TYPE_CRYPT = 128;
    public static final int GENERATOR_TYPE_BACKTRACKING = 256;
    public static final int GENERATOR_TYPE_MORE = 0x40000000;
    private static TreeMap<Integer, String> mapStrings = new TreeMap();
    private static HashMap<Integer, Integer> mapIndex = new HashMap();
    private int myType;

    public GeneratorType() {
        this.myType = 0x40000000;
    }

    public GeneratorType(int newType) {
        this.setType(newType);
    }

    public static int getNumberOfTypes() {
        GeneratorType.init();
        return mapStrings.size();
    }

    public static String getStringForType(int type) {
        GeneratorType.init();
        String retVal = mapStrings.get(new Integer(type));
        if (retVal == null) {
            return "";
        }
        return retVal;
    }

    public static String getStringForArrayIndex(int index) {
        GeneratorType.init();
        for (Map.Entry<Integer, Integer> e : mapIndex.entrySet()) {
            if (e.getValue() != index) continue;
            int type = e.getKey();
            return GeneratorType.getStringForType(type);
        }
        return "More";
    }

    public int getType() {
        return this.myType;
    }

    public void setType(int newType) {
        GeneratorType.init();
        int storeNewType = 0;
        for (Map.Entry<Integer, String> e : mapStrings.entrySet()) {
            int typeValue = e.getKey();
            if ((newType & typeValue) != typeValue) continue;
            storeNewType |= typeValue;
        }
        if (storeNewType == 0) {
            storeNewType = 0x40000000;
        }
        this.myType = storeNewType;
    }

    public static int[] getTypes() {
        GeneratorType.init();
        int[] retVal = new int[mapStrings.size()];
        int pos = 0;
        for (Map.Entry<Integer, String> e : mapStrings.entrySet()) {
            retVal[pos++] = e.getKey();
        }
        return retVal;
    }

    public static Vector<Integer> getArrayIndexes(int type) {
        Vector<Integer> v = new Vector<Integer>();
        for (Map.Entry<Integer, String> e : mapStrings.entrySet()) {
            int typeValue = e.getKey();
            if ((type & typeValue) != typeValue) continue;
            v.add(new Integer(GeneratorType.getArrayIndex(typeValue)));
        }
        if (v.size() == 0) {
            v.add(new Integer(GeneratorType.getArrayIndex(0x40000000)));
        }
        return v;
    }

    private static int getArrayIndex(int type) {
        GeneratorType.init();
        Integer intObj = mapIndex.get(new Integer(type));
        if (intObj == null) {
            return mapIndex.size() - 1;
        }
        return intObj;
    }

    private static void init() {
        if (mapStrings.isEmpty()) {
            mapStrings.put(new Integer(1), "Sort");
            mapStrings.put(new Integer(2), "Search");
            mapStrings.put(new Integer(4), "Tree");
            mapStrings.put(new Integer(8), "Graph");
            mapStrings.put(new Integer(16), "DataStructures");
            mapStrings.put(new Integer(32), "Hashing");
            mapStrings.put(new Integer(64), "Compression");
            mapStrings.put(new Integer(128), "Crypt");
            mapStrings.put(new Integer(256), "Backtracking");
            mapStrings.put(new Integer(0x40000000), "More");
            int pos = 0;
            for (Map.Entry<Integer, String> e : mapStrings.entrySet()) {
                mapIndex.put(e.getKey(), new Integer(pos++));
            }
        }
    }

    public int compareTo(Object o) {
        if (o instanceof GeneratorType) {
            if (((GeneratorType)o).getType() == this.myType) {
                return 0;
            }
            return -1;
        }
        return Integer.MIN_VALUE;
    }
}

