/*
 * Decompiled with CFR 0.152.
 */
package de.ahrgr.animal.kohnert.generators;

import de.ahrgr.animal.kohnert.asugen.AnimalObject;
import de.ahrgr.animal.kohnert.asugen.AnimalScriptWriter;
import de.ahrgr.animal.kohnert.asugen.Chart;
import de.ahrgr.animal.kohnert.asugen.CodeGroup;
import de.ahrgr.animal.kohnert.asugen.Color;
import de.ahrgr.animal.kohnert.asugen.Font;
import de.ahrgr.animal.kohnert.asugen.Generator;
import de.ahrgr.animal.kohnert.asugen.Node;
import de.ahrgr.animal.kohnert.asugen.PolyLine;
import de.ahrgr.animal.kohnert.asugen.Text;
import de.ahrgr.animal.kohnert.asugen.TextBox;
import de.ahrgr.animal.kohnert.asugen.property.ColorProperty;
import de.ahrgr.animal.kohnert.asugen.property.FontProperty;
import de.ahrgr.animal.kohnert.asugen.property.FormatedTextProperty;
import de.ahrgr.animal.kohnert.asugen.property.Property;
import de.ahrgr.animal.kohnert.asugen.property.TextProperty;
import de.ahrgr.animal.kohnert.generatorgui.GeneratorGUI;
import java.io.PrintWriter;
import java.io.Writer;

public class VigenereDecode
implements Generator {
    GeneratorGUI gui;
    FormatedTextProperty ueberschrift = new FormatedTextProperty("title", "the animation title", "Vigenere Entschl\u00c3\u00bcsselung");
    TextProperty dataString;
    TextProperty keyString;
    TextProperty numSteps;
    TextProperty lbData;
    TextProperty lbKey;
    TextProperty charSet = new TextProperty("algorithm/charset", "The CHARSET property must be equal to the encryption charset", "ABCDEFGHIJKLMNOPQRSTUVWXYZ ,.");
    TextProperty lb1;
    TextProperty lb2;
    TextProperty lb3;
    TextProperty lb4;
    TextProperty lb5;
    TextProperty lb6;
    TextProperty lb7;
    ColorProperty clChartZeile;
    ColorProperty clChartSpalte;
    ColorProperty clChartRest;
    ColorProperty clResult;
    FormatedTextProperty formatText;
    FontProperty codeGroupFont;
    Property[] properties;

    public VigenereDecode() {
        this.dataString = new TextProperty("algorithm/data", "string to be decoded", "SRAYVHKXDU");
        this.keyString = new TextProperty("algorithm/key", "key to use for encryption", "KEY");
        this.numSteps = new TextProperty("algorithm/steps", "number of chars to be decoded with animation(0 = all)", "0");
        this.lb1 = new TextProperty("text/data", "Replacement for \"Text to be decoded: \"", "Zu kodierender Text: ");
        this.lb2 = new TextProperty("text/key", "Replacement for \"Key:                \"", "Schluessel: ");
        this.lb3 = new TextProperty("text/key char assignment", "Replacement for: \"Put the key string repeatedly under the data string.\"", "Den Schl\u00c3\u00bcssel wiederholt unter den zu entschl\u00c3\u00bcsselnden Text schreiben");
        this.lb4 = new TextProperty("text/chart", "Replacement for: \"Use the chart from encryption.\"", "Die gleiche Tabelle wie bei der Verschl\u00c3\u00bcsselung verwenden");
        this.lb5 = new TextProperty("text/find elements", "Replacement for: \"You can find the encoded characters in the column of the data character and the row of the key character.\"", "Jetzt in der Zeile des Schluesselzeichens die Spalte mit dem Datenzeichen suchen");
        this.lb6 = new TextProperty("text/repeat", "Replacement for: \"Repeat this procedure for each character\"", "Wiederhole diesen Vorgang f\u00c3\u00bcr jedes Zeichen");
        this.clChartZeile = new ColorProperty("chart/color first row", "Fill color of the first row", "cyan");
        this.clChartSpalte = new ColorProperty("chart/color first colum", "Fill color of the first column", "cyan2");
        this.clChartRest = new ColorProperty("chart/color", "Fill color of the other cells", "white");
        this.clResult = new ColorProperty("chart/color result", "Background color for the encoded characters", "yellow");
        this.codeGroupFont = new FontProperty("text/font", "Font to use for description", Color.BLACK, Font.FT_DEFAULT);
        this.properties = new Property[16];
        this.properties[0] = this.ueberschrift;
        this.properties[1] = this.dataString;
        this.properties[2] = this.keyString;
        this.properties[3] = this.lb1;
        this.properties[4] = this.lb2;
        this.properties[5] = this.lb3;
        this.properties[6] = this.lb4;
        this.properties[7] = this.lb5;
        this.properties[8] = this.lb6;
        this.properties[9] = this.clChartZeile;
        this.properties[10] = this.clChartSpalte;
        this.properties[11] = this.clChartRest;
        this.properties[12] = this.clResult;
        this.properties[13] = this.codeGroupFont;
        this.properties[14] = this.numSteps;
        this.properties[15] = this.charSet;
    }

    public void generate(Writer out) {
        PrintWriter o = null;
        o = new PrintWriter(out);
        AnimalScriptWriter w = new AnimalScriptWriter(o, this.properties, this.getClass().getName());
        this.generateDecode(w);
        o.close();
    }

    public void generateDecode(AnimalScriptWriter w) {
        TextBox b2;
        w.clear();
        String data = this.dataString.getValue();
        String key = this.keyString.getValue();
        String zeichensatz = this.charSet.getValue();
        w.startBlock();
        w.addLabel("Description");
        Text tx = w.createText(w.abs(10, 40), this.ueberschrift.getText());
        tx.setColor(this.ueberschrift.getColor());
        tx.setFont(this.ueberschrift.getFont());
        w.createRectangle(tx.createOffset(0, 5, 6), tx.createOffset(5, 6, 8));
        CodeGroup g = w.createCodeGroup(tx.createOffset(0, 12, 6));
        g.setFont(this.codeGroupFont.getFont());
        g.setColor(this.codeGroupFont.getColor());
        g.addCodeLine(String.valueOf(this.lb1.getValue()) + data);
        g.addCodeLine(String.valueOf(this.lb2.getValue()) + key);
        g.addCodeLine("");
        Chart chart = new Chart(w, w.abs(10, 360), data.length(), 2);
        chart.setCharsHorizontaly(0, 0, data);
        chart.register();
        w.endBlock();
        w.addLabel("Assign Key Chars");
        g.addCodeLine(this.lb3.getValue());
        int width = data.length();
        int pos = 0;
        while (pos < width) {
            w.startBlock();
            chart.setCharsHorizontaly(pos, 1, key);
            pos += key.length();
            w.endBlock();
        }
        w.addLabel("Create Chart");
        g.addCodeLine(this.lb4.getValue());
        w.startBlock();
        Chart tabelle = new Chart(w, chart.createOffset(50, 200, 7), zeichensatz.length(), key.length() + 1);
        tabelle.setCharsHorizontaly(0, 0, zeichensatz);
        Color cl = Color.createFromString(this.clChartZeile.getValue());
        tabelle.setFillColorRect(0, 0, zeichensatz.length(), 1, cl);
        tabelle.setFillColorRect(0, 1, 1, key.length(), Color.createFromString(this.clChartSpalte.getValue()));
        tabelle.setFillColorRect(1, 1, zeichensatz.length() - 1, key.length(), Color.createFromString(this.clChartRest.getValue()));
        tabelle.register();
        tabelle.setCharsVerticaly(0, 1, key);
        int i = 0;
        while (i < key.length()) {
            w.startBlock();
            char keyChar = key.charAt(i);
            int keyCharPos = zeichensatz.indexOf("" + keyChar);
            String s = zeichensatz.substring(keyCharPos + 1);
            s = String.valueOf(s) + zeichensatz.substring(0, keyCharPos);
            tabelle.setCharsHorizontaly(1, i + 1, s);
            ++i;
        }
        w.endBlock();
        g.addCodeLine(this.lb5.getValue());
        w.addLabel("begin decryption");
        AnimalObject p = null;
        AnimalObject p2 = null;
        TextBox lastChar = null;
        boolean firstChar = true;
        int steps = Integer.parseInt(this.numSteps.getValue());
        if (steps == 0) {
            steps = 1000;
        }
        i = 0;
        while (i < data.length() && i < steps) {
            w.startBlock();
            w.addLabel("decrypt '" + data.charAt(i) + "'");
            if (p != null) {
                p.setHidden(true);
            }
            if (p2 != null) {
                p2.setHidden(true);
            }
            p = new PolyLine(w);
            Node n = chart.getElementAt(i, 0).createOffset(0, 0, 1);
            ((PolyLine)p).addNode(n);
            ((PolyLine)p).addNode(n.createOffset(0, -10));
            n = chart.createOffset(10, -10, 2);
            ((PolyLine)p).addNode(n);
            n = chart.createOffset(10, 10, 8);
            ((PolyLine)p).addNode(n);
            int x = (zeichensatz.length() + zeichensatz.indexOf(data.charAt(i)) - zeichensatz.indexOf(key.charAt(i % key.length()))) % zeichensatz.length();
            n = tabelle.getElementAt(x, 0).createOffset(0, -30, 1);
            ((PolyLine)p).addNode(n);
            ((PolyLine)p).addNode(n.createOffset(0, 30));
            ((PolyLine)p).setArrow(1);
            ((PolyLine)p).register();
            p2 = new PolyLine(w);
            n = chart.getElementAt(i, 1).createOffset(0, 1, 7);
            ((PolyLine)p2).addNode(n);
            ((PolyLine)p2).addNode(n.createOffset(0, 10));
            n = tabelle.createOffset(-50, -50, 0);
            ((PolyLine)p2).addNode(n);
            int y = i % key.length() + 1;
            n = tabelle.getElementAt(0, y).createOffset(-50, 0, 3);
            ((PolyLine)p2).addNode(n);
            ((PolyLine)p2).addNode(n.createOffset(50, 0));
            ((PolyLine)p2).setArrow(1);
            ((PolyLine)p2).register();
            TextBox b = tabelle.getElementAt(x, 0);
            b2 = new TextBox(w, b.getPosition(), b.getText().getValue());
            TextBox b3 = tabelle.getElementAt(x, y);
            b3.getRectangle().setFillColor(Color.ORANGE);
            b2.register();
            b2.getRectangle().setFillColor(Color.createFromString(this.clResult.getValue()));
            n = lastChar == null ? tabelle.createOffset(-30, 30, 6) : lastChar.createOffset(5, 0, 2);
            w.endBlock();
            b2.moveTo(n);
            w.startBlock();
            Color bkcolor = Color.createFromString(this.clChartRest.getValue());
            if (x == 0) {
                bkcolor = Color.createFromString(this.clChartSpalte.getValue());
            }
            b3.getRectangle().setFillColor(bkcolor);
            lastChar = b2;
            if (firstChar) {
                firstChar = false;
                g.addCodeLine(this.lb6.getValue());
            }
            ++i;
        }
        w.startBlock();
        p.setHidden(true);
        p2.setHidden(true);
        while (i < data.length()) {
            int x = (zeichensatz.length() + zeichensatz.indexOf(data.charAt(i)) - zeichensatz.indexOf(key.charAt(i % key.length()))) % zeichensatz.length();
            int y = 0;
            TextBox srcTB = tabelle.getElementAt(x, y);
            Node n = lastChar.getRectangle().createOffset(5, 0, 8);
            b2 = new TextBox(w, n, srcTB.getText().getValue());
            b2.register();
            b2.getRectangle().setFillColor(Color.createFromString(this.clResult.getValue()));
            lastChar = b2;
            ++i;
        }
        w.endBlock();
    }

    public String getGeneratorName() {
        return "Vigenere Decryption";
    }

    public Property[] getProperties() {
        return this.properties;
    }

    public void generateScript(Writer out) {
        this.generate(out);
    }
}

