/*
 * Decompiled with CFR 0.152.
 */
package de.ahrgr.animal.kohnert.asugen;

import de.ahrgr.animal.kohnert.asugen.AnimalObject;
import de.ahrgr.animal.kohnert.asugen.AnimalScriptWriter;
import de.ahrgr.animal.kohnert.asugen.Node;

public class OffsetNode
extends Node {
    protected AnimalObject src;
    protected int offset_x;
    protected int offset_y;
    protected int direction;

    public OffsetNode(AnimalScriptWriter aWriter, AnimalObject psrc, int poffset_x, int poffset_y, int pdirection) {
        super(aWriter);
        this.src = psrc;
        this.offset_x = poffset_x;
        this.offset_y = poffset_y;
        this.direction = pdirection;
    }

    public void print() {
        this.out.print(" offset (");
        this.out.print(this.offset_x);
        this.out.print(", ");
        this.out.print(this.offset_y);
        this.out.print(") from \"");
        this.out.print(this.src.getName());
        this.out.print("\"  ");
        String ds = null;
        switch (this.direction) {
            case 0: {
                ds = "NW";
                break;
            }
            case 1: {
                ds = "N";
                break;
            }
            case 2: {
                ds = "NE";
                break;
            }
            case 3: {
                ds = "W";
                break;
            }
            case 5: {
                ds = "E";
                break;
            }
            case 6: {
                ds = "SW";
                break;
            }
            case 7: {
                ds = "S";
                break;
            }
            case 8: {
                ds = "SE";
                break;
            }
            default: {
                ds = "C";
            }
        }
        this.out.print(ds);
        this.out.print(" ");
    }

    public Node createOffset(int x, int y) {
        return new OffsetNode(this.scriptwriter, this.src, this.offset_x + x, this.offset_y + y, this.direction);
    }
}

