/*
 * Decompiled with CFR 0.152.
 */
package de.ahrgr.animal.kohnert.asugen;

public class Font {
    public static final int DEFAULT = 0;
    public static final int SERIF = 1;
    public static final int SANSSERIF = 2;
    public static final int MONOSPACED = 3;
    public static final Font FT_SERIF = new Font(1);
    public static final Font FT_SANSSERIF = new Font(2);
    public static final Font FT_MONOSPACED;
    public static final Font FT_DEFAULT;
    protected static final String[] fontnames;
    protected int fontcode;
    protected boolean isBold;
    protected boolean isItalic;
    protected int size = 0;

    static {
        FT_DEFAULT = FT_MONOSPACED = new Font(3);
        fontnames = new String[]{"Monospaced", "Serif", "SansSerif", "Monospaced"};
    }

    public Font(int code) {
        this(code, false, false, 0);
    }

    public Font(int code, boolean bold, boolean italic, int aSize) {
        this.fontcode = code;
        this.isBold = bold;
        this.isItalic = italic;
        this.size = aSize;
    }

    public Font(java.awt.Font targetFont) {
        String fontFamily = targetFont.getFamily();
        this.fontcode = -1;
        if ("Monospaced".equalsIgnoreCase(fontFamily)) {
            this.fontcode = 3;
        }
        if ("SansSerif".equalsIgnoreCase(fontFamily)) {
            this.fontcode = 2;
        }
        if ("Serif".equalsIgnoreCase(fontFamily)) {
            this.fontcode = 1;
        }
        if (this.fontcode == -1) {
            this.fontcode = 2;
        }
        this.isBold = targetFont.isBold();
        this.isItalic = targetFont.isItalic();
        this.size = targetFont.getSize();
    }

    public boolean getIsBold() {
        return this.isBold;
    }

    public Font deriveBold(boolean bold) {
        return new Font(this.fontcode, bold, this.isItalic, this.size);
    }

    public boolean getIsItalic() {
        return this.isItalic;
    }

    public Font deriveItalic(boolean italic) {
        return new Font(this.fontcode, this.isBold, italic, this.size);
    }

    public int getSize() {
        return this.size;
    }

    public Font deriveSize(int aSize) {
        return new Font(this.fontcode, this.isBold, this.isItalic, aSize);
    }

    public int getCode() {
        return this.fontcode;
    }

    public String toAnimalString() {
        StringBuilder b = new StringBuilder("font ");
        b.append(this.getFontName());
        if (this.size != 0) {
            b.append(" size ");
            b.append(this.size);
        }
        if (this.isBold) {
            b.append(" bold ");
        }
        if (this.isItalic) {
            b.append(" italic ");
        }
        return b.toString();
    }

    public String getFontName() {
        if (this.fontcode >= 0 && this.fontcode <= 3) {
            return fontnames[this.fontcode];
        }
        return fontnames[0];
    }

    public String toString() {
        return this.getFontName();
    }

    public static Font parseAnimal(String animalCode) {
        String[] t = animalCode.split(" ");
        String fontName = "";
        boolean bold = false;
        boolean italic = false;
        int size = 0;
        int i = 0;
        i = 0;
        while (i < t.length) {
            String s = t[i];
            if ("font".equals(s)) {
                fontName = t[++i];
            }
            if ("bold".equals(s)) {
                bold = true;
            }
            if ("italic".equals(s)) {
                italic = true;
            }
            if ("size".equals(s)) {
                size = Integer.parseInt(t[++i]);
            }
            ++i;
        }
        Font f = Font.createFromString(fontName);
        if (size > 0) {
            f = f.deriveSize(size);
        }
        if (bold) {
            f = f.deriveBold(true);
        }
        if (italic) {
            f = f.deriveItalic(true);
        }
        return f;
    }

    public static Font createFromString(String s) {
        int i = 0;
        while (i < fontnames.length) {
            if (fontnames[i].equalsIgnoreCase(s)) {
                return new Font(i);
            }
            ++i;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Font)) {
            return false;
        }
        return this.getCode() == ((Font)o).getCode();
    }
}

