/*
 * Decompiled with CFR 0.152.
 */
package de.ahrgr.animal.ackermann.guicomponents;

import de.ahrgr.animal.ackermann.guicomponents.IntegerTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class MatrixInputTable
extends JScrollPane {
    private static final long serialVersionUID = -2264273704590965509L;
    private JTable myTable;
    private int iNumberOfColumns = 3;
    private int iNumberOfRows = 3;

    public MatrixInputTable() {
        this.iNumberOfRows = 3;
        this.iNumberOfColumns = 3;
        this.init();
    }

    public MatrixInputTable(int numRows, int numColumns) {
        if (numRows < 1) {
            numRows = 3;
        }
        if (numColumns < 1) {
            numColumns = 3;
        }
        this.iNumberOfRows = numRows;
        this.iNumberOfColumns = numColumns;
        this.init();
    }

    public MatrixInputTable(int[][] newValues) {
        this.iNumberOfRows = 3;
        this.iNumberOfColumns = 3;
        this.init();
        this.setValues(newValues);
    }

    public void setNumberOfColumns(int numColumns) {
        if (numColumns < 1) {
            return;
        }
        this.iNumberOfColumns = numColumns;
        this.dimensionsChanged();
    }

    public int getNumberOfColumns() {
        return this.iNumberOfColumns;
    }

    public void setNumberOfRows(int numRows) {
        if (numRows < 1) {
            return;
        }
        this.iNumberOfRows = numRows;
        this.dimensionsChanged();
    }

    public int getNumberOfRows() {
        return this.iNumberOfRows;
    }

    public void setValues(int[][] newValues) {
        if (newValues == null) {
            return;
        }
        int iNewRows = newValues.length;
        if (iNewRows == 0) {
            return;
        }
        int iNewColumns = newValues[0].length;
        if (iNewColumns == 0) {
            return;
        }
        this.changeDimensions(iNewRows, iNewColumns);
        int i = 0;
        while (i < iNewRows) {
            int j = 0;
            while (j < iNewColumns) {
                if (newValues[i].length >= j - 1) {
                    Integer intObj = new Integer(newValues[i][j]);
                    this.myTable.setValueAt(intObj, i, j);
                } else {
                    this.myTable.setValueAt(new Integer(0), i, j);
                }
                ++j;
            }
            ++i;
        }
    }

    public int[][] getValues() {
        int[][] retval = new int[this.iNumberOfRows][this.iNumberOfColumns];
        int i = 0;
        while (i < this.iNumberOfRows) {
            int j = 0;
            while (j < this.iNumberOfColumns) {
                retval[i][j] = (Integer)this.myTable.getValueAt(i, j);
                ++j;
            }
            ++i;
        }
        return retval;
    }

    public void changeDimensions(int numRows, int numColumns) {
        int j;
        if (numRows < 1 || numColumns < 1) {
            return;
        }
        int iOldCols = this.iNumberOfColumns;
        int iOldRows = this.iNumberOfRows;
        Object[][] oldData = new Object[numRows][numColumns];
        int i = 0;
        while (i < numRows) {
            oldData[i] = new Object[numColumns];
            j = 0;
            while (j < numColumns) {
                oldData[i][j] = i >= iOldRows || j >= iOldCols ? new Integer(0) : this.myTable.getValueAt(i, j);
                ++j;
            }
            ++i;
        }
        this.iNumberOfRows = numRows;
        this.iNumberOfColumns = numColumns;
        this.init();
        i = 0;
        while (i < numRows) {
            j = 0;
            while (j < numColumns) {
                this.myTable.setValueAt(oldData[i][j], i, j);
                ++j;
            }
            ++i;
        }
    }

    private void dimensionsChanged() {
        this.changeDimensions(this.iNumberOfRows, this.iNumberOfColumns);
    }

    private void init() {
        this.setPreferredSize(new Dimension(200, 200));
        Object[] columnNames = new String[this.iNumberOfColumns];
        Object[][] data = new Integer[this.iNumberOfRows][this.iNumberOfColumns];
        int i = 0;
        while (i < this.iNumberOfColumns) {
            columnNames[i] = "Column " + Integer.toString(i);
            int j = 0;
            while (j < this.iNumberOfRows) {
                data[j][i] = new Integer(0);
                ++j;
            }
            ++i;
        }
        this.myTable = new JTable();
        this.myTable.setModel(new IntegerTableModel(data, columnNames));
        i = 0;
        while (i < this.myTable.getColumnCount()) {
            TableColumn column = this.myTable.getColumnModel().getColumn(i);
            IntegerCellEditor editor = new IntegerCellEditor();
            column.setCellEditor(editor);
            ++i;
        }
        this.myTable.setCellSelectionEnabled(true);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        this.myTable.setAutoResizeMode(0);
        this.setViewportView(this.myTable);
    }

    class IntegerCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = -6725001766631532850L;
        private IntegerTextField textField = new IntegerTextField();

        IntegerCellEditor() {
        }

        public Object getCellEditorValue() {
            return this.textField.getValue();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (table == null || row < 0 || column < 0) {
                return null;
            }
            if (value instanceof Integer && (Integer)value != null) {
                this.textField.setText(((Integer)value).toString());
                this.textField.setDefaultValue((Integer)value);
            } else {
                this.textField.setText("0");
                this.textField.setDefaultValue(new Integer(0));
            }
            if (isSelected || !isSelected) {
                this.textField.setBackground(new Color(255, 255, 128));
            }
            this.textField.setBorder(BorderFactory.createEmptyBorder());
            return this.textField;
        }

        public boolean stopCellEditing() {
            super.stopCellEditing();
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IntegerTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 4270055943157017558L;

        public IntegerTableModel(Object[][] data, Object[] columnNames) {
            super(data, columnNames);
        }

        @Override
        public Class<?> getColumnClass(int column) {
            if (column >= 0) {
                return Integer.class;
            }
            return Object.class;
        }
    }
}

