/*
 * Decompiled with CFR 0.152.
 */
package components;

import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class DoubleTextField
extends JTextField {
    private static final long serialVersionUID = 3544949965635270964L;
    private Double defaultValue = new Double(0.0);
    private DoubleDocument dblDoc = new DoubleDocument();

    public DoubleTextField() {
        this.init();
        this.setText("0");
    }

    public DoubleTextField(String text) {
        this.init();
        this.setText(text);
    }

    public DoubleTextField(double value) {
        this.init();
        this.setText(Double.toString(value));
    }

    public DoubleTextField(Double objDbl) {
        this.init();
        this.setText(objDbl.toString());
    }

    public void setDefaultValue(Double newDefaultValue) {
        this.defaultValue = newDefaultValue;
    }

    public Double getDefaultValue() {
        return this.defaultValue;
    }

    public void setText(String text) {
        Double newValue = this.defaultValue;
        if (text.length() != 0) {
            try {
                newValue = new Double(Double.parseDouble(text));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        super.setText(newValue.toString());
    }

    public String getText() {
        return this.getValue().toString();
    }

    public Double getValue() {
        String content = super.getText();
        if (content.length() != 0) {
            try {
                Double retval = new Double(Double.parseDouble(content));
                return retval;
            }
            catch (NumberFormatException nfe) {
                return this.defaultValue;
            }
        }
        return this.defaultValue;
    }

    private void init() {
        this.setDocument(this.dblDoc);
        this.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DoubleTextField textField = (DoubleTextField)e.getSource();
                String content = textField.getText();
                if (content.length() != 0) {
                    try {
                        Double.parseDouble(content);
                    }
                    catch (NumberFormatException nfe) {
                        DoubleTextField.this.getToolkit().beep();
                        textField.setText(textField.getDefaultValue().toString());
                    }
                } else {
                    textField.setText(textField.getDefaultValue().toString());
                }
            }
        });
    }

    static class DoubleDocument
    extends PlainDocument {
        private static final long serialVersionUID = 3978984392574384185L;

        DoubleDocument() {
        }

        public void insertString(int offset, String string, AttributeSet attributes) throws BadLocationException {
            String newValue;
            if (string == null) {
                return;
            }
            int length = this.getLength();
            if (length == 0) {
                newValue = string;
            } else {
                String currentContent = this.getText(0, length);
                StringBuilder currentBuffer = new StringBuilder(currentContent);
                currentBuffer.insert(offset, string);
                newValue = currentBuffer.toString();
            }
            if (newValue.equals("-")) {
                super.insertString(offset, newValue, attributes);
                return;
            }
            try {
                Double.parseDouble(newValue);
                super.insertString(offset, string, attributes);
            }
            catch (NumberFormatException exception) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

