/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.primitives;

import animalscriptapi.primitives.ArrayPrimitive;
import animalscriptapi.primitives.Primitive;
import animalscriptapi.primitives.generators.ArrayMarkerGenerator;
import animalscriptapi.properties.ArrayMarkerProperties;
import animalscriptapi.util.DisplayOptions;
import animalscriptapi.util.Timing;

public class ArrayMarker
extends Primitive {
    private ArrayMarkerGenerator generator = null;
    private ArrayPrimitive belongsTo = null;
    private int position = 0;
    private ArrayMarkerProperties properties = null;

    public ArrayMarker(ArrayMarkerGenerator amg, ArrayPrimitive prim, int index, String name, DisplayOptions display, ArrayMarkerProperties ap) {
        super(amg, display);
        this.generator = amg;
        this.belongsTo = prim;
        this.properties = ap;
        this.setName(name);
        if (index >= 0 && index < prim.getLength()) {
            this.position = index;
        }
        this.generator.create(this);
    }

    public void move(int pos, Timing t, Timing d) {
        this.generator.move(this, pos, t, d);
        this.position = pos;
    }

    public void moveToEnd(Timing t, Timing d) {
        this.generator.moveToEnd(this, t, d);
        this.position = this.getArray().getLength();
    }

    public void moveOutside(Timing t, Timing d) {
        this.generator.moveOutside(this, t, d);
        this.position = this.getArray().getLength() + 1;
    }

    public ArrayPrimitive getArray() {
        return this.belongsTo;
    }

    public int getPosition() {
        return this.position;
    }

    public ArrayMarkerProperties getProperties() {
        return this.properties;
    }

    public void setName(String newName) {
        this.properties.setName(newName);
        super.setName(newName);
    }
}

