/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.animalscript;

import animalscriptapi.animalscript.AnimalGenerator;
import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.primitives.SourceCode;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.primitives.generators.SourceCodeGenerator;
import animalscriptapi.properties.SourceCodeProperties;
import animalscriptapi.util.Timing;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;

public class AnimalSourceCodeGenerator
extends AnimalGenerator
implements SourceCodeGenerator {
    private static int count = 1;
    private HashMap<String, Integer> labelsToLineNumbers = new HashMap(47);

    public AnimalSourceCodeGenerator(Language aLang) {
        super(aLang);
    }

    public void create(SourceCode sc) {
        if (this.isNameUsed(sc.getName()) || sc.getName() == "") {
            sc.setName("SourceCode" + count);
            ++count;
        }
        this.lang.addItem(sc);
        StringBuilder def = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        def.append("codegroup \"" + sc.getName() + "\"");
        def.append(" at " + AnimalGenerator.makeNodeDef(sc.getUpperLeft()));
        SourceCodeProperties props = sc.getProperties();
        if (props.get("color") != null) {
            def.append(" color ");
            def.append(AnimalGenerator.makeColorDef(((Color)props.get("color")).getRed(), ((Color)props.get("color")).getGreen(), ((Color)props.get("color")).getBlue()));
        }
        if (props.get("highlightColor") != null) {
            def.append(" highlightColor ");
            def.append(AnimalGenerator.makeColorDef(((Color)props.get("highlightColor")).getRed(), ((Color)props.get("highlightColor")).getGreen(), ((Color)props.get("highlightColor")).getBlue()));
        }
        if (props.get("contextColor") != null) {
            def.append(" contextColor ");
            def.append(AnimalGenerator.makeColorDef(((Color)props.get("contextColor")).getRed(), ((Color)props.get("contextColor")).getGreen(), ((Color)props.get("contextColor")).getBlue()));
        }
        if (props.get("font") != null) {
            def.append(" font " + ((Font)props.get("font")).getFamily());
        }
        if (props.get("font") != null) {
            def.append(" size " + ((Font)props.get("font")).getSize());
        }
        if (props.get("font") != null && ((Font)props.get("font")).isBold()) {
            def.append(" bold");
        }
        if (props.get("font") != null && ((Font)props.get("font")).isItalic()) {
            def.append(" italic");
        }
        if (props.get("depth") != null) {
            def.append(" depth " + ((Integer)props.get("depth")).toString());
        }
        def.append(AnimalGenerator.makeDisplayOptionsDef(sc.getDisplayOptions()));
        this.lang.addLine(def);
    }

    public void highlight(SourceCode code, int line, int row, boolean context, Timing delay, Timing duration) {
        String def = "highlightCode on \"" + code.getName() + "\" line " + line;
        if (row >= 0) {
            def = String.valueOf(def) + " row " + row;
        }
        if (context) {
            def = String.valueOf(def) + " context";
        }
        def = String.valueOf(def) + AnimalGenerator.makeOffsetTimingDef(delay);
        def = String.valueOf(def) + AnimalGenerator.makeDurationTimingDef(duration);
        this.lang.addLine(def);
    }

    public void highlight(SourceCode code, String lineName, int row, boolean context, Timing delay, Timing duration) {
        Integer lineNo = this.labelsToLineNumbers.get(lineName);
        if (lineNo != null) {
            this.highlight(code, lineNo, row, context, delay, duration);
        } else {
            System.err.println("Argh!: " + lineNo + " for " + lineName);
        }
    }

    public void unhighlight(SourceCode code, String lineName, int row, boolean context, Timing delay, Timing duration) {
        Integer lineNo = this.labelsToLineNumbers.get(lineName);
        if (lineNo != null) {
            this.unhighlight(code, lineNo, row, context, delay, duration);
        } else {
            System.err.println("Argh!: " + lineNo + " for " + lineName);
        }
    }

    public void unhighlight(SourceCode code, int line, int row, boolean context, Timing delay, Timing duration) {
        String def = "unhighlightCode on \"" + code.getName() + "\" line " + line;
        if (row >= 0) {
            def = String.valueOf(def) + " row " + row;
        }
        if (context) {
            def = String.valueOf(def) + " context";
        }
        def = String.valueOf(def) + AnimalGenerator.makeOffsetTimingDef(delay);
        def = String.valueOf(def) + AnimalGenerator.makeDurationTimingDef(duration);
        this.lang.addLine(def);
    }

    public void hide(SourceCode code, Timing delay) {
        this.lang.addLine("hideCode \"" + code.getName() + "\" " + AnimalGenerator.makeOffsetTimingDef(delay));
    }

    public void addCodeElement(SourceCode code, String codeline, String name, int indentation, int row, Timing t) {
        String str = "addCodeElem \"" + codeline + "\" ";
        str = String.valueOf(str) + "to \"" + code.getName() + "\"";
        if (row > 0) {
            str = String.valueOf(str) + " row " + row;
        }
        if (indentation > 0) {
            str = String.valueOf(str) + " indentation " + indentation;
        }
        str = String.valueOf(str) + AnimalGenerator.makeOffsetTimingDef(t);
        this.lang.addLine(str);
    }

    public void addCodeLine(SourceCode code, String codeline, String name, int indentation, Timing t) {
        String str = "addCodeLine \"" + codeline + "\" ";
        str = String.valueOf(str) + "to \"" + code.getName() + "\"";
        if (indentation > 0) {
            str = String.valueOf(str) + " indentation " + indentation;
        }
        str = String.valueOf(str) + AnimalGenerator.makeOffsetTimingDef(t);
        this.lang.addLine(str);
    }
}

