/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.animalscript;

import animalscriptapi.animalscript.AnimalGenerator;
import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.primitives.Point;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.primitives.generators.PointGenerator;
import animalscriptapi.properties.PointProperties;
import java.awt.Color;

public class AnimalPointGenerator
extends AnimalGenerator
implements PointGenerator {
    private static int count = 1;

    public AnimalPointGenerator(Language aLang) {
        super(aLang);
    }

    public void create(Point aPoint) {
        String name = aPoint.getName();
        if (name == null || name == "" || this.isNameUsed(name)) {
            aPoint.setName("Point" + count);
            name = aPoint.getName();
            ++count;
        }
        this.lang.addItem(aPoint);
        StringBuilder def = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        def.append("point \"" + name + "\" " + AnimalGenerator.makeNodeDef(aPoint.getCoords()));
        PointProperties props = aPoint.getProperties();
        if (props.get("color") != null) {
            def.append(" color ");
            def.append(AnimalGenerator.makeColorDef(((Color)props.get("color")).getRed(), ((Color)props.get("color")).getGreen(), ((Color)props.get("color")).getBlue()));
        }
        if (props.get("depth") != null) {
            def.append(" depth " + ((Integer)props.get("depth")).toString());
        }
        def.append(AnimalGenerator.makeDisplayOptionsDef(aPoint.getDisplayOptions()));
        this.lang.addLine(def);
    }
}

