/*
 * Decompiled with CFR 0.152.
 */
package animal.misc;

import animal.animator.Animator;
import animal.animator.Show;
import animal.animator.TimedShow;
import animal.graphics.PTGraphicObject;
import animal.gui.AnimalMainWindow;
import animal.gui.DrawWindow;
import animal.gui.GraphicVectorEntry;
import animal.main.Animation;
import animal.main.AnimationState;
import animal.misc.AnimalTranslator;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -4525246143284609287L;
    private static final String[] columnNames = new String[]{AnimalTranslator.translateMessage("otmID"), AnimalTranslator.translateMessage("otmType"), AnimalTranslator.translateMessage("otmVisible"), AnimalTranslator.translateMessage("otmInfo")};
    private Object[][] data = null;
    private int step = -1;
    private Animation animation;
    private Hashtable<String, Boolean> currentlyVisible = new Hashtable(503);

    public void setAnimation(Animation anim) {
        this.animation = anim;
    }

    public void setStep(int stepNr) {
        if (this.step != stepNr) {
            this.step = stepNr;
            this.updateDataForStep();
        }
    }

    public void setObjects(Vector<PTGraphicObject> objects) {
        if (objects != null) {
            int nr = objects.size();
            if (this.data == null) {
                this.data = new Object[nr][columnNames.length];
            }
            PTGraphicObject ptgo = null;
            int pos = 0;
            while (pos < nr) {
                ptgo = objects.elementAt(pos);
                if (ptgo != null) {
                    int ptgoNum = ptgo.getNum(false);
                    this.data[pos][0] = String.valueOf(ptgoNum);
                    this.data[pos][1] = ptgo.getType();
                    this.data[pos][2] = Boolean.FALSE;
                    this.data[pos][3] = ptgo.toString();
                }
                ++pos;
            }
            this.updateDataForStep();
        }
    }

    public void updateDataForStep() {
        AnimationState stateNow = AnimalMainWindow.getWindowCoordinator().getDrawWindow(false).getAnimationState();
        GraphicVectorEntry[] gves = stateNow.getCurrentObjects().convertToArray();
        this.currentlyVisible.clear();
        int nr = gves.length;
        int pos = 0;
        while (pos < nr) {
            this.currentlyVisible.put(String.valueOf(gves[pos].go.getNum(false)), Boolean.TRUE);
            ++pos;
        }
        pos = 0;
        while (pos < this.data.length) {
            this.data[pos][2] = this.currentlyVisible.containsKey(this.data[pos][0]) ? Boolean.TRUE : Boolean.FALSE;
            ++pos;
        }
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.data == null || this.data.length < row || this.data[row].length < col) {
            return null;
        }
        return this.data[row][col];
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 2;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        int chosenID = -1;
        int targetIndex = 0;
        int[] animatorOIDs = null;
        Vector<Animator> helper = this.animation.getAnimatorsAtStep(this.step);
        Animator currentAnimator = null;
        boolean fittingAnimatorFound = false;
        int nrAnimatedObjects = 0;
        int i = 0;
        while (i < helper.size() && !fittingAnimatorFound) {
            currentAnimator = helper.elementAt(i);
            if (currentAnimator != null && (currentAnimator instanceof Show || currentAnimator instanceof TimedShow)) {
                try {
                    chosenID = Integer.parseInt((String)this.data[row][0]);
                }
                catch (NumberFormatException e) {
                    AnimalTranslator.translateMessage("currentAnimator", this.data[row][0]);
                }
                if (currentAnimator instanceof Show || currentAnimator instanceof TimedShow) {
                    animatorOIDs = currentAnimator.getObjectNums();
                    nrAnimatedObjects = animatorOIDs.length;
                    int j = 0;
                    while (j < animatorOIDs.length && !fittingAnimatorFound) {
                        boolean bl = fittingAnimatorFound = animatorOIDs[j] == chosenID;
                        if (fittingAnimatorFound) {
                            targetIndex = j;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (fittingAnimatorFound) {
            if (animatorOIDs.length == 1) {
                this.animation.deleteAnimator(currentAnimator);
            }
            int[] modifiedOIDs = new int[nrAnimatedObjects - 1];
            if (targetIndex > 0) {
                System.arraycopy(animatorOIDs, 0, modifiedOIDs, 0, targetIndex);
            }
            if (targetIndex != nrAnimatedObjects - 1) {
                System.arraycopy(animatorOIDs, targetIndex + 1, modifiedOIDs, targetIndex, nrAnimatedObjects - targetIndex - 1);
            }
            currentAnimator.setObjectNums(modifiedOIDs);
        } else {
            boolean showMode = (Boolean)value;
            TimedShow ts = new TimedShow(this.step, chosenID, 0, showMode ? "show" : "hide", showMode);
            this.animation.insertAnimator(ts);
        }
        DrawWindow drawWin = AnimalMainWindow.getWindowCoordinator().getDrawWindow(false);
        drawWin.setChanged();
        drawWin.writeBack();
        this.data[row][col] = value;
        this.fireTableCellUpdated(row, col);
    }
}

