/*
 * Decompiled with CFR 0.152.
 */
package animal.handler;

import animal.animator.Highlight;
import animal.animator.PutType;
import animal.animator.SwapType;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTStringArray;
import animal.handler.GraphicObjectHandler;
import animal.main.Animal;
import animal.misc.AnimalTranslator;
import animal.misc.MSMath;
import animal.misc.MessageDisplay;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringArrayHandler
extends GraphicObjectHandler {
    @Override
    public Vector<String> getMethods(PTGraphicObject ptgo, Object obj) {
        Vector<String> result = new Vector<String>(12, 2);
        if (obj instanceof Boolean) {
            result.addElement("show");
            result.addElement("hide");
        }
        if (obj instanceof Color) {
            result.addElement("bgColor");
            result.addElement("outlineColor");
            result.addElement("fontColor");
        }
        if (obj instanceof PutType) {
            result.addElement("put");
        }
        if (obj instanceof Point) {
            result.addElement("translate");
        }
        if (obj instanceof SwapType[]) {
            result.addElement("swap");
        }
        if (obj instanceof double[]) {
            result.addElement("highlight elements");
            result.addElement("highlight cells");
            result.addElement("unhighlight elements");
            result.addElement("unhighlight cells");
            result.addElement("deactivate cells");
            result.addElement("activate cells");
        }
        this.addExtensionMethodsFor(ptgo, obj, result);
        return result;
    }

    @Override
    public void propertyChange(PTGraphicObject ptgo, PropertyChangeEvent e) {
        PTStringArray array = null;
        if (ptgo instanceof PTStringArray) {
            array = (PTStringArray)ptgo;
            String what = e.getPropertyName();
            if (what.equalsIgnoreCase("bgColor")) {
                array.setBGColor((Color)e.getNewValue());
            } else if (what.equalsIgnoreCase("fontColor")) {
                array.setFontColor((Color)e.getNewValue());
            } else if (what.equalsIgnoreCase("outlineColor")) {
                array.setOutlineColor((Color)e.getNewValue());
            } else if (what.equalsIgnoreCase("translate")) {
                Point old = (Point)e.getOldValue();
                Point now = (Point)e.getNewValue();
                Point diff = MSMath.diff(now, old);
                array.translate(diff.x, diff.y);
            } else if (what.equalsIgnoreCase("put")) {
                PutType old = (PutType)e.getOldValue();
                PutType now = (PutType)e.getNewValue();
                array.turnIndicesOff();
                array.setHighlighted(now.idx, true);
                array.getEntry(now.idx).setFont(new Font(array.getFont().getName(), array.getFont().getStyle(), (int)((1.0 - now.part) * (double)array.getFont().getSize())));
                Point diff = MSMath.diff(now.positionOld, old.positionOld);
                array.translate(now.idx, diff.x, diff.y, true, false);
                now.newContent.setLocation(now.positionNew);
                int newWidth = Animal.getConcreteFontMetrics(array.getFont()).stringWidth(now.newContent.getText());
                int oldWidth = Animal.getConcreteFontMetrics(array.getFont()).stringWidth(array.getValue(now.idx));
                int dx = (int)(now.part * (double)(newWidth - oldWidth)) - (int)(old.part * (double)(newWidth - oldWidth));
                array.resizeCell(now.idx, dx, false);
                if (now.idx < array.length - 1) {
                    int x = now.idx + 1;
                    while (x < array.length) {
                        array.translate(x, dx, 0, true, true);
                        ++x;
                    }
                }
                if (now.hasFinished) {
                    if (array.put(now.idx, now.newContent) < 0) {
                        MessageDisplay.errorMsg(AnimalTranslator.translateMessage("invalidCallDuringPut"), 4, true);
                    }
                    array.setHighlighted(now.idx, false);
                }
            } else if (what.equalsIgnoreCase("swap")) {
                SwapType old = (SwapType)e.getOldValue();
                SwapType now = (SwapType)e.getNewValue();
                array.turnIndicesOff();
                int lower = now.getElements()[0];
                int upper = now.getElements()[1];
                int j = upper - lower - 1;
                array.setHighlighted(lower, true);
                array.setHighlighted(upper, true);
                int dx = now.p1.x - old.p1.x;
                int dy = now.p1.y - old.p1.y;
                array.translate(lower, dx, dy, true, false);
                dx = now.p2.x - old.p2.x;
                dy = now.p2.y - old.p2.y;
                array.translate(upper, dx, dy, true, false);
                dx = now.p3.x - old.p3.x;
                dy = now.p3.y - old.p3.y;
                if (j > 0) {
                    int[] cells = new int[j];
                    int i = 0;
                    while (i < j) {
                        cells[i] = lower + i + 1;
                        ++i;
                    }
                    array.translate(cells, dx, dy, true, true);
                }
                array.resizeCell(lower, dx, false);
                array.resizeCell(upper, dx, true);
                if (now.done) {
                    array.doSwap(lower, upper);
                    array.setHighlighted(lower, false);
                    array.setHighlighted(upper, false);
                }
            } else if (what.contains("highlight")) {
                double[] states = (double[])e.getNewValue();
                int i = 0;
                while (i < array.length) {
                    if (what.startsWith("un")) {
                        if (what.endsWith("elements")) {
                            if (states[i] >= 0.0 && array.isElemHighlighted(i)) {
                                array.getEntry(i).setColor(Highlight.fadeColor(array.getElemHighlightColor(), array.getFontColor(), states[i]));
                                if (states[i] >= 0.99) {
                                    array.setElemHighlighted(i, false);
                                }
                            }
                        } else if (what.endsWith("cells") && states[i] >= 0.0 && array.isHighlighted(i)) {
                            array.getCell(i).setFillColor(Highlight.fadeColor(array.getHighlightColor(), array.getBGColor(), states[i]));
                            if (states[i] >= 0.99) {
                                array.setHighlighted(i, false);
                            }
                        }
                    } else if (what.endsWith("elements")) {
                        if (states[i] >= 0.0 && !array.isElemHighlighted(i)) {
                            array.getEntry(i).setColor(Highlight.fadeColor(array.getFontColor(), array.getElemHighlightColor(), states[i]));
                            if (states[i] >= 0.99) {
                                array.setElemHighlighted(i, true);
                            }
                        }
                    } else if (what.endsWith("cells") && states[i] >= 0.0 && !array.isHighlighted(i)) {
                        array.getCell(i).setFillColor(Highlight.fadeColor(array.getBGColor(), array.getHighlightColor(), states[i]));
                        if (states[i] >= 0.99) {
                            array.setHighlighted(i, true);
                        }
                    }
                    ++i;
                }
            } else if (what.contains("activate")) {
                double[] states = (double[])e.getNewValue();
                int i = 0;
                while (i < array.length) {
                    if (states[i] >= 0.5) {
                        array.setActivated(i, !what.startsWith("de"));
                    }
                    ++i;
                }
            } else {
                super.propertyChange(ptgo, e);
            }
        }
    }
}

