/*
 * Decompiled with CFR 0.152.
 */
package animal.gui;

import animal.gui.AnimalMainWindow;
import animal.gui.DrawCanvas;
import animal.gui.DrawControlsToolbar;
import animal.gui.InternPanel;
import animal.gui.ObjectToolbar;
import animal.main.Animal;
import animal.main.AnimalFrame;
import animal.main.Animation;
import animal.main.AnimationState;
import animal.main.ObjectPanel;
import animal.misc.ObjectSelectionButton;
import animal.misc.XProperties;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class DrawWindow
extends AnimalFrame {
    private static final long serialVersionUID = -9218704082369265694L;
    private AnimationState animationState;
    private boolean changed;
    private JScrollPane sp;
    private DrawCanvas drawCanvas;
    private InternPanel internPanel;
    private ObjectPanel objectPanel;
    private JLabel statusLine;
    private DrawControlsToolbar controls;

    public DrawWindow(Animal animalInstance, XProperties properties) {
        super(animalInstance, properties);
    }

    public void init() {
        super.init();
        this.setTitle("Draw Window");
        this.statusLine = new JLabel();
        this.workContainer().add("South", this.statusLine);
        if (this.sp == null) {
            this.sp = new JScrollPane();
            this.sp.getViewport().add(this.getDrawCanvas());
        }
        this.workContainer().add("Center", this.sp);
        this.controls = new DrawControlsToolbar(this, this.getObjectPanel());
        this.workContainer().add("North", this.controls);
        this.workContainer().add("West", new ObjectToolbar(this));
        this.setAnimation(Animation.get());
        this.setProperties(this.props);
        this.getDrawCanvas().setGraphicEditor(null);
        this.getDrawCanvas().getUndoAdapter();
    }

    public void setVisible(boolean b) {
        if (b) {
            this.setStep(this.getStep());
            this.getDrawCanvas().curEditorSetVisible(true);
            this.getDrawCanvas().getObjects().setAllEditorsVisible();
        } else {
            this.getDrawCanvas().curEditorSetVisible(false);
            this.getDrawCanvas().getObjects().resetAllEditors();
        }
        super.setVisible(b);
    }

    Image getImage() {
        return this.drawCanvas.getImage();
    }

    public void validateScrollingPane(Dimension size) {
        this.sp.invalidate();
    }

    public void getProperties(XProperties properties) {
        Rectangle b = this.getBounds();
        if (b.width + 11 == properties.getIntProperty("drawWindow.width", 320) && b.height + 8 == properties.getIntProperty("drawWindow.height", 200)) {
            b.width += 11;
            b.height += 8;
        }
        this.props.put("drawWindow.x", b.x);
        this.props.put("drawWindow.y", b.y);
        this.props.put("drawWindow.width", b.width);
        this.props.put("drawWindow.height", b.height);
        if (this.drawCanvas != null) {
            this.drawCanvas.getProperties(properties);
        }
        if (this.objectPanel != null) {
            this.objectPanel.getProperties(properties);
        }
    }

    void setProperties(XProperties properties) {
        Rectangle r = new Rectangle(properties.getIntProperty("drawWindow.x", 50), properties.getIntProperty("drawWindow.y", 50), properties.getIntProperty("drawWindow.width", 400), properties.getIntProperty("drawWindow.height", 200));
        this.setBounds(r);
    }

    public void deselectAll() {
        this.getDrawCanvas().getObjects().deselectAll();
    }

    public AnimationState getAnimationState() {
        return this.animationState;
    }

    public DrawCanvas getDrawCanvas() {
        if (this.drawCanvas == null) {
            this.drawCanvas = new DrawCanvas(this, this.props);
        }
        return this.drawCanvas;
    }

    public DrawControlsToolbar getDrawControlsToolbar() {
        if (this.controls == null) {
            this.controls = new DrawControlsToolbar(this, this.getObjectPanel());
        }
        return this.controls;
    }

    InternPanel getInternPanel() {
        if (this.internPanel == null) {
            this.internPanel = new InternPanel(this);
        }
        return this.internPanel;
    }

    public ObjectPanel getObjectPanel() {
        if (this.objectPanel == null) {
            this.objectPanel = new ObjectPanel(this.animal, this, this.props, true);
        }
        return this.objectPanel;
    }

    public void installPrimitiveToolBar() {
        this.getObjectPanel().installEditors(Animal.get());
        this.repaint();
    }

    public int getStep() {
        return this.animationState.getStep();
    }

    public void setAnimation(Animation animation) {
        this.animationState = new AnimationState(animation);
        this.setStep(this.getStep());
    }

    public void setChanged() {
        this.changed = true;
    }

    public void setExternalSelection(ObjectSelectionButton osb) {
        this.getInternPanel().setExternalSelection(osb);
    }

    void setStatusLineText(String msg) {
        if (this.statusLine != null) {
            this.statusLine.setText(msg);
        }
    }

    public boolean setStep(int step) {
        if (this.isInitialized()) {
            if (this.animationState.getAnimation() == null) {
                return false;
            }
            step = this.animationState.getAnimation().verifyStep(step);
            if (step == 0) {
                step = this.animationState.getAnimation().getNextStep(step);
            }
            boolean stepChanged = step != this.getStep();
            this.writeBack();
            if (!this.animationState.setStep(step, false)) {
                return false;
            }
            this.internPanel.setStep(step);
            this.controls.setStep(step);
            this.drawCanvas.setObjects(this.animationState.getCurrentObjects());
            if (stepChanged) {
                this.drawCanvas.getUndoAdapter().reset();
                ObjectSelectionButton.deselectActiveButton();
                AnimalMainWindow.getWindowCoordinator().getAnimationOverview(false).setStep(step, false);
            }
        }
        return true;
    }

    public void update() {
        if (this.animationState != null) {
            this.setStep(this.getStep());
        }
    }

    public boolean writeBack() {
        if (this.drawCanvas != null && this.changed) {
            this.changed = false;
            this.drawCanvas.getUndoAdapter().reset();
            if (this.animationState.getAnimation() == null) {
                return false;
            }
            this.animationState.getAnimation().putObjectsAtStep(this.animationState.getStep(), this.drawCanvas.getObjects());
            AnimalMainWindow.getWindowCoordinator().getAnimationOverview(false).initList(true);
            this.update();
            return true;
        }
        return false;
    }
}

