/*
 * Decompiled with CFR 0.152.
 */
package animal.gui;

import animal.editor.AnimatorEditor;
import animal.editor.Editor;
import animal.editor.GraphicEditor;
import animal.exchange.animalscript.AnimatorExporter;
import animal.graphics.PTGraphicObject;
import animal.gui.AnimalUndoAdapter;
import animal.gui.DrawWindow;
import animal.gui.GraphicVector;
import animal.gui.GraphicVectorEntry;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.main.Animation;
import animal.misc.AnimalTranslator;
import animal.misc.EditableObject;
import animal.misc.MSMath;
import animal.misc.MessageDisplay;
import animal.misc.ObjectSelectionButton;
import animal.misc.ScalableGraphics;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class DrawCanvas
extends JPanel {
    private static final long serialVersionUID = 8193616156057204529L;
    private static final int MIN_AREA = 20;
    Image background;
    private static int drawButton = 16;
    static int finishButton = 8;
    static int cancelButton = 4;
    private ScalableGraphics sg = new ScalableGraphics();
    GraphicEditor curEditor;
    Point dragDiff;
    GraphicVector dragObjects = null;
    Point lastDragPos;
    DrawWindow drawWindow;
    private int grid = 0;
    private Color gridColor;
    boolean isPossible = false;
    private boolean isWarning;
    boolean multiSelection = false;
    int num = 0;
    private int[] explicitlyVisible = null;
    GraphicVector objects = new GraphicVector();
    ObjectSelectionButton objectSelectionButton;
    private int paintBackgroundCounter = 0;
    private int paintCount = 0;
    private boolean pointGrid = false;
    Image image;
    boolean selection = false;
    Rectangle selectionArea = null;
    Point selStart;
    private boolean snap;
    boolean useEditors = false;
    private Color backgroundColor = Color.white;
    Point dragStart;
    private AnimalUndoAdapter undoAdapter;

    public DrawCanvas(DrawWindow aDrawWindow, XProperties props) {
        this.drawWindow = aDrawWindow;
        this.addComponentListener(new DrawCanvasComponentListener());
        this.addMouseListener(new DrawCanvasMouseListener());
        this.addMouseMotionListener(new DrawCanvasMouseMotionListener());
        this.setProperties(props);
    }

    public void getProperties(XProperties props) {
        props.put("drawCanvas.Grid", this.grid);
        props.put("drawCanvas.pointGrid", this.pointGrid);
        props.put("drawCanvas.GridColor", this.gridColor);
        props.put("drawCanvas.BackgroundColor", this.backgroundColor);
        props.put("drawCanvas.Snap", this.snap);
    }

    private void setProperties(XProperties props) {
        this.setGrid(props.getIntProperty("drawCanvas.Grid", 0), props.getBoolProperty("drawCanvas.pointGrid"), props.getColorProperty("drawCanvas.GridColor", Color.black));
        this.setBackgroundColor(props.getColorProperty("drawCanvas.BackgroundColor", Color.white));
        this.setSnap(props.getBoolProperty("drawCanvas.Snap"));
    }

    void curEditorSetVisible(boolean b) {
        if (this.curEditor != null) {
            this.curEditor.setVisible(b);
        }
    }

    public void setGraphicEditor(GraphicEditor editor) {
        String msg;
        if (this.curEditor != null) {
            this.curEditor.setVisible(false);
            this.curEditor = null;
            this.repaintAll();
        }
        if (editor != null) {
            ObjectSelectionButton.deselectActiveButton();
            this.drawWindow.getDrawControlsToolbar().setSelection(false);
        } else if (this.objectSelectionButton == null && !this.selection) {
            this.drawWindow.getDrawControlsToolbar().setSelection(true, this.multiSelection, this.useEditors, null);
        }
        this.curEditor = editor;
        if (this.curEditor == null || (msg = this.curEditor.getStatusLineMsg()) == null) {
            this.setSelectionMessage();
        } else {
            this.drawWindow.setStatusLineText(msg);
        }
        if (this.drawWindow.isVisible() && this.curEditor != null) {
            this.curEditor.setVisible(true);
        }
        this.num = 0;
    }

    public GraphicEditor getGraphicEditor() {
        return this.curEditor;
    }

    void createGraphicObject() {
        if (this.curEditor != null) {
            this.curEditor.createObject();
        }
        this.num = 0;
        this.repaintAll();
    }

    public GraphicVector getObjects() {
        return this.objects;
    }

    public boolean isSnap() {
        return this.snap;
    }

    void setObjects(GraphicVector graphicObjects) {
        this.objects.resetAllEditors();
        this.objects = graphicObjects;
        this.objects.setSelectionMode(this.selection, this.multiSelection, this.useEditors);
        if (this.objectSelectionButton != null) {
            this.select(this.objectSelectionButton.getObjectNums(), true, true);
        }
        this.createGraphicObject();
    }

    void setShowTempObjects(boolean b) {
        this.objects.setShowTempObjects(b);
        this.repaintAll();
    }

    void setSnap(boolean b) {
        this.snap = b;
    }

    public void setBackgroundColor(Color c) {
        this.backgroundColor = c;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void paint(Graphics g) {
        this.sg.setGraphics(g);
        ++this.paintCount;
        if (this.image != null) {
            Graphics rg;
            Graphics usedGraphics = rg = this.image.getGraphics();
            if (this.sg.getMagnification() != 1.0) {
                this.sg.setGraphics(rg);
                usedGraphics = this.sg;
            }
            usedGraphics.drawImage(this.background, 0, 0, this);
            this.objects.drawSelected(usedGraphics);
            if (this.curEditor != null && this.curEditor.isVisible()) {
                this.curEditor.paintObject(usedGraphics);
            }
            if (this.explicitlyVisible != null) {
                GraphicVectorEntry[] entries = this.objects.convertToArray();
                int i = 0;
                while (i < this.explicitlyVisible.length) {
                    entries[this.explicitlyVisible[i]].go.paint(usedGraphics);
                    ++i;
                }
            }
            if (this.selectionArea != null) {
                usedGraphics.setColor(Color.gray);
                usedGraphics.drawRoundRect(this.selectionArea.x, this.selectionArea.y, this.selectionArea.width, this.selectionArea.height, 20, 20);
            }
            g.drawImage(this.image, 0, 0, this);
            usedGraphics.dispose();
        }
    }

    void paintBackground() {
        this.paintBackground(true);
    }

    private void paintBackground(boolean paintSelected) {
        ++this.paintBackgroundCounter;
        if (this.background != null) {
            Graphics g;
            Graphics usedGraphics = g = this.background.getGraphics();
            if (this.sg.getMagnification() != 1.0) {
                this.sg.setGraphics(g);
                usedGraphics = this.sg;
            }
            usedGraphics.setColor(this.backgroundColor);
            Dimension size = new Dimension(DrawCanvas.ensureLegalSize(this.getSize()));
            Animation animation = Animal.get().getAnimation();
            if (animation != null) {
                Dimension animationSize = animation.getSize();
                if (animationSize.width > size.width) {
                    size.width = animationSize.width;
                }
                if (animationSize.height > size.height) {
                    size.height = animationSize.height;
                }
            }
            size.width = (int)((double)size.width * this.sg.getMagnification());
            size.height = (int)((double)size.height * this.sg.getMagnification());
            this.drawWindow.validateScrollingPane(size);
            usedGraphics.fillRect(0, 0, size.width, size.height);
            this.drawGrid(g);
            if (paintSelected) {
                if (!this.selection) {
                    if (this.curEditor != null) {
                        this.objects.drawAllBut(usedGraphics, (PTGraphicObject)this.curEditor.getCurrentObject());
                    } else {
                        this.objects.drawAllBut(usedGraphics, (PTGraphicObject)null);
                    }
                } else if (this.dragObjects != null) {
                    this.objects.drawAllBut(usedGraphics, this.dragObjects);
                } else {
                    this.objects.drawAllBut(usedGraphics, (PTGraphicObject)null);
                }
            } else {
                this.objects.drawUnselected(usedGraphics);
            }
            g.dispose();
        }
    }

    public void repaintAll() {
        this.paintBackground();
        this.repaint();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    private int applyGrid(int a) {
        if (!this.snap || this.grid == 0) {
            return a;
        }
        return (a + this.grid / 2) / this.grid * this.grid;
    }

    Point applyGrid(Point p) {
        return new Point(this.applyGrid(p.x), this.applyGrid(p.y));
    }

    private void drawGrid(Graphics g) {
        block6: {
            if (this.grid <= 0) break block6;
            g.setColor(this.gridColor);
            if (!this.pointGrid) {
                int x = 0;
                while (x < this.getSize().width) {
                    g.drawLine(x, 0, x, this.getSize().height);
                    x += this.grid;
                }
                int y = 0;
                while (y < this.getSize().height) {
                    g.drawLine(0, y, this.getSize().width, y);
                    y += this.grid;
                }
            } else {
                int x = 0;
                while (x < this.getSize().width) {
                    int y = 0;
                    while (y < this.getSize().height) {
                        g.drawLine(x, y, x, y);
                        y += this.grid;
                    }
                    x += this.grid;
                }
            }
        }
    }

    public int getGrid() {
        return this.grid;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public boolean isPointGrid() {
        return this.pointGrid;
    }

    void setGrid(int theGrid, boolean thePointGrid, Color theGridColor) {
        this.grid = theGrid;
        this.pointGrid = thePointGrid;
        this.gridColor = theGridColor;
        this.createGraphicObject();
    }

    public void setGrid(int theGrid) {
        this.setGrid(theGrid, this.pointGrid, this.gridColor);
    }

    public void setGridColor(Color theGridColor) {
        this.setGrid(this.grid, this.pointGrid, theGridColor);
    }

    public void setPointGrid(boolean isAPointGrid) {
        this.setGrid(this.grid, isAPointGrid, this.gridColor);
    }

    public void setSelection(boolean aSelection, boolean isMultiSelection, boolean usesEditors, ObjectSelectionButton theObjectSelectionButton) {
        this.selection = aSelection;
        this.multiSelection = isMultiSelection;
        this.useEditors = usesEditors;
        this.objectSelectionButton = theObjectSelectionButton;
        this.objects.setSelectionMode(this.selection, this.multiSelection, this.useEditors);
        if (this.selection) {
            this.setGraphicEditor(null);
        }
        if (this.objectSelectionButton != null) {
            if (this.objectSelectionButton.getObjectNums() != null) {
                this.select(this.objectSelectionButton.getObjectNums(), true, true);
            } else {
                this.objects.deselectAll();
                this.repaintAll();
            }
        } else {
            this.repaintAll();
            ObjectSelectionButton.deselectActiveButton();
        }
        this.setSelectionMessage();
    }

    private void select(int[] nums, boolean doSelect, boolean isOSBInit) {
        if (doSelect) {
            this.objects.select(nums, isOSBInit);
        }
        this.paintBackground(false);
        this.repaint();
        if (this.objectSelectionButton != null) {
            this.objectSelectionButton.objectsSelected(this.drawWindow.getStep(), this.objects.getSelectedObjects());
        }
    }

    public void select(int nums, boolean doSelect) {
        this.select(new int[]{nums}, doSelect, false);
    }

    public void makeVisible(int[] nums) {
        this.explicitlyVisible = nums;
    }

    public void makeVisible(int targetNum) {
        this.makeVisible(new int[]{targetNum});
    }

    void select(Point p) {
        this.select(this.objects.select(p, 10), false);
    }

    void moveToFront() {
        this.objects.moveToFront();
        this.repaintAll();
    }

    void moveToBack() {
        this.objects.moveToBack();
        this.repaintAll();
    }

    void deleteSelected() {
        PTGraphicObject[] o = this.objects.deleteSelected();
        this.getUndoAdapter().delete(o);
        this.repaintAll();
    }

    void drag(Point p) {
        if (!this.selection) {
            if (this.num > 0 && this.curEditor != null) {
                p = this.applyGrid(p);
                this.isPossible = this.curEditor.nextPoint(this.num + 1, p);
                this.paint(this.getGraphics());
            }
        } else if (this.dragObjects != null) {
            boolean animatedExists = false;
            int a = 0;
            while (a < this.dragObjects.getSize()) {
                if (this.dragObjects.elementAt((int)a).mode == 3) {
                    animatedExists = true;
                    break;
                }
                ++a;
            }
            if (animatedExists) {
                if (!this.isWarning) {
                    this.dragObjects = null;
                    this.isWarning = true;
                    JOptionPane.showMessageDialog(this, AnimalTranslator.translateMessage("modified"), AnimalTranslator.translateMessage("noMod"), 1);
                    this.isWarning = false;
                }
            } else {
                if (this.num <= 0) {
                    Point d = MSMath.diff(p = this.applyGrid(MSMath.sum(p, this.dragDiff)), this.lastDragPos);
                    if (!d.equals(new Point(0, 0))) {
                        int a2 = 0;
                        while (a2 < this.dragObjects.getSize()) {
                            this.dragObjects.elementAt((int)a2).go.translate(d.x, d.y);
                            ++a2;
                        }
                    }
                } else {
                    p = this.applyGrid(p);
                    a = 0;
                    while (a < this.dragObjects.getSize()) {
                        ((GraphicEditor)this.dragObjects.elementAt((int)a).go.getEditor()).nextPoint(this.num, p);
                        ++a;
                    }
                }
                this.lastDragPos = p;
                this.repaint();
            }
        } else if (this.selStart != null) {
            this.selectionArea = this.getRectangle(this.selStart, p);
            this.repaint();
        }
    }

    Rectangle getRectangle(Point a, Point b) {
        int left = Math.min(a.x, b.x);
        int upper = Math.min(a.y, b.y);
        int right = Math.max(a.x, b.x);
        int lower = Math.max(a.y, b.y);
        Rectangle r = new Rectangle(left, upper, right - left, lower - upper);
        if (r.width < 20 && r.height < 20) {
            return null;
        }
        return r;
    }

    public static Dimension ensureLegalSize(Dimension size) {
        if (size.width < 1) {
            size.width = 1;
        }
        if (size.height < 1) {
            size.height = 1;
        }
        return size;
    }

    AnimalUndoAdapter getUndoAdapter() {
        if (this.undoAdapter == null) {
            this.undoAdapter = new AnimalUndoAdapter(this, this.drawWindow.getInternPanel());
        }
        return this.undoAdapter;
    }

    Image getImage() {
        return this.image;
    }

    void setSelectionMessage() {
        this.drawWindow.setStatusLineText(AnimalTranslator.translateMessage(this.multiSelection ? "selectObjects1" : "selectObjects2"));
    }

    public void cloneSelectedObjects() {
        int[] selected = this.objects.getSelectedObjects();
        PTGraphicObject[] newObjects = new PTGraphicObject[selected.length];
        int a = 0;
        while (a < selected.length) {
            PTGraphicObject go = (PTGraphicObject)this.objects.getGVEByNum((int)selected[a]).go.clone();
            go.translate(20, 20);
            go.resetNum();
            newObjects[a] = go;
            selected[a] = go.getNum(true);
            this.objects.addElement(go, 1);
            ++a;
        }
        this.getUndoAdapter().insert(newObjects);
        this.objects.deselectAll();
        this.objects.select(selected, true);
        this.repaintAll();
    }

    public void setMouseType(int newDrawButton, int newFinishButton, int newCancelButton) {
        drawButton = newDrawButton;
        finishButton = newFinishButton;
        cancelButton = newCancelButton;
    }

    public static String translateCancelButton() {
        return DrawCanvas.translateButton(cancelButton);
    }

    public static String translateDrawButton() {
        return DrawCanvas.translateButton(drawButton);
    }

    public static String translateFinishButton() {
        return DrawCanvas.translateButton(finishButton);
    }

    public static String translateButton(int button) {
        switch (button) {
            case 16: {
                return AnimalTranslator.translateMessage("leftMB");
            }
            case 8: {
                return AnimalTranslator.translateMessage("middleMB");
            }
            case 4: {
                return AnimalTranslator.translateMessage("rightMB");
            }
        }
        return String.valueOf(button);
    }

    double getMagnification() {
        return this.sg.getMagnification();
    }

    void setMagnification(double mag) {
        Graphics tmpGraphics = this.image.getGraphics();
        tmpGraphics.setColor(this.backgroundColor);
        tmpGraphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.sg.setMagnification(mag);
        this.repaintAll();
    }

    class DrawCanvasComponentListener
    extends ComponentAdapter {
        DrawCanvasComponentListener() {
        }

        public void componentResized(ComponentEvent e) {
            Dimension size = DrawCanvas.ensureLegalSize(DrawCanvas.this.getSize());
            DrawCanvas.this.background = DrawCanvas.this.createImage(size.width, size.height);
            DrawCanvas.this.image = DrawCanvas.this.createImage(size.width, size.height);
            DrawCanvas.this.paintBackground();
        }
    }

    class DrawCanvasMouseListener
    extends MouseAdapter
    implements ActionListener {
        JPopupMenu popup;
        JMenu animateMenu;
        JMenuItem cloneItem;
        JMenuItem editItem;
        JMenuItem showIDItem;
        JMenuItem showCodeItem;
        JMenuItem deleteItem;
        JMenuItem deselectItem;
        JMenuItem appendStepItem;
        JMenuItem prependStepItem;
        Hashtable<String, JMenuItem> animatorMenuItems = new Hashtable(23);

        JMenuItem generateItem(String label, int key, ActionListener listener, JComponent menu, boolean followedBySeparator) {
            JMenuItem menuItem = AnimalTranslator.getGUIBuilder().generateJMenuItem(label);
            menuItem.addActionListener(listener);
            if (menu instanceof JMenu || menu instanceof JPopupMenu) {
                menu.add(menuItem);
                if (followedBySeparator) {
                    menu.add(new JSeparator());
                }
            }
            return menuItem;
        }

        public DrawCanvasMouseListener() {
            this.popup = new JPopupMenu("Object Actions");
            this.editItem = this.generateItem("editItem", 69, this, this.popup, false);
            this.animateMenu = AnimalTranslator.getGUIBuilder().generateJMenu("animateMenu");
            this.popup.add(new JSeparator());
            JMenuItem dummy = null;
            Enumeration<String> e = Animal.get().getEditors().keys();
            int animatorNr = 0;
            while (e.hasMoreElements()) {
                String value = e.nextElement();
                if (value.equals("Show") || !(Animal.get().getEditor(value) instanceof AnimatorEditor)) continue;
                dummy = this.generateItem(value.toLowerCase(), animatorNr++, this, this.animateMenu, false);
                dummy.setActionCommand(value);
                this.animatorMenuItems.put(value, dummy);
            }
            this.popup.add(this.animateMenu);
            this.deselectItem = this.generateItem("deselect", 68, this, this.popup, true);
            this.cloneItem = this.generateItem("cloneItem", 67, this, this.popup, true);
            this.deleteItem = this.generateItem("deleteItem", 68, this, this.popup, true);
            this.showIDItem = this.generateItem("showID", 73, this, this.popup, false);
            this.showCodeItem = this.generateItem("animalScriptCode", 79, this, this.popup, true);
            this.prependStepItem = this.generateItem("prependStep", 80, this, this.popup, false);
            this.appendStepItem = this.generateItem("appendStep", 65, this, this.popup, false);
        }

        public void actionPerformed(ActionEvent evt) {
            int[] currentlySelected = DrawCanvas.this.getObjects().getSelectedObjects();
            Object source = evt.getSource();
            if (source == this.prependStepItem) {
                int prevStep = Animation.get().prependStep(DrawCanvas.this.drawWindow.getStep());
                if (prevStep != Integer.MAX_VALUE) {
                    DrawCanvas.this.drawWindow.setStep(prevStep);
                }
                return;
            }
            if (source == this.appendStepItem) {
                int nextStep = Animation.get().appendStep(DrawCanvas.this.drawWindow.getStep());
                if (nextStep != Integer.MAX_VALUE) {
                    DrawCanvas.this.drawWindow.setStep(nextStep);
                }
                return;
            }
            if (currentlySelected.length == 0) {
                return;
            }
            if (source == this.editItem) {
                DrawCanvas.this.getObjects().deselectAll();
                DrawCanvas.this.objects.setSelectionMode(DrawCanvas.this.selection, true, true);
                DrawCanvas.this.getObjects().select(currentlySelected, false);
                DrawCanvas.this.useEditors = false;
            } else if (this.animatorMenuItems.contains(source)) {
                Editor editor = Animal.get().getEditor(evt.getActionCommand());
                EditableObject a = editor.createObject();
                AnimatorEditor se = (AnimatorEditor)a.getSecondaryEditor();
                se.setProperties(AnimalConfiguration.getDefaultConfiguration().getProperties());
                se.objectSB.setObjectNums(currentlySelected);
                se.setVisible(true);
            } else if (source == this.deselectItem) {
                DrawCanvas.this.getObjects().deselectAll();
                DrawCanvas.this.repaintAll();
                if (DrawCanvas.this.selectionArea != null) {
                    DrawCanvas.this.selStart = null;
                    DrawCanvas.this.selectionArea = null;
                }
            } else if (source == this.cloneItem) {
                DrawCanvas.this.drawWindow.getDrawCanvas().cloneSelectedObjects();
            } else if (source == this.showIDItem) {
                int nrSelected = currentlySelected.length;
                StringBuilder sb = new StringBuilder(266);
                int i = 0;
                while (i < nrSelected) {
                    sb.append(AnimalTranslator.translateMessage("showID", new Object[]{DrawCanvas.this.getObjects().elementAt((int)i).go.getNum(false), DrawCanvas.this.getObjects().elementAt((int)i).go.toString()})).append("\n");
                    ++i;
                }
                MessageDisplay.message(sb.toString());
                JOptionPane.showMessageDialog(DrawCanvas.this.drawWindow, sb.toString());
            } else if (source == this.showCodeItem) {
                try {
                    int[] selectedIDs = DrawCanvas.this.getObjects().getSelectedObjects();
                    AnimatorExporter ex = new AnimatorExporter();
                    if (DrawCanvas.this.drawWindow != null) {
                        DrawCanvas.this.drawWindow.writeBack();
                    }
                    Vector<PTGraphicObject> ptgos = Animal.get().getAnimation().getGraphicObjects();
                    AnimatorExporter.setGraphicObjects(ptgos);
                    MessageDisplay.message("animalScriptCode", ex.exportUsedObjects(selectedIDs));
                }
                catch (Exception e) {
                    MessageDisplay.message("animalScriptCodeExc", e.getMessage());
                }
            } else if (source == this.deleteItem) {
                DrawCanvas.this.deleteSelected();
            }
        }

        public void mousePressed(MouseEvent evt) {
            double magFactor = DrawCanvas.this.getMagnification();
            Point clickedPoint = new Point((int)Math.round((double)evt.getX() / magFactor), (int)Math.round((double)evt.getY() / magFactor));
            this.checkForPopup(evt, clickedPoint);
            if (DrawCanvas.this.selection) {
                if (DrawCanvas.this.dragObjects == null) {
                    GraphicVectorEntry dragObject = DrawCanvas.this.objects.getObjectAtEditPoint(clickedPoint);
                    if (dragObject == null) {
                        DrawCanvas.this.select(clickedPoint);
                        if (DrawCanvas.this.multiSelection) {
                            DrawCanvas.this.selStart = clickedPoint;
                        }
                    } else {
                        dragObject.go.getEditor().linkToEditor(dragObject.go);
                        DrawCanvas.this.num = DrawCanvas.this.objects.getEditPointNum();
                        if (DrawCanvas.this.num > 0) {
                            DrawCanvas.this.dragObjects = new GraphicVector();
                            DrawCanvas.this.dragObjects.addElement(dragObject);
                        } else {
                            DrawCanvas.this.dragObjects = DrawCanvas.this.objects.getSelectedObjectsVector();
                        }
                        Point p = DrawCanvas.this.objects.getEditPointPos();
                        DrawCanvas.this.dragStart = new Point(p);
                        DrawCanvas.this.lastDragPos = DrawCanvas.this.applyGrid(p);
                        DrawCanvas.this.dragDiff = MSMath.diff(DrawCanvas.this.lastDragPos, p);
                        DrawCanvas.this.repaintAll();
                    }
                }
            } else if (DrawCanvas.this.curEditor != null) {
                boolean cancel;
                boolean finish = evt.getModifiers() == finishButton;
                boolean bl = cancel = evt.getModifiers() == cancelButton;
                if (cancel) {
                    DrawCanvas.this.num = 0;
                    DrawCanvas.this.createGraphicObject();
                    return;
                }
                if (DrawCanvas.this.num == 0) {
                    DrawCanvas.this.createGraphicObject();
                    DrawCanvas.this.isPossible = DrawCanvas.this.curEditor.nextPoint(DrawCanvas.this.num + 1, DrawCanvas.this.applyGrid(clickedPoint));
                }
                if (finish || DrawCanvas.this.isPossible && ++DrawCanvas.this.num == DrawCanvas.this.curEditor.pointsNeeded()) {
                    DrawCanvas.this.num = 0;
                    PTGraphicObject go = (PTGraphicObject)DrawCanvas.this.curEditor.getCurrentObject();
                    DrawCanvas.this.objects.addElement(go, 1);
                    DrawCanvas.this.getUndoAdapter().insert(go);
                    DrawCanvas.this.drawWindow.setChanged();
                }
                DrawCanvas.this.requestFocus();
            }
        }

        private void checkForPopup(MouseEvent evt, Point clickedPoint) {
            if (evt.isPopupTrigger() && DrawCanvas.this.selection) {
                this.popup.show(evt.getComponent(), clickedPoint.x, clickedPoint.y);
            }
        }

        public void mouseReleased(MouseEvent evt) {
            double magFactor = DrawCanvas.this.getMagnification();
            Point clickedPoint = new Point((int)Math.round((double)evt.getX() / magFactor), (int)Math.round((double)evt.getY() / magFactor));
            this.checkForPopup(evt, clickedPoint);
            if (DrawCanvas.this.dragObjects != null) {
                Point to = DrawCanvas.this.num > 0 ? DrawCanvas.this.lastDragPos : MSMath.diff(DrawCanvas.this.lastDragPos, DrawCanvas.this.dragDiff);
                int[] theObjects = new int[DrawCanvas.this.dragObjects.getSize()];
                int a = 0;
                while (a < DrawCanvas.this.dragObjects.getSize()) {
                    PTGraphicObject go = DrawCanvas.this.dragObjects.elementAt((int)a).go;
                    theObjects[a] = go.getNum(true);
                    if (go.getEditor().isPrimaryEditor()) {
                        go.getEditor().linkToEditor(null);
                    }
                    ++a;
                }
                DrawCanvas.this.getUndoAdapter().move(theObjects, DrawCanvas.this.num, DrawCanvas.this.dragStart, to);
                DrawCanvas.this.dragObjects = null;
                DrawCanvas.this.paintBackground();
                DrawCanvas.this.drawWindow.setChanged();
            } else if (DrawCanvas.this.selStart != null) {
                DrawCanvas.this.objects.selectArea(DrawCanvas.this.getRectangle(clickedPoint, DrawCanvas.this.selStart));
                int currentDWStep = DrawCanvas.this.drawWindow.getStep();
                if (DrawCanvas.this.objectSelectionButton != null) {
                    DrawCanvas.this.objectSelectionButton.objectsSelected(currentDWStep, DrawCanvas.this.objects.getSelectedObjects());
                }
                DrawCanvas.this.selStart = null;
                DrawCanvas.this.selectionArea = null;
                DrawCanvas.this.repaintAll();
            }
        }
    }

    class DrawCanvasMouseMotionListener
    extends MouseMotionAdapter {
        DrawCanvasMouseMotionListener() {
        }

        public void mouseMoved(MouseEvent evt) {
            DrawCanvas.this.drag(evt.getPoint());
        }

        public void mouseDragged(MouseEvent evt) {
            DrawCanvas.this.drag(evt.getPoint());
        }
    }
}

