/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.animator.MoveBase;
import animal.graphics.ArcBasedShape;
import animal.graphics.PTPoint;
import animal.main.AnimalConfiguration;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;

public class PTCircle
extends ArcBasedShape
implements PropertyChangeListener,
MoveBase {
    public static final String TYPE_LABEL = "Circle";
    public static final String CIRCLE_CENTER = "Circle.center";
    public static final String CIRCLE_COLOR = "Circle.color";
    public static final String CIRCLE_FILL_COLOR = "Circle.fillColor";
    public static final String CIRCLE_FILLED = "Circle.filled";
    public static final String CIRCLE_RADIUS = "Circle.radius";
    private Color color;
    private Color fillColor;
    private int radius;
    private Point center;
    private boolean isFilled;
    private static final long serialVersionUID = 4711724437159551059L;
    public static XProperties DefaultProperties;

    public int getFileVersion() {
        return 5;
    }

    public PTCircle() {
        this(DefaultProperties);
    }

    public PTCircle(XProperties props) {
        if (props == null) {
            PTCircle.initializeDefaultProperties(AnimalConfiguration.getDefaultConfiguration().getProperties());
            props = DefaultProperties;
        }
    }

    public void paint(Graphics g) {
        if (this.center == null) {
            return;
        }
        g.setColor(this.color);
        if (this.isFilled()) {
            g.setColor(this.fillColor);
            g.fillArc(this.center.x - this.radius, this.center.y - this.radius, this.radius * 2, this.radius * 2, 0, 360);
        }
        g.setColor(this.color);
        if (!this.color.equals(this.fillColor)) {
            g.drawArc(this.center.x - this.radius, this.center.y - this.radius, this.radius * 2, this.radius * 2, 0, 360);
        }
    }

    public void rotate(double angle) {
        PTPoint centerNode = new PTPoint(this.center);
        centerNode.rotate(angle);
        this.center = centerNode.toPoint();
    }

    public void rotate(double angle, PTPoint centerPoint) {
        this.translate(-centerPoint.getX(), -centerPoint.getY());
        this.rotate(angle);
        this.translate(centerPoint.getX(), centerPoint.getY());
    }

    public void translate(int x, int y) {
        this.center.translate(x, y);
    }

    public void useAsMoveBase() {
        this.setFilled(false);
    }

    public int getAngle(Point p) {
        int xdist = p.x - this.center.x;
        int ydist = p.y - this.center.y;
        if (this.radius == 0) {
            return -1;
        }
        int angle = (int)(MSMath.getAngle(this.center, new Point(this.center.x + xdist * 100 / this.radius, this.center.y + ydist * 100 / this.radius)) * 180.0 / Math.PI);
        if (angle < 0) {
            angle += 360;
        }
        return angle;
    }

    public Rectangle getBoundingBox() {
        return new Rectangle(this.center.x - this.radius, this.center.y - this.radius, this.radius * 2, this.radius * 2);
    }

    public Point getCenter() {
        if (this.center == null) {
            this.center = new Point(10, 10);
        }
        return this.center;
    }

    public Color getColor() {
        if (this.color == null) {
            this.color = DefaultProperties.getColorProperty(CIRCLE_COLOR);
        }
        return this.color;
    }

    public Color getFillColor() {
        if (this.fillColor == null) {
            this.fillColor = DefaultProperties.getColorProperty(CIRCLE_FILL_COLOR);
        }
        return this.fillColor;
    }

    public int getLength() {
        return 360;
    }

    public Point getPointAtLength(int alpha) {
        double x = (double)alpha * Math.PI / 180.0;
        return new Point((int)((double)this.center.x + (double)this.radius * Math.cos(x)), (int)((double)this.center.y - (double)this.radius * Math.sin(x)));
    }

    public int getRadius() {
        return this.radius;
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public static void initializeDefaultProperties(XProperties properties) {
        DefaultProperties = PTCircle.extractDefaultProperties(properties, "Arc");
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public void setCenter(Point centerNode) {
        this.center = centerNode;
    }

    public void setCenter(int x, int y) {
        this.center = new Point(x, y);
    }

    public void setColor(Color targetColor) {
        this.color = targetColor;
    }

    public void setFillColor(Color targetColor) {
        this.fillColor = targetColor;
    }

    public void setFilled(boolean filled) {
        this.isFilled = filled;
    }

    public void setRadius(int r) {
        this.radius = r;
    }

    public void discard() {
        this.fillColor = null;
        super.discard();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PTCircle ");
        if (this.getObjectName() != null) {
            sb.append("\"").append(this.getObjectName()).append("\" ");
        }
        sb.append("center= (");
        sb.append(this.center.x).append(", ").append(this.center.y).append("), radius=");
        sb.append(this.getRadius());
        return sb.toString();
    }
}

