/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.animator.Animator;
import animal.animator.TimedAnimator;
import animal.exchange.animalascii.AnimatorExporter;
import java.io.PrintWriter;

public class TimedAnimatorExporter
extends AnimatorExporter {
    public void exportTo(PrintWriter pw, Animator animator) {
        super.exportTo(pw, animator);
        TimedAnimator ta = (TimedAnimator)animator;
        int duration = ta.getDuration();
        int offset = ta.getOffset();
        boolean unitIsTicks = ta.isUnitIsTicks();
        pw.print(" by ");
        pw.print('\"');
        pw.print(ta.getMethod());
        pw.print('\"');
        if (offset != 0) {
            pw.print(" timed starting after ");
            pw.print(offset);
            pw.print(unitIsTicks ? " ticks" : " ms");
        }
        if (duration != 0) {
            pw.print(" within ");
            pw.print(duration);
            if (offset != 0 || duration != 0) {
                pw.print(unitIsTicks ? " ticks" : " ms");
            }
        }
    }
}

