/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.exchange.animalascii.PTGraphicObjectImporter;
import animal.graphics.PolygonalShape;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animalscript.core.AnimalParseSupport;
import java.io.IOException;
import java.io.StreamTokenizer;

public abstract class PolygonalShapeImporter
extends PTGraphicObjectImporter {
    public void parseStartingValuesFrom(StreamTokenizer stok, PolygonalShape shape, String key) {
        try {
            shape.setColor(ParseSupport.parseColor(stok, String.valueOf(key) + " color"));
            shape.setFilled(ParseSupport.parseOptionalWord(stok, String.valueOf(key) + " filled", "filled"));
            if (shape.isFilled()) {
                shape.setFillColor(ParseSupport.parseColor(stok, key, "fillColor"));
            }
            shape.setFirstNode(AnimalParseSupport.parseNodeInfo(stok, String.valueOf(key) + " node", null));
        }
        catch (IOException e) {
            MessageDisplay.errorMsg(e.getMessage(), 4);
        }
    }

    public void parseEndingValuesFrom(StreamTokenizer stok, PolygonalShape shape, String key) {
        try {
            ParseSupport.parseMandatoryWord(stok, String.valueOf(key) + " keyword 'depth'", "depth");
            shape.setDepth(ParseSupport.parseInt(stok, String.valueOf(key) + " depth"));
            if (ParseSupport.parseOptionalWord(stok, String.valueOf(key) + " keyword [name]", "name")) {
                shape.setObjectName(ParseSupport.parseText(stok, "Object name"));
            }
        }
        catch (IOException e) {
            MessageDisplay.errorMsg(e.getMessage(), 4);
        }
    }
}

