/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.exchange.animalascii.PTGraphicObjectExporter;
import animal.graphics.PolygonalShape;
import java.awt.Color;
import java.awt.Point;
import java.io.PrintWriter;

public abstract class PolygonalShapeExporter
extends PTGraphicObjectExporter {
    public void exportCommonStartAttributesTo(PrintWriter pw, PolygonalShape shape) {
        pw.print(shape.getFileVersion());
        pw.print(" object ");
        pw.print(shape.getNum(false));
        pw.print(" ");
        Color color = shape.getColor();
        pw.print(shape.getType());
        pw.print(" color (");
        pw.print(color.getRed());
        pw.print(",");
        pw.print(color.getGreen());
        pw.print(",");
        pw.print(color.getBlue());
        pw.print(") ");
        if (shape.isFilled()) {
            pw.print("filled ");
            color = shape.getFillColor();
            pw.print("fillColor (");
            pw.print(color.getRed());
            pw.print(",");
            pw.print(color.getGreen());
            pw.print(",");
            pw.print(color.getBlue());
            pw.print(") ");
        }
    }

    public void exportNode(PrintWriter pw, Point node) {
        pw.print("(");
        pw.print(node.x);
        pw.print(",");
        pw.print(node.y);
        pw.print(") ");
    }

    public void exportCommonEndAttributesTo(PrintWriter pw, PolygonalShape shape) {
        pw.print(" depth ");
        pw.print(shape.getDepth());
        if (shape.getObjectName() != null) {
            pw.print(" name \"");
            pw.print(shape.getObjectName());
            pw.println("\"");
        }
    }
}

