/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.exchange.animalascii.PTGraphicObjectImporter;
import animal.graphics.PTText;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animal.misc.XProperties;
import animalscript.core.AnimalParseSupport;
import java.io.IOException;
import java.io.StreamTokenizer;

public class PTTextImporter
extends PTGraphicObjectImporter {
    public Object importFrom(int version, StreamTokenizer stok) {
        XProperties properties = new XProperties();
        try {
            PTText dummy = new PTText();
            if (version > dummy.getFileVersion()) {
                ParseSupport.formatException2("fileVersionMismatch", new Object[]{String.valueOf(version), String.valueOf(dummy.getFileVersion()), stok.toString()});
            }
            dummy = null;
            ParseSupport.parseMandatoryWord(stok, "Text Coord 'at'", "at");
            properties.put("node", ParseSupport.parseNode(stok, "Text coordinates"));
            properties.put("Text.color", ParseSupport.parseColor(stok, "Text Color"));
            ParseSupport.parseMandatoryWord(stok, "fontname 'font'", "font");
            properties.put("Text.fontName", ParseSupport.parseWord(stok, "fontname"));
            ParseSupport.parseMandatoryWord(stok, "fontstyle 'style'", "style");
            properties.put("Text.fontStyle", ParseSupport.parseInt(stok, "fontstyle"));
            ParseSupport.parseMandatoryWord(stok, "fontsize 'size'", "size");
            properties.put("Text.fontSize", ParseSupport.parseInt(stok, "fontsize"));
            ParseSupport.parseMandatoryWord(stok, "text 'text'", "text");
            ParseSupport.parseMandatoryChar(stok, "text ':'", ':');
            properties.put("Text.text", AnimalParseSupport.parseText(stok, "Text text"));
            if (version >= 2) {
                ParseSupport.parseMandatoryWord(stok, "Text keyword 'depth'", "depth");
                properties.put("Text.depth", ParseSupport.parseInt(stok, "Text depth"));
            }
        }
        catch (IOException e) {
            MessageDisplay.errorMsg(e.getMessage(), 4);
        }
        return new PTText(properties);
    }
}

