/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.exchange.animalascii.PTGraphicObjectImporter;
import animal.graphics.PTBoxPointer;
import animal.graphics.PTPolyline;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animal.misc.XProperties;
import animalscript.core.AnimalParseSupport;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.io.IOException;
import java.io.StreamTokenizer;

public class PTBoxPointerImporter
extends PTGraphicObjectImporter {
    public Object importFrom(int version, StreamTokenizer stok) {
        XProperties properties = new XProperties();
        PTPolyline textBox = null;
        try {
            PTBoxPointer dummy = new PTBoxPointer();
            if (version > dummy.getFileVersion()) {
                ParseSupport.formatException2("fileVersionMismatch", new Object[]{String.valueOf(version), String.valueOf(dummy.getFileVersion()), stok.toString()});
            }
            dummy = null;
            properties.put("BoxPointer.color", ParseSupport.parseColor(stok, "BoxPointer"));
            properties.put("BoxPointer.fillColor", ParseSupport.parseColor(stok, "BoxPointer fill", "fillColor"));
            if (version >= 5) {
                properties.put("BoxPointer.pointerAreaColor", ParseSupport.parseColor(stok, "Pointer area color", "pointerAreaColor"));
            }
            properties.put("BoxPointer.pointerAreaFillColor", ParseSupport.parseColor(stok, "BoxPointer area fill", "pointerFillColor"));
            ParseSupport.parseMandatoryWord(stok, "BoxPointer keyword 'textBox'", "textBox");
            textBox = AnimalParseSupport.parsePolyline(stok, "BoxPointer text box");
            properties.put("BoxPointer.location", textBox.getNode(0).toPoint());
            ParseSupport.parseMandatoryWord(stok, "pointerArea of BoxPointer expected", "pointerArea");
            AnimalParseSupport.parsePolyline(stok, "BoxPointer pointer area");
            ParseSupport.parseMandatoryWord(stok, "BoxPtr keyword 'pointerPosition'", "pointerPosition");
            properties.put("BoxPointer.pointerPosition", ParseSupport.parseInt(stok, "BoxPtr pointer position", 0, 4));
            ParseSupport.parseMandatoryWord(stok, "BoxPtr keyword 'pointers'", "pointers");
            ParseSupport.parseMandatoryChar(stok, "BoxPointer pointers open brace", '{');
            int nrPointers = 0;
            while (!ParseSupport.parseOptionalChar(stok, "BoxPointer pointers close brace", '}')) {
                PTPolyline polyline = AnimalParseSupport.parsePolyline(stok, "BoxPointer pointer area");
                if (polyline == null) continue;
                Point node0 = polyline.getNode(0).toPoint();
                Point node1 = polyline.getNode(1).toPoint();
                node1.translate(-node0.x, -node0.y);
                properties.put("BoxPointer.tipPosition_" + nrPointers, node1);
                ++nrPointers;
            }
            properties.put("BoxPointer.nrPointers", nrPointers);
            ParseSupport.parseMandatoryWord(stok, "BoxPtr keyword text", "text");
            ParseSupport.parseMandatoryChar(stok, "BoxPtr keyword text ':'", ':');
            properties.put("BoxPointer.text", AnimalParseSupport.parseText(stok, "BoxPtr text component"));
            if (version >= 4) {
                properties.put("BoxPointer.textColor", ParseSupport.parseColor(stok, "BoxPtr text color", "textColor"));
            } else {
                properties.put("BoxPointer.textColor", properties.getColorProperty("BoxPointer.color", Color.black));
            }
            if (version >= 5) {
                ParseSupport.parseMandatoryWord(stok, "BoxPtr keyword 'Font'", "Font");
                ParseSupport.parseMandatoryChar(stok, "BoxPtr keyword text '{'", '{');
                String fn = AnimalParseSupport.parseText(stok, "BoxPtr FontName");
                properties.put("BoxPointer.fontName", fn);
                int fontStyle = ParseSupport.parseInt(stok, "BoxPtr textStyle");
                properties.put("BoxPointer.fontStyle", fontStyle);
                int fontSize = ParseSupport.parseInt(stok, "BoxPtr textSize");
                properties.put("BoxPointer.fontSize", fontSize);
                properties.put("BoxPointer.font", new Font(fn, fontStyle, fontSize));
                ParseSupport.parseMandatoryChar(stok, "BoxPtr keyword text '}'", '}');
                ParseSupport.parseMandatoryWord(stok, "BoxPtr keyword 'depth'", "depth");
                properties.put("BoxPointer.depth", ParseSupport.parseInt(stok, "BoxPtr depth"));
            }
        }
        catch (IOException e) {
            MessageDisplay.errorMsg(e.getMessage(), 4);
        }
        PTBoxPointer ptbp = new PTBoxPointer(properties);
        return ptbp;
    }
}

