/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.exchange.animalascii.PTGraphicObjectExporter;
import animal.graphics.PTBoxPointer;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.graphics.PTPolyline;
import animal.graphics.PTText;
import java.awt.Color;
import java.awt.Font;
import java.io.PrintWriter;

public class PTBoxPointerExporter
extends PTGraphicObjectExporter {
    public void exportTo(PrintWriter pw, PTGraphicObject ptgo) {
        PTBoxPointer boxPointer = (PTBoxPointer)ptgo;
        PTPoint node = null;
        PTPolyline tmpPointer = null;
        pw.print(boxPointer.getFileVersion());
        pw.print(" object ");
        pw.print(boxPointer.getNum(false));
        Color color = boxPointer.getColor();
        pw.print(" BoxPointer color (");
        pw.print(color.getRed());
        pw.print(",");
        pw.print(color.getGreen());
        pw.print(",");
        pw.print(color.getBlue());
        pw.print(") fillColor (");
        color = boxPointer.getBoxFillColor();
        pw.print(color.getRed());
        pw.print(",");
        pw.print(color.getGreen());
        pw.print(",");
        pw.print(color.getBlue());
        pw.print(") pointerAreaColor (");
        color = boxPointer.getPointerAreaColor();
        pw.print(color.getRed());
        pw.print(",");
        pw.print(color.getGreen());
        pw.print(",");
        pw.print(color.getBlue());
        pw.print(") pointerFillColor (");
        color = boxPointer.getPointerAreaFillColor();
        pw.print(color.getRed());
        pw.print(",");
        pw.print(color.getGreen());
        pw.print(",");
        pw.print(color.getBlue());
        pw.print(") textBox { ");
        tmpPointer = boxPointer.getBox();
        int n = tmpPointer.getNodeCount() - 1;
        int i = 0;
        while (i < n) {
            node = tmpPointer.getNode(i);
            pw.print(" (");
            pw.print(node.getX());
            pw.print(",");
            pw.print(node.getY());
            pw.print(")");
            ++i;
        }
        pw.print(" } pointerArea {");
        tmpPointer = boxPointer.getPointerArea();
        n = tmpPointer.getNodeCount() - 1;
        i = 0;
        while (i < n) {
            node = tmpPointer.getNode(i);
            pw.print(" (");
            pw.print(node.getX());
            pw.print(",");
            pw.print(node.getY());
            pw.print(")");
            ++i;
        }
        pw.print("} pointerPosition ");
        pw.print(boxPointer.getPointerPosition());
        pw.print(" pointers {");
        PTPolyline[] pointers = boxPointer.getPointers();
        if (pointers != null) {
            n = pointers.length;
            i = 0;
            while (i < n) {
                tmpPointer = pointers[i];
                int m = tmpPointer.getNodeCount();
                pw.print(" { ");
                int j = 0;
                while (j < m) {
                    node = tmpPointer.getNode(j);
                    pw.print("(");
                    pw.print(node.getX());
                    pw.print(", ");
                    pw.print(node.getY());
                    pw.print(") ");
                    ++j;
                }
                pw.print("}");
                ++i;
            }
        }
        pw.print(" } text: \"");
        pw.print(PTText.escapeText(boxPointer.getText()));
        color = boxPointer.getTextColor();
        pw.print("\" textColor (");
        pw.print(color.getRed());
        pw.print(",");
        pw.print(color.getGreen());
        pw.print(",");
        pw.print(color.getBlue());
        pw.print(")");
        Font font = boxPointer.getFont();
        pw.print(" Font {\"");
        pw.print(font.getName());
        pw.print("\" ");
        pw.print(font.getStyle());
        pw.print(" ");
        pw.print(font.getSize());
        pw.print(" }");
        pw.print(" depth ");
        pw.println(boxPointer.getDepth());
    }
}

