/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.exchange.animalascii.PTGraphicObjectImporter;
import animal.graphics.PTArc;
import animal.misc.AnimalTranslator;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animal.misc.XProperties;
import animalscript.core.AnimalParseSupport;
import java.io.IOException;
import java.io.StreamTokenizer;

public class PTArcImporter
extends PTGraphicObjectImporter {
    public Object importFrom(int version, StreamTokenizer stok) {
        XProperties properties = new XProperties();
        try {
            PTArc dummy = new PTArc();
            if (version > dummy.getFileVersion()) {
                ParseSupport.formatException2("fileVersionMismatch", new Object[]{String.valueOf(version), String.valueOf(dummy.getFileVersion()), stok.toString()});
            }
            dummy = null;
            ParseSupport.parseMandatoryWord(stok, AnimalTranslator.translateMessage("arcCenter"), "center");
            properties.put("Arc.center", ParseSupport.parseNode(stok, AnimalTranslator.translateMessage("arcCenter")));
            ParseSupport.parseMandatoryWord(stok, "Arc radius X keyword 'rX'", "rX");
            int x = ParseSupport.parseInt(stok, "Arc x radius");
            ParseSupport.parseMandatoryWord(stok, "Arc radius Y keyword 'rY'", "rY");
            int y = ParseSupport.parseInt(stok, "Arc y radius");
            properties.put("Arc.radius", String.valueOf(x) + " " + y);
            properties.put("Arc.color", ParseSupport.parseColor(stok, "Arc"));
            if (version >= 5 && ParseSupport.parseOptionalWord(stok, "Arc fillColor", "fillColor")) {
                stok.pushBack();
                properties.put("Arc.fillColor", ParseSupport.parseColor(stok, "Arc fillColor", "fillColor"));
            }
            ParseSupport.parseMandatoryWord(stok, "Arc keyword 'angle'", "angle");
            properties.put("Arc.arcAngle", ParseSupport.parseInt(stok, "Arc angle value"));
            ParseSupport.parseMandatoryWord(stok, "Arc keyword 'starts'", "starts");
            properties.put("Arc.startAngle", ParseSupport.parseInt(stok, "Arc angle start"));
            properties.put("Arc.filled", ParseSupport.parseOptionalWord(stok, "Arc filled", "filled"));
            properties.put("Arc.circle", ParseSupport.parseOptionalWord(stok, "Arc circle", "circle"));
            properties.put("Arc.clockwise", ParseSupport.parseOptionalWord(stok, "Arc clockwise", "clockwise"));
            properties.put("Arc.fwArrow", ParseSupport.parseOptionalWord(stok, "Arc fwArrow", "fwArrow"));
            properties.put("Arc.bwArrow", ParseSupport.parseOptionalWord(stok, "Arc bwArrow", "bwArrow"));
            properties.put("Arc.closed", ParseSupport.parseOptionalWord(stok, "Arc closed", "closed"));
            ParseSupport.parseMandatoryWord(stok, "Arc keyword 'text'", "text");
            ParseSupport.parseMandatoryChar(stok, "Arc keyword text ':'", ':');
            properties.put("Arc.text", AnimalParseSupport.parseText(stok, "Arc text component"));
            properties.put("Arc.textColor", ParseSupport.parseColor(stok, "Arc textColor", "textColor"));
            if (version >= 5 && ParseSupport.parseOptionalWord(stok, "Arc Font into", "Font")) {
                stok.pushBack();
                ParseSupport.parseMandatoryWord(stok, "Arc keyword 'Font'", "Font");
                ParseSupport.parseMandatoryChar(stok, "Arc keyword text '{'", '{');
                properties.put("Text.fontName", AnimalParseSupport.parseText(stok, "Arc FontName"));
                properties.put("Text.fontStyle", ParseSupport.parseInt(stok, "Arc textStyle"));
                properties.put("Text.fontSize", ParseSupport.parseInt(stok, "Arc textSize"));
                ParseSupport.parseMandatoryChar(stok, "Arc keyword text '}'", '}');
            }
            if (version >= 4 && ParseSupport.parseOptionalWord(stok, "Arc Depth into", "depth")) {
                stok.pushBack();
                ParseSupport.parseMandatoryWord(stok, "Arc keyword 'depth'", "depth");
                properties.put("Arc.depth", ParseSupport.parseInt(stok, "Arc depth"));
            }
        }
        catch (IOException e) {
            MessageDisplay.errorMsg(e.getMessage(), 4);
        }
        return new PTArc(properties);
    }
}

