/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.exchange.animalascii.Importer;
import animal.main.Link;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animal.misc.XProperties;
import animalscript.core.AnimalParseSupport;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.io.StreamTokenizer;

public class LinkImporter
implements Importer {
    public Object importFrom(int version, StreamTokenizer stok) {
        XProperties props = new XProperties();
        try {
            if (version > Link.getFileVersion()) {
                throw new StreamCorruptedException("Link version is " + version + ", but class Link only supports versions <=" + Link.getFileVersion());
            }
            if (!ParseSupport.parseOptionalWord(stok, "Link keyword 'end'", "END")) {
                props.put("Link.step", ParseSupport.parseInt(stok, "Link number"));
                ParseSupport.parseMandatoryWord(stok, "Link keyword 'next'", "next");
                ParseSupport.parseMandatoryWord(stok, "Link keyword 'step'", "step");
                props.put("Link.nextStep", ParseSupport.parseInt(stok, "Link next link #"));
                ParseSupport.parseMandatoryWord(stok, "Link keyword 'after'", "after");
                if (ParseSupport.parseOptionalWord(stok, "Link keyword 'time'", "time")) {
                    props.put("Link.mode", 2);
                    props.put("Link.time", ParseSupport.parseInt(stok, "Link timed wait period"));
                    ParseSupport.parseMandatoryWord(stok, "Link timed wait keyword 'ms'", "ms");
                } else if (ParseSupport.parseOptionalWord(stok, "Link keyword 'key'", "key")) {
                    props.put("Link.mode", 1);
                    ParseSupport.parseMandatoryWord(stok, "Link keyword 'press'", "press");
                } else if (ParseSupport.parseOptionalWord(stok, "Link keyword 'click'", "click")) {
                    props.put("Link.mode", 4);
                    ParseSupport.parseMandatoryWord(stok, "Link keyword 'on'", "on");
                    ParseSupport.parseMandatoryWord(stok, "Link keyword 'ID'", "id");
                    props.put("Link.clickTargetID", ParseSupport.parseInt(stok, "Link target ID"));
                } else {
                    ParseSupport.formatException("Link effect unknown: only time/key", stok);
                }
            } else {
                props.put("Link.step", Integer.MAX_VALUE);
                props.put("Link.nextStep", Integer.MAX_VALUE);
            }
            if (ParseSupport.parseOptionalWord(stok, "Link keyword 'label'", "label")) {
                props.put("Link.label", AnimalParseSupport.parseText(stok, "Link label"));
            }
        }
        catch (IOException e) {
            MessageDisplay.errorMsg("ZZZ" + e.getMessage(), 4);
        }
        return new Link(props);
    }
}

