/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange;

import animal.exchange.AnimationExporter;
import animal.exchange.animalscript.AnimatorExporter;
import animal.exchange.animalscript.Exporter;
import animal.exchange.animalscript.LinkExporter;
import animal.graphics.PTGraphicObject;
import animal.main.Animal;
import animal.main.AnimationListEntry;
import animal.misc.AnimalTranslator;
import animal.misc.MessageDisplay;
import java.awt.Rectangle;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;

public class AnimalScriptExporter
extends AnimationExporter {
    protected Animal animal;
    private String extension = null;
    private boolean isCompressed = true;

    public boolean exportAnimationTo(String fileName) {
        FilterOutputStream oStream = null;
        this.filename = fileName;
        String fileExtension = this.getDefaultExtension();
        if (!this.filename.endsWith(fileExtension)) {
            this.filename = String.valueOf(this.filename) + "." + fileExtension;
        }
        try {
            oStream = new BufferedOutputStream(new FileOutputStream(this.filename));
            if (this.isCompressed) {
                oStream = new GZIPOutputStream(oStream);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            MessageDisplay.errorMsg(fileNotFoundException.getMessage(), 4);
        }
        catch (IOException ioException) {
            MessageDisplay.errorMsg(ioException.getMessage(), 4);
        }
        if (oStream == null) {
            return false;
        }
        return this.exportAnimationTo(oStream);
    }

    public boolean exportAnimationTo(OutputStream oStream) {
        if (this.animal == null) {
            this.animal = Animal.get();
            this.animal.getEditors();
        }
        Hashtable<String, AnimatorExporter> animalScriptExporters = new Hashtable<String, AnimatorExporter>(73);
        StringBuilder exportErrors = new StringBuilder();
        PrintWriter writer = new PrintWriter(oStream);
        writer.print("%Animal 2");
        Rectangle animationBBox = this.animationToExport.determineVisualizationSize();
        if (!animationBBox.equals(new Rectangle(0, 0, 0, 0))) {
            writer.print(String.valueOf(animationBBox.width) + "*" + animationBBox.height);
        }
        animationBBox = null;
        writer.print("\n");
        AnimationListEntry[] localinfo = this.animationToExport.getAnimatorList();
        String subName = null;
        String className = null;
        localinfo = this.animationToExport.getAnimatorList();
        Vector<PTGraphicObject> allGraphicObjects = this.animationToExport.getGraphicObjects();
        AnimatorExporter.setGraphicObjects(allGraphicObjects);
        if (localinfo != null) {
            int i = 0;
            while (i < localinfo.length) {
                AnimationListEntry ali = localinfo[i];
                try {
                    className = ali.mode == 1 ? ali.animator.getClass().getName() : ali.link.getClass().getName();
                    if (!animalScriptExporters.containsKey(className)) {
                        StringBuilder handlerName = new StringBuilder("animal.exchange.animalscript.");
                        handlerName.append(className.substring(className.lastIndexOf(46) + 1));
                        handlerName.append("Exporter");
                        subName = handlerName.toString();
                        Class<?> c = Class.forName(subName);
                        Exporter handler = null;
                        handler = ali.mode == 1 ? (AnimatorExporter)c.newInstance() : (LinkExporter)c.newInstance();
                        animalScriptExporters.put(className, (AnimatorExporter)handler);
                    }
                    String exportString = null;
                    if (ali.mode == 1) {
                        writer.print("  ");
                        exportString = ((AnimatorExporter)animalScriptExporters.get(className)).getExportString(ali.animator);
                    } else {
                        exportString = ((LinkExporter)animalScriptExporters.get(className)).getExportString(ali.link);
                    }
                    if (exportString != null) {
                        writer.println(exportString);
                    }
                }
                catch (Exception e) {
                    exportErrors.append("\n").append(AnimalTranslator.translateMessage("exportException", new String[]{className, className, e.getMessage()}));
                }
                ++i;
            }
        }
        localinfo = null;
        writer.close();
        MessageDisplay.message("exportStatusLog", new String[]{exportErrors.toString()});
        exportErrors = null;
        return true;
    }

    public String getDefaultExtension() {
        return this.isCompressed ? "asc" : "asu";
    }

    public String getFormatDescription() {
        return AnimalTranslator.translateMessage(this.isCompressed ? "animalScriptFormatGzip" : "animalScriptFormat");
    }

    public String getMIMEType() {
        if (this.isCompressed) {
            return "animation/animal-ascii-compressed";
        }
        return "animation/animal-ascii";
    }

    public void init(String format) {
        super.init(format);
        this.extension = format.substring(format.indexOf(47) + 1);
        this.isCompressed = this.extension.endsWith("compressed");
        this.exportCapabilities = 7;
    }

    public String toString() {
        return AnimalTranslator.translateMessage("animalScriptExportDescription");
    }
}

