/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.properties;

import animal.editor.properties.PropertyEditor;
import animal.main.PropertiedObject;
import animal.misc.AnimalTranslator;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class IntPropertyEditor
extends PropertyEditor
implements ActionListener {
    JTextField textField;

    public IntPropertyEditor(String type, XProperties properties) {
        super(type, properties);
    }

    public void addEditorTo(Container container) {
        String label = this.getProperties().getProperty("param0");
        PropertiedObject ptgo = this.target;
        int defaultValue = Integer.valueOf(this.getProperties().getProperty("param2"));
        int value = ptgo.getProperties().getIntProperty(this.getProperties().getProperty("property"), defaultValue);
        JLabel myLabel = new JLabel(label, 2);
        this.textField = new JTextField(String.valueOf(value), 8);
        this.textField.addActionListener(this);
        container.add(myLabel);
        container.add(this.textField);
    }

    public void storeProperty() {
        int value = Integer.MIN_VALUE;
        try {
            value = Integer.parseInt(this.textField.getText());
            PropertiedObject targetObject = this.getTargetObject();
            String propertyToChange = this.getProperties().getProperty("property");
            targetObject.getProperties().put(propertyToChange, value);
        }
        catch (NumberFormatException numberFormatException) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("invalidNumberInput", new String[]{this.textField.getText()}), 2);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        PropertiedObject targetObject = this.getTargetObject();
        if (targetObject != null && targetObject.getProperties() != null) {
            this.storeProperty();
        } else {
            MessageDisplay.errorMsg("objectNull", new Object[]{this.getClass()});
        }
    }
}

