/*
 * Decompiled with CFR 0.152.
 */
package animal.editor;

import animal.editor.AbstractTextEditor;
import animal.editor.Editor;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTText;
import animal.gui.DrawCanvas;
import animal.main.Animation;
import animal.misc.AnimalTranslator;
import animal.misc.ColorChooserAction;
import animal.misc.EditPoint;
import animal.misc.EditableObject;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import translator.TranslatableGUIElement;

public class TextEditor
extends AbstractTextEditor
implements PropertyChangeListener {
    private static final long serialVersionUID = -1180513717753983571L;
    private ColorChooserAction colorChooser;
    private boolean isItalic;
    private boolean isBold;

    public TextEditor() {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        this.addBox(this.generateTextOperationsBox(generator, "textBL"));
        this.addBox(this.generateFontAndStyleBox(generator, "fontBL"));
        Box colorBox = generator.generateBorderedBox(2, "colorBL");
        Color initialColor = this.getCurrentObject(false) == null ? Color.black : ((PTText)this.getCurrentObject(false)).getColor();
        this.colorChooser = this.generateAndAddColorChoiceEntry(colorBox, generator, initialColor, 67);
        this.addBox(colorBox);
        this.finishBoxes();
    }

    public int pointsNeeded() {
        return 2;
    }

    public boolean nextPoint(int num, Point p) {
        PTText t = (PTText)this.getCurrentObject();
        switch (num) {
            case 1: 
            case 2: {
                t.setLocation(p);
            }
        }
        return true;
    }

    public int getMinDist(PTGraphicObject go, Point p) {
        return MSMath.dist(p, go.getBoundingBox());
    }

    public EditPoint[] getEditPoints(PTGraphicObject go) {
        PTText t = (PTText)go;
        Rectangle r = t.getBoundingBox();
        return new EditPoint[]{new EditPoint(-1, t.getLocation()), new EditPoint(-2, new Point(r.x, r.y)), new EditPoint(-3, new Point(r.x + r.width, r.y)), new EditPoint(-4, new Point(r.x, r.y + r.height)), new EditPoint(-5, new Point(r.x + r.width, r.y + r.height))};
    }

    public void setProperties(XProperties props) {
        this.textField.setText(props.getProperty("Text.text", ""));
        this.italic.setSelected(props.getBoolProperty("Text.italic", false));
        this.bold.setSelected(props.getBoolProperty("Text.bold", false));
        this.fontName.setSelectedItem(props.getProperty("Text.fontName", "SansSerif"));
        this.fontSize.setSelectedItem(props.getProperty("Text.fontSize", "12"));
        this.colorChooser.setColor(props.getColorProperty("Text.color", Color.black));
    }

    public void getProperties(XProperties props) {
        props.put("Text.color", this.colorChooser.getColor());
        props.put("Text.text", this.textField.getText());
        props.put((Object)"Text.fontName", this.fontName.getSelectedItem());
        props.put((Object)"Text.fontSize", this.fontSize.getSelectedItem());
        props.put("Text.italic", this.italic.isSelected());
        props.put("Text.bold", this.bold.isSelected());
    }

    public EditableObject createObject() {
        PTText t = new PTText();
        this.storeAttributesInto(t);
        return t;
    }

    void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        PTText t = (PTText)eo;
        t.setColor(this.colorChooser.getColor());
        t.setText(this.textField.getText());
        t.setFont(this.storeFont());
    }

    Font storeFont() {
        String name = (String)this.fontName.getSelectedItem();
        String size = (String)this.fontSize.getSelectedItem();
        return new Font(name, 0 + (this.isBold ? 1 : 0) + (this.isItalic ? 2 : 0), this.getInt(size, 12));
    }

    void extractFont(Font f) {
        this.fontName.setSelectedItem(f.getName());
        this.fontSize.setSelectedItem(String.valueOf(f.getSize()));
        this.italic.setSelected(f.isItalic());
        this.bold.setSelected(f.isBold());
    }

    void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        PTText t = (PTText)eo;
        this.colorChooser.setColor(t.getColor());
        this.textField.setText(t.getText());
        this.extractFont(t.getFont());
    }

    public Editor getSecondaryEditor(EditableObject go) {
        TextEditor result = new TextEditor();
        result.extractAttributesFrom(go);
        return result;
    }

    public String getStatusLineMsg() {
        return AnimalTranslator.translateMessage("textStatusLine", new Object[]{DrawCanvas.translateDrawButton(), DrawCanvas.translateFinishButton(), DrawCanvas.translateCancelButton()});
    }

    public void actionPerformed(ActionEvent e) {
        Font newFont;
        String size;
        String name;
        super.actionPerformed(e);
        PTText t = (PTText)this.getCurrentObject();
        this.isItalic = t.getFont().isItalic();
        this.isBold = t.getFont().isBold();
        if (e.getSource() == this.textField) {
            t.setText(this.textField.getText());
        }
        if (e.getSource() == this.fontName || e.getSource() == this.fontSize) {
            t.setFont(this.storeFont());
        }
        if (e.getSource() == this.italic) {
            this.isItalic = !this.isItalic;
            name = (String)this.fontName.getSelectedItem();
            size = (String)this.fontSize.getSelectedItem();
            newFont = new Font(name, 0 + (this.bold.isSelected() ? 1 : 0) + (this.italic.isSelected() ? 2 : 0), this.getInt(size, 12));
            t.setFont(newFont);
        }
        if (e.getSource() == this.bold) {
            this.isBold = !this.isBold;
            name = (String)this.fontName.getSelectedItem();
            size = (String)this.fontSize.getSelectedItem();
            newFont = new Font(name, 0 + (this.bold.isSelected() ? 1 : 0) + (this.italic.isSelected() ? 2 : 0), this.getInt(size, 12));
            t.setFont(newFont);
        }
        this.repaintNow();
        if (Animation.get() != null) {
            Animation.get().doChange();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        PTText t = (PTText)this.getCurrentObject();
        String eventName = event.getPropertyName();
        if (eventName.equals("textColor")) {
            t.setColor((Color)event.getNewValue());
        }
        if (!event.getOldValue().equals(event.getNewValue())) {
            this.repaintNow();
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
        }
    }

    public String getBasicType() {
        return "Text";
    }
}

