/*
 * Decompiled with CFR 0.152.
 */
package animal.editor;

import animal.animator.Scale;
import animal.editor.Editor;
import animal.editor.TimedAnimatorEditor;
import animal.graphics.PTPoint;
import animal.misc.AnimalTranslator;
import animal.misc.EditableObject;
import animal.misc.ObjectSelectionButton;
import animal.misc.XProperties;
import java.awt.FlowLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ScaleEditor
extends TimedAnimatorEditor {
    private static final long serialVersionUID = -7598478572744872282L;
    private ObjectSelectionButton center;
    private JTextField xScaleFactorTF;
    private JTextField yScaleFactorTF;

    public ScaleEditor() {
        JPanel c = new JPanel(new FlowLayout(0));
        c.add(AnimalTranslator.getGUIBuilder().generateJLabel("scaleCenterLabel"));
        this.center = new ObjectSelectionButton(false);
        c.add(this.center);
        c.add(AnimalTranslator.getGUIBuilder().generateJLabel("scaleFactorXLabel"));
        this.xScaleFactorTF = new JTextField(5);
        c.add(this.xScaleFactorTF);
        c.add(AnimalTranslator.getGUIBuilder().generateJLabel("scaleFactorYLabel"));
        this.yScaleFactorTF = new JTextField(5);
        c.add(this.yScaleFactorTF);
        this.addLayer(c);
        this.finish();
    }

    public void setProperties(XProperties props) {
    }

    public void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        Scale scale = (Scale)eo;
        this.center.setObjectNum(scale.getCenterNum());
        this.xScaleFactorTF.setText(String.valueOf(scale.getXScaleFactor()));
        this.yScaleFactorTF.setText(String.valueOf(scale.getYScaleFactor()));
    }

    public void storeAttributesInto(EditableObject scale) {
        super.storeAttributesInto(scale);
        if (scale instanceof Scale) {
            Scale scaler = (Scale)scale;
            scaler.setCenterNum(this.center.getObjectNum());
            scaler.setXScaleFactor(this.getDouble(this.xScaleFactorTF.getText(), 1.0));
            scaler.setYScaleFactor(this.getDouble(this.yScaleFactorTF.getText(), 1.0));
        }
    }

    public Editor getSecondaryEditor(EditableObject eo) {
        ScaleEditor result = new ScaleEditor();
        result.extractAttributesFrom(eo);
        return result;
    }

    public EditableObject createObject() {
        Scale r = new Scale();
        this.storeAttributesInto(r);
        return r;
    }

    String isOK() {
        String result = super.isOK();
        if (result != null) {
            return result;
        }
        this.center.checkObjects();
        int num = this.center.getObjectNum();
        if (num == 0) {
            return AnimalTranslator.translateMessage("scaleNoCenter");
        }
        if (!(ScaleEditor.getGraphicObject(num) instanceof PTPoint)) {
            return AnimalTranslator.translateMessage("scaleCenterNotPoint");
        }
        return null;
    }
}

