/*
 * Decompiled with CFR 0.152.
 */
package animal.editor;

import animal.editor.Editor;
import animal.editor.PolygonalShapeEditor;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTRectangle;
import animal.gui.DrawCanvas;
import animal.main.Animation;
import animal.misc.AnimalTranslator;
import animal.misc.EditPoint;
import animal.misc.EditableObject;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import translator.TranslatableGUIElement;

public class RectangleEditor
extends PolygonalShapeEditor
implements ItemListener,
ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = -2413776784253970663L;

    public RectangleEditor() {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        Box contentBox = this.createCommonElements(generator);
        this.filledCB = generator.generateJCheckBox("filled", null, this);
        this.filledCB.addItemListener(this);
        contentBox.add(this.filledCB);
        this.finishBoxes();
    }

    public int pointsNeeded() {
        return 2;
    }

    public boolean nextPoint(int num, Point p) {
        PTRectangle rectangle = (PTRectangle)this.getCurrentObject();
        if (num == 1) {
            rectangle.setFirstNode(p.x, p.y);
        }
        if (num == 2) {
            Point firstNode = rectangle.getFirstNode();
            rectangle.setWidth(p.x - firstNode.x);
            rectangle.setHeight(p.y - firstNode.y);
        }
        return true;
    }

    public int getMinDist(PTGraphicObject go, Point p) {
        PTRectangle pg = (PTRectangle)go;
        Point a = new Point(pg.getFirstNode().x, pg.getFirstNode().y);
        Rectangle boundingBox = pg.getBoundingBox();
        if (boundingBox.contains(p.x, p.y)) {
            return 0;
        }
        Point b = new Point(a.x + pg.getWidth(), a.y);
        int minDist = Integer.MAX_VALUE;
        int newDist = MSMath.dist(p, a, b);
        if (newDist < minDist) {
            minDist = newDist;
        }
        b.translate(0, pg.getHeight());
        newDist = MSMath.dist(p, a, b);
        if (newDist < minDist) {
            minDist = newDist;
        }
        a.translate(pg.getWidth(), pg.getHeight());
        newDist = MSMath.dist(p, a, b);
        if (newDist < minDist) {
            minDist = newDist;
        }
        if ((newDist = MSMath.dist(p, a, pg.getFirstNode())) < minDist) {
            minDist = newDist;
        }
        return minDist;
    }

    public EditPoint[] getEditPoints(PTGraphicObject go) {
        PTRectangle pg = (PTRectangle)go;
        int width = pg.getWidth();
        int height = pg.getHeight();
        EditPoint[] result = new EditPoint[5];
        Point helper = pg.getFirstNode();
        helper = new Point(helper.x + width, helper.y + height);
        result[0] = new EditPoint(2, helper);
        int x = pg.getFirstNode().x;
        int y = pg.getFirstNode().y;
        result[1] = new EditPoint(-2, new Point(x + width / 2, y));
        result[2] = new EditPoint(-3, new Point(x + width, y + height / 2));
        result[3] = new EditPoint(-4, new Point(x + width / 2, y + height));
        result[4] = new EditPoint(-5, new Point(x, y + height / 2));
        return result;
    }

    public void setProperties(XProperties props) {
        this.colorChooser.setColor(props.getColorProperty("Rectangle.color", Color.black));
        this.depthBox.setSelectedItem(props.getProperty("depth", String.valueOf(16)));
        this.fillColorChooser.setColor(props.getColorProperty("Rectangle.fillColor", Color.black));
        this.filledCB.setSelected(props.getBoolProperty("Rectangle.filled"));
    }

    public void getProperties(XProperties props) {
        props.put("Rectangle.color", this.colorChooser.getColor());
        props.put((Object)"depth", this.depthBox.getSelectedItem());
        props.put("Rectangle.fillColor", this.fillColorChooser.getColor());
        props.put("Rectangle.filled", this.filledCB.isSelected());
    }

    public void itemStateChanged(ItemEvent e) {
        PTRectangle p = (PTRectangle)this.getCurrentObject();
        if (e.getSource() == this.filledCB && p != null) {
            p.setFilled(this.filledCB.isSelected());
        }
        Animation.get().doChange();
        this.repaintNow();
    }

    public EditableObject createObject() {
        PTRectangle pg = new PTRectangle();
        this.storeAttributesInto(pg);
        return pg;
    }

    void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        PTRectangle p = (PTRectangle)eo;
        p.setColor(this.colorChooser.getColor());
        p.setFilled(this.filledCB.isSelected());
        p.setFillColor(this.fillColorChooser.getColor());
    }

    void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        PTRectangle p = (PTRectangle)eo;
        this.colorChooser.setColor(p.getColor());
        this.filledCB.setEnabled(true);
        this.filledCB.setSelected(p.isFilled());
        this.fillColorChooser.setColor(p.getFillColor());
    }

    public Editor getSecondaryEditor(EditableObject go) {
        RectangleEditor result = new RectangleEditor();
        result.extractAttributesFrom(go);
        return result;
    }

    public String getStatusLineMsg() {
        return AnimalTranslator.translateMessage("rectangleStatusLine", new Object[]{DrawCanvas.translateDrawButton(), DrawCanvas.translateFinishButton(), DrawCanvas.translateCancelButton()});
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        PTRectangle p = (PTRectangle)this.getCurrentObject();
        if (p != null) {
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
            this.repaintNow();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        PTRectangle poly = (PTRectangle)this.getCurrentObject();
        String eventName = event.getPropertyName();
        if (eventName.equals("color")) {
            poly.setColor((Color)event.getNewValue());
        } else if (eventName.equals("fillColor")) {
            poly.setFillColor((Color)event.getNewValue());
        }
        if (!event.getOldValue().equals(event.getNewValue())) {
            this.repaintNow();
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
        }
    }

    public String getBasicType() {
        return "Rectangle";
    }
}

