/*
 * Decompiled with CFR 0.152.
 */
package animal.editor;

import animal.editor.Editor;
import animal.editor.GraphicEditor;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTLinkedElement;
import animal.graphics.PTPolyline;
import animal.gui.DrawCanvas;
import animal.main.Animal;
import animal.main.Animation;
import animal.misc.AnimalTranslator;
import animal.misc.ColorChoice;
import animal.misc.ColorChooserAction;
import animal.misc.EditPoint;
import animal.misc.EditableObject;
import animal.misc.MSMath;
import animal.misc.TextUtilities;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import translator.ExtendedActionButton;

public class LinkedElementEditor
extends GraphicEditor
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = -4018193969138513117L;
    private ColorChooserAction textBoxAndPointerColorChooser;
    private ColorChooserAction textBoxFillColorChooser;
    private ColorChooserAction pointerAreaColorChooser;
    private ColorChooserAction pointerAreaFillColorChooser;
    private ColorChooserAction textColorChooser;
    private JCheckBox bold;
    private JCheckBox italic;
    private JComboBox fontName;
    private JComboBox fontSize;
    private JComboBox pointerCount;
    private JComboBox pointerPosition;
    private JTextField text;
    private boolean isItalic;
    private boolean isBold;
    private AbstractButton nullPointerButton;

    public LinkedElementEditor() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JTabbedPane textPane = new JTabbedPane();
        JTabbedPane tp = new JTabbedPane();
        JPanel textPanel = new JPanel(gbl);
        JPanel fontPanel = new JPanel(gbl);
        JPanel textBoxPanel = new JPanel(gbl);
        JPanel pointerPanel = new JPanel(gbl);
        JPanel pointerAreaPanel = new JPanel(gbl);
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        textBoxPanel.add((Component)AnimalTranslator.getGUIBuilder().generateJLabel("boxPtrColorLabel"), gbc);
        gbc.gridwidth = 0;
        Color initialColor = this.getCurrentObject(false) == null ? Color.black : ((PTLinkedElement)this.getCurrentObject()).getColor();
        this.textBoxAndPointerColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "color", AnimalTranslator.translateMessage("boxPtrColor", new Object[]{"boxPtrColor"}), initialColor);
        textBoxPanel.add((Component)new ExtendedActionButton(this.textBoxAndPointerColorChooser, 67), gbc);
        gbc.gridwidth = 1;
        textBoxPanel.add((Component)AnimalTranslator.getGUIBuilder().generateJLabel("fillColorLabel"), gbc);
        gbc.gridwidth = 0;
        initialColor = this.getCurrentObject(false) == null ? Color.black : ((PTLinkedElement)this.getCurrentObject()).getBoxFillColor();
        this.textBoxFillColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "textBoxFillColor", AnimalTranslator.translateMessage("chooseColor", new Object[]{"textBoxFillColor"}), initialColor);
        textBoxPanel.add((Component)new ExtendedActionButton(this.textBoxFillColorChooser, 70), gbc);
        gbc.gridwidth = 1;
        pointerAreaPanel.add((Component)AnimalTranslator.getGUIBuilder().generateJLabel("pointerBoxColorLabel"), gbc);
        gbc.gridwidth = 0;
        initialColor = this.getCurrentObject(false) == null ? Color.black : ((PTLinkedElement)this.getCurrentObject()).getPointerAreaColor();
        this.pointerAreaColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "pointerAreaColor", AnimalTranslator.translateMessage("chooseColor", new Object[]{"pointerBoxColor"}), initialColor);
        pointerAreaPanel.add((Component)new ExtendedActionButton(this.pointerAreaColorChooser, 80), gbc);
        gbc.gridwidth = 1;
        pointerAreaPanel.add((Component)AnimalTranslator.getGUIBuilder().generateJLabel("fillColor"), gbc);
        gbc.gridwidth = 0;
        initialColor = this.getCurrentObject(false) == null ? Color.black : ((PTLinkedElement)this.getCurrentObject()).getPointerAreaFillColor();
        this.pointerAreaFillColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "pointerAreaFillColor", AnimalTranslator.translateMessage("chooseColor", new Object[]{"pointerAreaFillColor"}), initialColor);
        pointerAreaPanel.add((Component)new ExtendedActionButton(this.pointerAreaFillColorChooser, 70), gbc);
        gbc.gridwidth = 0;
        this.text = new JTextField(30);
        textPanel.add((Component)this.text, gbc);
        this.text.addActionListener(this);
        JPanel p = new JPanel();
        Action theAction = TextUtilities.findTextFieldAction("cut-to-clipboard");
        p.add(AnimalTranslator.getGUIBuilder().generateActionButton("cut", null, theAction));
        theAction = TextUtilities.findTextFieldAction("copy-to-clipboard");
        p.add(AnimalTranslator.getGUIBuilder().generateActionButton("copy", null, theAction));
        theAction = TextUtilities.findTextFieldAction("paste-from-clipboard");
        p.add(AnimalTranslator.getGUIBuilder().generateActionButton("paste", null, theAction));
        textPanel.add((Component)p, gbc);
        gbc.gridwidth = 1;
        textPanel.add((Component)AnimalTranslator.getGUIBuilder().generateJLabel("colorLabel"), gbc);
        gbc.gridwidth = 0;
        initialColor = this.getCurrentObject(false) == null ? Color.black : ((PTLinkedElement)this.getCurrentObject()).getTextColor();
        this.textColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "textColor", AnimalTranslator.translateMessage("chooseColor", new Object[]{"textColor"}), initialColor);
        textPanel.add((Component)new ExtendedActionButton(this.textColorChooser, 67), gbc);
        gbc.gridwidth = 1;
        fontPanel.add((Component)AnimalTranslator.getGUIBuilder().generateJLabel("fontLabel"), gbc);
        gbc.gridwidth = 0;
        this.fontName = new JComboBox();
        fontPanel.add((Component)this.fontName, gbc);
        int j = 0;
        while (j < Animal.GLOBAL_FONTS.length) {
            this.fontName.addItem(Animal.GLOBAL_FONTS[j]);
            ++j;
        }
        this.fontName.addActionListener(this);
        gbc.gridwidth = 1;
        fontPanel.add((Component)AnimalTranslator.getGUIBuilder().generateJLabel("fontSizeLabel"), gbc);
        gbc.gridwidth = 0;
        this.fontSize = new JComboBox();
        fontPanel.add((Component)this.fontSize, gbc);
        this.fontSize.setEditable(true);
        this.fontSize.addItem("8");
        this.fontSize.addItem("10");
        this.fontSize.addItem("12");
        this.fontSize.addItem("14");
        this.fontSize.addItem("16");
        this.fontSize.addItem("24");
        this.fontSize.setSelectedItem("12");
        this.fontSize.addActionListener(this);
        gbc.gridwidth = 1;
        fontPanel.add((Component)AnimalTranslator.getGUIBuilder().generateJLabel("fontStyleLabel"), gbc);
        this.italic = AnimalTranslator.getGUIBuilder().generateJCheckBox("italic", null, this);
        this.italic.setHorizontalAlignment(0);
        fontPanel.add((Component)this.italic, gbc);
        this.bold = AnimalTranslator.getGUIBuilder().generateJCheckBox("bold", null, this);
        this.bold.setHorizontalAlignment(0);
        fontPanel.add((Component)this.bold, gbc);
        AnimalTranslator.getGUIBuilder().insertTranslatableTab("text", null, textPanel, textPane);
        AnimalTranslator.getGUIBuilder().insertTranslatableTab("font", null, fontPanel, textPane);
        gbc.gridwidth = 1;
        pointerPanel.add((Component)AnimalTranslator.getGUIBuilder().generateJLabel("pointerPositionLabel"), gbc);
        gbc.gridwidth = 0;
        this.pointerPosition = new JComboBox();
        pointerPanel.add((Component)this.pointerPosition, gbc);
        this.pointerPosition.addItem(AnimalTranslator.translateMessage("positionNone"));
        this.pointerPosition.addItem(AnimalTranslator.translateMessage("positionRight"));
        this.pointerPosition.addItem(AnimalTranslator.translateMessage("positionLeft"));
        this.pointerPosition.addItem(AnimalTranslator.translateMessage("positionTop"));
        this.pointerPosition.addItem(AnimalTranslator.translateMessage("positionBottom"));
        this.pointerPosition.addActionListener(this);
        gbc.gridwidth = 1;
        pointerPanel.add((Component)AnimalTranslator.getGUIBuilder().generateJLabel("pointerCountLabel"), gbc);
        this.pointerCount = new JComboBox();
        gbc.gridwidth = 0;
        pointerPanel.add((Component)this.pointerCount, gbc);
        j = 0;
        while (j < 10) {
            this.pointerCount.addItem(String.valueOf(j));
            ++j;
        }
        this.pointerCount.addActionListener(this);
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.anchor = 10;
        this.nullPointerButton = AnimalTranslator.getGUIBuilder().generateJButton("nullPtrButton", null, false, this);
        pointerPanel.add((Component)this.nullPointerButton, gbc);
        AnimalTranslator.getGUIBuilder().insertTranslatableTab("textBox", null, textBoxPanel, tp);
        AnimalTranslator.getGUIBuilder().insertTranslatableTab("pointerBox", null, pointerAreaPanel, tp);
        AnimalTranslator.getGUIBuilder().insertTranslatableTab("text", null, textPane, tp);
        AnimalTranslator.getGUIBuilder().insertTranslatableTab("pointer", null, pointerPanel, tp);
        this.addLayer(tp);
        tp.setSize(240, 160);
        this.finish(tp);
    }

    public int pointsNeeded() {
        return 2 + ((PTLinkedElement)this.getCurrentObject()).getNrPointers();
    }

    public boolean nextPoint(int num, Point p) {
        PTLinkedElement bp = (PTLinkedElement)this.getCurrentObject();
        switch (num) {
            case 1: 
            case 2: {
                bp.setLocation(p);
                break;
            }
            default: {
                bp.setTip(num - 3, p);
            }
        }
        return true;
    }

    public int getMinDist(PTGraphicObject go, Point p) {
        PTLinkedElement bp = (PTLinkedElement)go;
        PTPolyline box = bp.getBox();
        PTPolyline[] localPointerArea = bp.getPointerArea();
        int minDist = Integer.MAX_VALUE;
        if (localPointerArea != null) {
            int nrPointers = localPointerArea.length;
            int i = 0;
            while (i < nrPointers) {
                PTPolyline pointerArea = localPointerArea[i];
                if (box.toPolygon().contains(p)) {
                    return 0;
                }
                if (pointerArea != null && pointerArea.toPolygon().contains(p)) {
                    return 0;
                }
                minDist = Math.min(MSMath.dist(p, box.getNode(3).toPoint(), box.getNode(0).toPoint()), MSMath.dist(p, pointerArea.getNode(3).toPoint(), pointerArea.getNode(0).toPoint()));
                i = 0;
                while (i < 3) {
                    minDist = Math.min(minDist, MSMath.dist(p, box.getNode(i).toPoint(), box.getNode(i + 1).toPoint()));
                    minDist = Math.min(minDist, MSMath.dist(p, pointerArea.getNode(i).toPoint(), pointerArea.getNode(i + 1).toPoint()));
                    ++i;
                }
                ++i;
            }
        }
        int i = 0;
        while (i < bp.getNrPointers()) {
            minDist = Math.min(minDist, MSMath.dist(p, bp.getPointerOrigin(i), bp.getTip(i)));
            ++i;
        }
        return minDist;
    }

    public EditPoint[] getEditPoints(PTGraphicObject go) {
        PTLinkedElement bp = (PTLinkedElement)go;
        int count = bp.getPointerArea() != null ? bp.getNrPointers() : 0;
        EditPoint[] result = new EditPoint[1 + count];
        result[0] = new EditPoint(-1, bp.getOrigin());
        int i = 0;
        while (i < count) {
            result[i + 1] = new EditPoint(i + 3, bp.getTip(i));
            ++i;
        }
        return result;
    }

    public void setProperties(XProperties props) {
        this.text.setText(props.getProperty("LINKEDELEMENT.text"));
        this.fontName.setSelectedItem(props.getProperty("LINKEDELEMENT.fontName", "SansSerif"));
        this.fontSize.setSelectedItem(props.getProperty("LINKEDELEMENT.fontSize", "12"));
        int fontStyle = props.getIntProperty("LINKEDELEMENT.fontStyle");
        this.italic.setSelected((fontStyle & 2) == 2);
        this.bold.setSelected((fontStyle & 1) == 1);
        this.pointerPosition.setSelectedItem(props.getProperty("LINKEDELEMENT.pointerPosition", "Right"));
        this.pointerCount.setSelectedItem(String.valueOf(props.getIntProperty("LINKEDELEMENT.nrPointers", 1)));
        this.textBoxAndPointerColorChooser.setColor(props.getColorProperty("LINKEDELEMENT.color", Color.black));
        this.textBoxFillColorChooser.setColor(props.getColorProperty("LINKEDELEMENT.fillColor", Color.white));
        this.pointerAreaColorChooser.setColor(props.getColorProperty("LINKEDELEMENT.pointerAreaColor", Color.white));
        this.pointerAreaFillColorChooser.setColor(props.getColorProperty("LINKEDELEMENT.pointerAreaFillColor", Color.white));
        this.textColorChooser.setColor(props.getColorProperty("LINKEDELEMENT.textColor", Color.black));
    }

    public void getProperties(XProperties props) {
        int fontStyle;
        props.put("LINKEDELEMENT.color", this.textBoxAndPointerColorChooser.getColor());
        props.put("LINKEDELEMENT.fillColor", this.textBoxFillColorChooser.getColor());
        props.put("LINKEDELEMENT.pointerAreaColor", this.pointerAreaColorChooser.getColor());
        props.put("LINKEDELEMENT.pointerAreaFillColor", this.pointerAreaFillColorChooser.getColor());
        props.put("LINKEDELEMENT.textColor", this.textColorChooser.getColor());
        props.put("LINKEDELEMENT.text", this.text.getText());
        props.put((Object)"LINKEDELEMENT.fontName", this.fontName.getSelectedItem());
        props.put((Object)"LINKEDELEMENT.fontSize", this.fontSize.getSelectedItem());
        int n = fontStyle = this.italic.isSelected() ? 2 : 0;
        if (this.bold.isSelected()) {
            fontStyle |= 1;
        }
        props.put("LINKEDELEMENT.fontStyle", fontStyle);
        props.put((Object)"LINKEDELEMENT.pointerPosition", this.pointerPosition.getSelectedItem());
        props.put((Object)"LINKEDELEMENT.nrPointers", this.pointerCount.getSelectedItem());
    }

    public EditableObject createObject() {
        PTLinkedElement bp = new PTLinkedElement();
        this.storeAttributesInto(bp);
        return bp;
    }

    void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        PTLinkedElement bp = (PTLinkedElement)eo;
        bp.setColor(this.textBoxAndPointerColorChooser.getColor());
        bp.setBoxFillColor(this.textBoxFillColorChooser.getColor());
        bp.setPointerAreaColor(this.pointerAreaColorChooser.getColor());
        bp.setPointerAreaFillColor(this.pointerAreaFillColorChooser.getColor());
        bp.setTextColor(this.textColorChooser.getColor());
        bp.setText(this.text.getText());
        bp.setFont(this.storeFont());
        bp.setPointerPosition(this.pointerPosition.getSelectedIndex());
        try {
            bp.setPointerCount(Integer.parseInt((String)this.pointerCount.getSelectedItem()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    Font storeFont() {
        String name = (String)this.fontName.getSelectedItem();
        String size = (String)this.fontSize.getSelectedItem();
        return new Font(name, 0 + (this.isBold ? 1 : 0) + (this.isItalic ? 2 : 0), this.getInt(size, 12));
    }

    void extractFont(Font f) {
        this.fontName.setSelectedItem(f.getName());
        this.fontSize.setSelectedItem(String.valueOf(f.getSize()));
        this.italic.setSelected(f.isItalic());
        this.bold.setSelected(f.isBold());
    }

    void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        PTLinkedElement bp = (PTLinkedElement)eo;
        this.textBoxAndPointerColorChooser.setColor(bp.getColor());
        this.textBoxFillColorChooser.setColor(bp.getBoxFillColor());
        this.pointerAreaColorChooser.setColor(bp.getPointerAreaColor());
        this.pointerAreaFillColorChooser.setColor(bp.getPointerAreaFillColor());
        this.textColorChooser.setColor(bp.getTextColor());
        this.text.setText(bp.getText());
        this.extractFont(bp.getFont());
        this.pointerPosition.setSelectedIndex(bp.getPointerPosition());
        this.pointerCount.setSelectedItem(String.valueOf(bp.getNrPointers()));
    }

    public Editor getSecondaryEditor(EditableObject eo) {
        LinkedElementEditor result = new LinkedElementEditor();
        result.extractAttributesFrom(eo);
        return result;
    }

    public String getStatusLineMsg() {
        return AnimalTranslator.translateMessage("LinkedElementStatusLine", new Object[]{DrawCanvas.translateDrawButton(), DrawCanvas.translateFinishButton(), DrawCanvas.translateCancelButton()});
    }

    public void actionPerformed(ActionEvent e) {
        Font newFont;
        String size;
        String name;
        super.actionPerformed(e);
        PTLinkedElement bp = (PTLinkedElement)this.getCurrentObject();
        this.isItalic = bp.getFont().isItalic();
        this.isBold = bp.getFont().isBold();
        if (e.getSource() == this.text) {
            bp.setText(this.text.getText());
        }
        if (e.getSource() == this.fontName || e.getSource() == this.fontSize) {
            bp.setFont(this.storeFont());
        }
        if (e.getSource() == this.italic) {
            this.isItalic = !this.isItalic;
            name = (String)this.fontName.getSelectedItem();
            size = (String)this.fontSize.getSelectedItem();
            newFont = new Font(name, 0 + (this.bold.isSelected() ? 1 : 0) + (this.italic.isSelected() ? 2 : 0), this.getInt(size, 12));
            bp.setFont(newFont);
        }
        if (e.getSource() == this.bold) {
            this.isBold = !this.isBold;
            name = (String)this.fontName.getSelectedItem();
            size = (String)this.fontSize.getSelectedItem();
            newFont = new Font(name, 0 + (this.bold.isSelected() ? 1 : 0) + (this.italic.isSelected() ? 2 : 0), this.getInt(size, 12));
            bp.setFont(newFont);
        }
        if (e.getSource() == this.pointerPosition) {
            bp.setPointerPosition(this.pointerPosition.getSelectedIndex());
        }
        if (e.getSource() == this.pointerCount) {
            try {
                bp.setPointerCount(Integer.parseInt((String)this.pointerCount.getSelectedItem()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (e.getSource() == this.nullPointerButton) {
            bp.makeNullPointer();
        }
        bp.init();
        Animation.get().doChange();
        this.repaintNow();
    }

    public void propertyChange(PropertyChangeEvent event) {
        PTLinkedElement bp = (PTLinkedElement)this.getCurrentObject();
        String eventName = event.getPropertyName();
        if (eventName.equals("color")) {
            bp.setColor((Color)event.getNewValue());
        } else if (eventName.equals("textBoxFillColor")) {
            bp.setBoxFillColor((Color)event.getNewValue());
        } else if (eventName.equals("pointerAreaColor")) {
            bp.setPointerAreaColor((Color)event.getNewValue());
        } else if (eventName.equals("pointerAreaFillColor")) {
            bp.setPointerAreaFillColor((Color)event.getNewValue());
        } else if (eventName.equals("textColor")) {
            bp.setTextColor((Color)event.getNewValue());
        }
        if (!event.getOldValue().equals(event.getNewValue())) {
            this.repaintNow();
            Animation.get().doChange();
        }
    }

    public String getBasicType() {
        return "LINKEDELEMENT";
    }
}

