/*
 * Decompiled with CFR 0.152.
 */
package animal.editor;

import animal.animator.GraphicObjectSpecificAnimation;
import animal.animator.Highlight;
import animal.editor.Editor;
import animal.editor.TimedAnimatorEditor;
import animal.graphics.PTArray;
import animal.graphics.PTGraph;
import animal.graphics.PTGraphicObject;
import animal.misc.AnimalTranslator;
import animal.misc.EditableObject;
import animal.misc.ObjectSelectionButton;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class HighlightEditor
extends TimedAnimatorEditor
implements GraphicObjectSpecificAnimation {
    private static final long serialVersionUID = 8521232039932626594L;
    private int commonLength = -1;
    private JPanel hlContent;
    private JScrollPane scp;
    public GridBagConstraints hlC = new GridBagConstraints(-1, 1, 1, 1, 0.5, 0.5, 17, 0, new Insets(0, 0, 0, 0), 5, 0);
    private static final String CELL_LABEL = "affectedCells";

    public HighlightEditor() {
        this.hlContent = new JPanel(new GridLayout(5, 5, 5, 0));
        this.scp = new JScrollPane(this.hlContent, 21, 30);
        this.scp.setRowHeaderView(AnimalTranslator.getGUIBuilder().generateJLabel(CELL_LABEL));
        this.scp.setMaximumSize(new Dimension(400, 300));
        this.addLayer(this.scp);
        this.finish();
    }

    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        if (e.getSource() instanceof ObjectSelectionButton) {
            if (this.objectNums != null && this.objectNums.length > 0) {
                int x;
                this.commonLength = -1;
                int now = 0;
                int i = 0;
                while (i < this.objectNums.length) {
                    int[] elements = ((ObjectSelectionButton)e.getSource()).getObjectNums();
                    if (elements != null && elements.length > i) {
                        now = elements[i];
                    }
                    int length = -1;
                    if (HighlightEditor.getGraphicObject(now) instanceof PTArray) {
                        length = ((PTArray)HighlightEditor.getGraphicObject((int)now)).length;
                    } else if (HighlightEditor.getGraphicObject(now) instanceof PTGraph) {
                        length = ((PTGraph)HighlightEditor.getGraphicObject((int)now)).length;
                    }
                    if (this.commonLength == -1 || length > this.commonLength) {
                        this.commonLength = length;
                    }
                    ++i;
                }
                if (this.commonLength == -1) {
                    this.hlContent.removeAll();
                } else if (this.commonLength < this.hlContent.getComponentCount()) {
                    x = this.hlContent.getComponentCount() - 1;
                    while (x >= this.commonLength) {
                        this.hlContent.remove(x);
                        --x;
                    }
                } else if (this.commonLength > this.hlContent.getComponentCount()) {
                    x = this.hlContent.getComponentCount();
                    while (x < this.commonLength) {
                        this.hlContent.add(new JCheckBox(String.valueOf(x), false), this.hlC, x);
                        ++x;
                    }
                }
            } else {
                this.commonLength = -1;
                this.hlContent.removeAll();
            }
            if ((double)this.scp.getWidth() > this.scp.getMaximumSize().getWidth()) {
                this.scp.getViewport().setViewSize(this.scp.getMaximumSize());
            }
        }
    }

    public void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        Highlight hl = (Highlight)eo;
        PTGraphicObject ao = null;
        if (this.objectNums != null && this.objectNums.length > 0) {
            int i = 0;
            while (i < this.objectNums.length) {
                if (this.objectSB.getObjectNums() != null) {
                    ao = HighlightEditor.getGraphicObject(this.objectSB.getObjectNums()[i]);
                }
                int length = -1;
                if (ao instanceof PTArray) {
                    length = ((PTArray)ao).length;
                } else if (ao instanceof PTGraph) {
                    length = ((PTGraph)ao).length;
                }
                if (this.commonLength == -1 || length > this.commonLength) {
                    this.commonLength = length;
                }
                ++i;
            }
            this.hlContent.removeAll();
            int x = 0;
            while (x < this.commonLength) {
                this.hlContent.add(new JCheckBox(String.valueOf(x), hl.getHighlightState(x)), this.hlC, x);
                ++x;
            }
        }
        this.scp.setViewportView(this.hlContent);
    }

    public void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        Highlight hl = (Highlight)eo;
        if (this.commonLength > 0) {
            boolean[] highlightState = new boolean[this.hlContent.getComponentCount()];
            int x = 0;
            while (x < this.hlContent.getComponentCount()) {
                highlightState[x] = ((JCheckBox)this.hlContent.getComponent(x)).isSelected();
                ++x;
            }
            hl.setHighlightState(highlightState);
        }
    }

    public Editor getSecondaryEditor(EditableObject eo) {
        HighlightEditor result = new HighlightEditor();
        result.extractAttributesFrom(eo);
        return result;
    }

    public EditableObject createObject() {
        Highlight h = new Highlight();
        this.storeAttributesInto(h);
        return h;
    }

    public String[] getSupportedTypes() {
        return new String[]{"Graph", "IntArray", "StringArray"};
    }
}

