/*
 * Decompiled with CFR 0.152.
 */
package animal.editor;

import animal.animator.ColorChanger;
import animal.editor.Editor;
import animal.editor.TimedAnimatorEditor;
import animal.misc.AnimalTranslator;
import animal.misc.ColorChoice;
import animal.misc.EditableObject;
import animal.misc.XProperties;
import java.awt.Color;
import javax.swing.JPanel;

public class ColorChangerEditor
extends TimedAnimatorEditor {
    private static final long serialVersionUID = -243298461803526770L;
    private ColorChoice color;

    public ColorChangerEditor() {
        JPanel c = new JPanel();
        c.add(AnimalTranslator.getGUIBuilder().generateJLabel("targetColor"));
        this.color = new ColorChoice();
        c.add(this.color);
        this.addLayer(c);
        this.finish();
    }

    public void setProperties(XProperties props) {
        super.setProperties(props);
        this.color.setColor(props.getColorProperty("color", Color.black));
    }

    public void getProperties(XProperties props) {
        super.getProperties(props);
        props.put("color", this.color.getColor());
    }

    public void extractAttributesFrom(EditableObject colorChanger) {
        super.extractAttributesFrom(colorChanger);
        this.color.setColor(((ColorChanger)colorChanger).getColor());
    }

    public void storeAttributesInto(EditableObject colorChanger) {
        super.storeAttributesInto(colorChanger);
        ((ColorChanger)colorChanger).setColor(this.color.getColor());
    }

    public Editor getSecondaryEditor(EditableObject eo) {
        ColorChangerEditor result = new ColorChangerEditor();
        result.extractAttributesFrom(eo);
        return result;
    }

    public EditableObject createObject() {
        ColorChanger c = new ColorChanger();
        this.storeAttributesInto(c);
        return c;
    }
}

