/*
 * Decompiled with CFR 0.152.
 */
package animal.editor;

import animal.editor.ArcBasedShapeEditor;
import animal.editor.Editor;
import animal.graphics.PTCircle;
import animal.graphics.PTGraphicObject;
import animal.gui.DrawCanvas;
import animal.main.Animation;
import animal.misc.AnimalTranslator;
import animal.misc.EditPoint;
import animal.misc.EditableObject;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import translator.TranslatableGUIElement;

public class CircleEditor
extends ArcBasedShapeEditor
implements ItemListener,
ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = -2413776784253970663L;

    public CircleEditor() {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        Box contentBox = this.createCommonElements(generator);
        this.filledCB = generator.generateJCheckBox("filled", null, this);
        this.filledCB.addItemListener(this);
        contentBox.add(this.filledCB);
        this.finishBoxes();
    }

    public int pointsNeeded() {
        return 2;
    }

    public boolean nextPoint(int num, Point p) {
        PTCircle shape = (PTCircle)this.getCurrentObject();
        if (num == 1) {
            shape.setCenter(p.x, p.y);
        }
        if (num == 2) {
            shape.setRadius(p.x - shape.getCenter().x);
        }
        return true;
    }

    public int getMinDist(PTGraphicObject go, Point p) {
        PTCircle pg = (PTCircle)go;
        Point a = new Point(pg.getCenter().x, pg.getCenter().y);
        Rectangle boundingBox = pg.getBoundingBox();
        if (boundingBox.contains(p.x, p.y)) {
            return 0;
        }
        Point b = new Point(a.x + pg.getRadius(), a.y);
        int minDist = Integer.MAX_VALUE;
        int newDist = MSMath.dist(p, a, b);
        if (newDist < minDist) {
            minDist = newDist;
        }
        b.translate(0, pg.getRadius());
        newDist = MSMath.dist(p, a, b);
        if (newDist < minDist) {
            minDist = newDist;
        }
        a.translate(pg.getRadius(), pg.getRadius());
        newDist = MSMath.dist(p, a, b);
        if (newDist < minDist) {
            minDist = newDist;
        }
        if ((newDist = MSMath.dist(p, a, pg.getCenter())) < minDist) {
            minDist = newDist;
        }
        return minDist;
    }

    public EditPoint[] getEditPoints(PTGraphicObject go) {
        PTCircle pg = (PTCircle)go;
        int radius = pg.getRadius();
        EditPoint[] result = new EditPoint[5];
        Point helper = pg.getCenter();
        result[0] = new EditPoint(1, helper);
        int x = helper.x;
        int y = helper.y;
        result[1] = new EditPoint(-1, new Point(x - radius, y));
        result[2] = new EditPoint(-2, new Point(x, y + radius));
        result[3] = new EditPoint(-3, new Point(x + radius, y));
        result[4] = new EditPoint(-4, new Point(x, y - radius));
        return result;
    }

    public void setProperties(XProperties props) {
        this.colorChooser.setColor(props.getColorProperty("Circle.color", Color.black));
        this.depthBox.setSelectedItem(props.getProperty("depth", String.valueOf(16)));
        this.fillColorChooser.setColor(props.getColorProperty("Circle.fillColor", Color.black));
        this.filledCB.setSelected(props.getBoolProperty("Circle.filled"));
    }

    public void getProperties(XProperties props) {
        props.put("Circle.color", this.colorChooser.getColor());
        props.put((Object)"depth", this.depthBox.getSelectedItem());
        props.put("Circle.fillColor", this.fillColorChooser.getColor());
        props.put("Circle.filled", this.filledCB.isSelected());
    }

    public void itemStateChanged(ItemEvent e) {
        PTCircle p = (PTCircle)this.getCurrentObject();
        if (e.getSource() == this.filledCB && p != null) {
            p.setFilled(this.filledCB.isSelected());
        }
        Animation.get().doChange();
        this.repaintNow();
    }

    public EditableObject createObject() {
        PTCircle pg = new PTCircle();
        this.storeAttributesInto(pg);
        return pg;
    }

    void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        PTCircle p = (PTCircle)eo;
        p.setColor(this.colorChooser.getColor());
        p.setFilled(this.filledCB.isSelected());
        p.setFillColor(this.fillColorChooser.getColor());
    }

    void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        PTCircle p = (PTCircle)eo;
        this.colorChooser.setColor(p.getColor());
        this.filledCB.setEnabled(true);
        this.filledCB.setSelected(p.isFilled());
        this.fillColorChooser.setColor(p.getFillColor());
    }

    public Editor getSecondaryEditor(EditableObject go) {
        CircleEditor result = new CircleEditor();
        result.extractAttributesFrom(go);
        return result;
    }

    public String getStatusLineMsg() {
        return AnimalTranslator.translateMessage("circleStatusLine", new Object[]{DrawCanvas.translateDrawButton(), DrawCanvas.translateFinishButton(), DrawCanvas.translateCancelButton()});
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        PTCircle p = (PTCircle)this.getCurrentObject();
        if (p != null) {
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
            this.repaintNow();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        PTCircle poly = (PTCircle)this.getCurrentObject();
        String eventName = event.getPropertyName();
        if (eventName.equals("color")) {
            poly.setColor((Color)event.getNewValue());
        } else if (eventName.equals("fillColor")) {
            poly.setFillColor((Color)event.getNewValue());
        }
        if (!event.getOldValue().equals(event.getNewValue())) {
            this.repaintNow();
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
        }
    }

    public String getBasicType() {
        return "Circle";
    }
}

