/*
 * Decompiled with CFR 0.152.
 */
package animal.editor;

import animal.animator.Animator;
import animal.editor.Editor;
import animal.gui.AnimalMainWindow;
import animal.main.Animation;
import animal.misc.AnimalTranslator;
import animal.misc.EditableObject;
import animal.misc.ObjectSelectionButton;
import animal.misc.XProperties;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AnimatorEditor
extends Editor {
    public ObjectSelectionButton objectSB;
    private JLabel stepLabel;

    public AnimatorEditor() {
        super(AnimalMainWindow.getWindowCoordinator().getAnimationOverview(false));
        JPanel c = new JPanel();
        c.setLayout(new FlowLayout(0));
        c.add(AnimalTranslator.getGUIBuilder().generateJLabel("step"));
        this.stepLabel = AnimalTranslator.getGUIBuilder().generateJLabel("end");
        c.add(this.stepLabel);
        this.objectSB = new ObjectSelectionButton(true);
        c.add(this.objectSB);
        this.addLayer(c);
    }

    public void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        Animator animator = (Animator)eo;
        this.stepLabel.setText(Integer.toString(animator.getStep()));
        this.objectSB.setObjectNums(animator.getObjectNums());
    }

    String isOK() {
        String result = super.isOK();
        if (result != null) {
            return result;
        }
        this.objectSB.checkObjects();
        int[] nums = this.objectSB.getObjectNums();
        int step = this.getStep();
        if (nums == null || nums.length == 0) {
            return AnimalTranslator.translateMessage("noObjectSelectedException");
        }
        result = Animation.get().checkSingleAnimator(nums, step, (Animator)this.getCurrentObject());
        return null;
    }

    public void storeAttributesInto(EditableObject a) {
        super.storeAttributesInto(a);
        Animator animator = (Animator)a;
        int step = this.getStep();
        if (step == 0) {
            step = AnimalMainWindow.getWindowCoordinator().getAnimationOverview(true).getStep();
            if (step == Integer.MAX_VALUE) {
                step = Animation.get().getLastStep();
            }
            if (!this.isPrimaryEditor()) {
                this.stepLabel.setText(Integer.toString(step));
            }
        }
        animator.setStep(step);
        animator.setObjectNums(this.objectSB.getObjectNums());
    }

    public void getProperties(XProperties props) {
    }

    public Editor getSecondaryEditor(EditableObject go) {
        return null;
    }

    public int getStep() {
        return this.getInt(this.stepLabel.getText(), 0);
    }

    public void repaintNow() {
        AnimalMainWindow.getWindowCoordinator().getAnimationOverview(true).initList(false);
    }
}

