/*
 * Decompiled with CFR 0.152.
 */
package animal.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class HTMLDisplay {
    JEditorPane html;
    JPanel panel = new JPanel();

    public HTMLDisplay() {
        this.panel.setLayout(new BorderLayout());
    }

    private void finalizeDisplay() {
        JFrame frame = new JFrame("HTML");
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)this.panel, "Center");
        this.panel.setPreferredSize(new Dimension(640, 480));
        frame.pack();
        frame.setVisible(true);
    }

    public void setURL(String path) throws MalformedURLException, IOException {
        URL url = null;
        try {
            url = this.getClass().getResource(path);
        }
        catch (Exception e) {
            System.err.println("Failed to open " + path);
            url = null;
        }
        if (url != null) {
            this.html = new JEditorPane(url);
            this.html.setEditable(false);
            this.html.addHyperlinkListener(this.createHyperLinkListener());
            JScrollPane scroller = new JScrollPane();
            JViewport vp = scroller.getViewport();
            vp.add(this.html);
            this.panel.add((Component)scroller, "Center");
            this.finalizeDisplay();
        }
    }

    public HyperlinkListener createHyperLinkListener() {
        return new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (e instanceof HTMLFrameHyperlinkEvent) {
                        ((HTMLDocument)HTMLDisplay.this.html.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)e);
                    } else {
                        try {
                            HTMLDisplay.this.html.setPage(e.getURL());
                        }
                        catch (IOException ioe) {
                            System.out.println("IOE: " + ioe);
                        }
                    }
                }
            }
        };
    }

    void updateDragEnabled(boolean dragEnabled) {
        this.html.setDragEnabled(dragEnabled);
    }
}

