/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.Rotation;
import animal.animator.TimedAnimator;
import animal.graphics.PTPoint;
import animal.main.AnimationState;
import animal.misc.XProperties;

public class Rotate
extends TimedAnimator {
    public static final String CENTER_LABEL = "center";
    public static final String DEGREES_LABEL = "degrees";
    public static final String TYPE_LABEL = "Rotate";
    private static final long serialVersionUID = 6013542892925447746L;
    private transient PTPoint center;

    public Rotate() {
    }

    public Rotate(int step, int objectNum, int totalTimeOrTicks, int centerNum, int degrees) {
        this(step, new int[]{objectNum}, "rotate", totalTimeOrTicks, centerNum, degrees);
    }

    public Rotate(int step, int[] objectNums, int totalTimeOrTicks, int centerNum, int degrees) {
        this(step, objectNums, "rotate", totalTimeOrTicks, centerNum, degrees);
    }

    public Rotate(int step, int objectNum, String method, int totalTimeOrTicks, int centerNum, int degrees) {
        this(step, new int[]{objectNum}, method, totalTimeOrTicks, centerNum, degrees);
    }

    public Rotate(int step, int[] objectNums, String method, int totalTimeOrTicks, int centerNum, int degrees) {
        super(step, objectNums, totalTimeOrTicks, method);
        this.setCenterNum(centerNum);
        this.setDegrees(degrees);
    }

    public Rotate(XProperties props) {
        this.setProperties(props);
    }

    public void init(AnimationState animationState, long time, double ticks) {
        super.init(animationState, time, ticks);
        this.center = (PTPoint)animationState.getCloneByNum(this.getCenterNum());
    }

    public String getAnimatorName() {
        return TYPE_LABEL;
    }

    public int getCenterNum() {
        return this.getProperties().getIntProperty(CENTER_LABEL, 1);
    }

    public int getFileVersion() {
        return 1;
    }

    public int getDegrees() {
        return this.getProperties().getIntProperty(DEGREES_LABEL, 360);
    }

    public Object getProperty(double factor) {
        if (this.center != null) {
            return new Rotation(this.center, -factor * (double)this.getDegrees() * Math.PI / 180.0);
        }
        return new Rotation(new PTPoint(0, 0), 0.0);
    }

    public int[] getTemporaryObjects() {
        return new int[]{this.getCenterNum()};
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public void setCenterNum(int centerNum) {
        this.getProperties().put(CENTER_LABEL, centerNum);
    }

    public void setDegrees(int degrees) {
        this.getProperties().put(DEGREES_LABEL, degrees);
    }

    public void discard() {
        this.center = null;
        super.discard();
    }

    public void scavenge(boolean[] usedValues) {
        super.scavenge(usedValues);
        usedValues[this.getCenterNum() - 1] = true;
    }

    public String toString() {
        return "rotate " + super.toString() + " for " + this.getDegrees() + " degrees, centered " + this.getCenterNum();
    }
}

