/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.MoveBase;
import animal.animator.TimedAnimator;
import animal.main.AnimationState;
import animal.misc.XProperties;
import java.awt.Point;

public class Move
extends TimedAnimator {
    public static final String MOVE_BASE_LABEL = "moveBaseNum";
    public static final String TYPE_LABEL = "Move";
    private static final long serialVersionUID = 5363620504730673229L;
    private int length;
    private MoveBase moveBase = null;

    public Move() {
    }

    public Move(int step, int objectNum, int totalTimeOrTicks, String method, int moveBaseNum) {
        this(step, new int[]{objectNum}, totalTimeOrTicks, method, moveBaseNum);
    }

    public Move(int step, int[] objectNums, int totalTimeOrTicks, String method, int moveBaseNum) {
        super(step, objectNums, totalTimeOrTicks, method);
        this.setMoveBaseNum(moveBaseNum);
    }

    public Move(XProperties props) {
        this.setProperties(props);
    }

    public void init(AnimationState animationState, long time, double ticks) {
        this.moveBase = (MoveBase)((Object)animationState.getCloneByNum(this.getMoveBaseNum()));
        if (this.moveBase != null) {
            this.length = this.moveBase.getLength();
        }
        super.init(animationState, time, ticks);
    }

    public String getAnimatorName() {
        return TYPE_LABEL;
    }

    public int getFileVersion() {
        return 1;
    }

    public int getMoveBaseNum() {
        return this.getProperties().getIntProperty(MOVE_BASE_LABEL);
    }

    public Object getProperty(double factor) {
        if (this.moveBase != null) {
            return this.moveBase.getPointAtLength((int)(factor * (double)this.length));
        }
        return new Point(0, 0);
    }

    public int[] getTemporaryObjects() {
        return new int[]{this.getMoveBaseNum()};
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public void setMoveBaseNum(int targetMoveBaseNum) {
        this.getProperties().put(MOVE_BASE_LABEL, targetMoveBaseNum);
    }

    public void discard() {
        this.moveBase = null;
        super.discard();
    }

    public void scavenge(boolean[] usedValues) {
        super.scavenge(usedValues);
        if (this.getMoveBaseNum() <= usedValues.length) {
            usedValues[this.getMoveBaseNum() - 1] = true;
        }
    }

    public String toString() {
        return "Move(" + this.getMethod() + ") " + super.toString() + " via " + this.getMoveBaseNum();
    }
}

