/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.GraphicObjectSpecificAnimation;
import animal.animator.TimedAnimator;
import animal.main.AnimalConfiguration;
import animal.main.AnimationState;
import animal.misc.XProperties;
import java.awt.Color;

public class Highlight
extends TimedAnimator
implements GraphicObjectSpecificAnimation {
    public static final String TYPE_LABEL = "Highlight";
    public static final String REAL_DEACTIVATE = "doRealCellDeactivation";
    private boolean[] hlState;
    private static boolean realDeactivation;

    public Highlight() {
        if (DefaultProperties == null) {
            Highlight.initializeDefaultProperties(AnimalConfiguration.getDefaultConfiguration().getProperties());
        }
        this.setProperties((XProperties)DefaultProperties.clone());
        realDeactivation = this.getProperties().getBoolProperty(this.mapKey(REAL_DEACTIVATE), false);
    }

    public Highlight(int length) {
        this();
        this.setHighlightState(length - 1, false);
    }

    public void init(AnimationState animationState, long time, double ticks) {
        super.init(animationState, time, ticks);
    }

    public Object getProperty(double factor) {
        int length = 1;
        if (this.hlState != null && this.hlState.length > 0) {
            length = this.hlState.length;
        }
        double[] states = new double[length];
        int i = 0;
        while (i < length) {
            states[i] = this.getHighlightState(i) ? factor : -1.0;
            ++i;
        }
        return states;
    }

    public boolean getHighlightState(int index) {
        if (this.hlState == null || index < 0 || index >= this.hlState.length) {
            return false;
        }
        return this.hlState[index];
    }

    public boolean[] getHighlightState() {
        return this.hlState;
    }

    public void setHighlightState(int index, boolean state) throws IndexOutOfBoundsException {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Try to access a negative array index.");
        }
        if (this.hlState == null) {
            this.hlState = new boolean[index + 1];
            int i = 0;
            while (i < index) {
                this.hlState[i] = false;
                ++i;
            }
        } else if (index >= this.hlState.length) {
            boolean[] temp = this.hlState;
            this.hlState = new boolean[index];
            int i = 0;
            while (i < temp.length) {
                this.hlState[i] = temp[i];
                ++i;
            }
            i = temp.length;
            while (i < index) {
                this.hlState[i] = false;
                ++i;
            }
        }
        this.hlState[index] = state;
    }

    public void setHighlightState(boolean[] states) {
        this.hlState = states;
    }

    public static boolean realDeactivation() {
        return realDeactivation;
    }

    public static void initializeDefaultProperties(XProperties properties) {
        DefaultProperties = Highlight.extractDefaultProperties(properties, TYPE_LABEL);
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL, "Unhighlight"};
    }

    public String getAnimatorName() {
        return TYPE_LABEL;
    }

    public static Color fadeColor(Color old, Color now, double part) {
        if (part < 0.0 || part > 1.0) {
            return old;
        }
        int r = (int)(part * (double)now.getRed() + (1.0 - part) * (double)old.getRed());
        int g = (int)(part * (double)now.getGreen() + (1.0 - part) * (double)old.getGreen());
        int b = (int)(part * (double)now.getBlue() + (1.0 - part) * (double)old.getBlue());
        return new Color(r, g, b);
    }

    public String toString() {
        if (this.hlState == null || this.hlState.length == 0) {
            return "No highlight element set!";
        }
        int counter = 0;
        String toString = new String();
        int i = this.hlState.length - 1;
        while (i >= 0) {
            if (this.hlState[i]) {
                if (counter >= 1) {
                    toString = String.valueOf(String.valueOf(i)) + ", " + toString;
                    ++counter;
                } else {
                    toString = String.valueOf(i);
                    ++counter;
                }
            }
            --i;
        }
        toString = String.valueOf(this.getMethod()) + " " + toString + " of " + super.toString();
        return toString;
    }

    public String[] getSupportedTypes() {
        return new String[]{"StringArray", "IntArray", "Graph"};
    }
}

